/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.boydti.fawe.object.mask.ResettableMask;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;

public class RadiusMask
extends AbstractMask
implements ResettableMask {
    private transient BlockVector3 pos;
    private final int minSqr;
    private final int maxSqr;

    public RadiusMask(int min, int max) {
        this.minSqr = min * min;
        this.maxSqr = max * max;
    }

    private RadiusMask(Integer minSqr, Integer maxSqr) {
        this.minSqr = minSqr;
        this.maxSqr = maxSqr;
    }

    @Override
    public void reset() {
        this.pos = null;
    }

    @Override
    public boolean test(BlockVector3 to) {
        int dx;
        int d2;
        if (this.pos == null) {
            this.pos = to.toImmutable();
        }
        if ((d2 = (dx = this.pos.getBlockX() - to.getBlockX()) * dx) > this.maxSqr) {
            return false;
        }
        int dz = this.pos.getBlockZ() - to.getBlockZ();
        if ((d2 += dz * dz) > this.maxSqr) {
            return false;
        }
        int dy = this.pos.getBlockY() - to.getBlockY();
        return (d2 += dy * dy) >= this.minSqr && d2 <= this.maxSqr;
    }

    @Override
    public Mask copy() {
        return new RadiusMask(this.minSqr, this.maxSqr);
    }
}

