/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.object.DataAnglePattern;
import com.boydti.fawe.util.TextureHolder;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;

public class AngleColorPattern
extends DataAnglePattern {
    protected transient TextureHolder holder;

    public AngleColorPattern(Extent extent, TextureHolder holder, int distance) {
        super(extent, distance);
        this.holder = holder.getTextureUtil();
    }

    public int getColor(int color, int slope) {
        if (slope == 0) {
            return color;
        }
        double newFactor = 1.0 - Math.min(1.0, (double)slope * this.factor);
        int newRed = (int)((double)(color >> 16 & 0xFF) * newFactor);
        int newGreen = (int)((double)(color >> 8 & 0xFF) * newFactor);
        int newBlue = (int)((double)(color >> 0 & 0xFF) * newFactor);
        return ((color >> 24 & 0xFF) << 24) + (newRed << 16) + (newGreen << 8) + (newBlue << 0);
    }

    @Override
    public <T extends BlockStateHolder<T>> int getSlope(T block, BlockVector3 vector, Extent extent) {
        int slope = super.getSlope(block, vector, extent);
        if (slope != -1) {
            BlockState below;
            int x = vector.getBlockX();
            int y = vector.getBlockY();
            int z = vector.getBlockZ();
            int height = extent.getNearestSurfaceTerrainBlock(x, z, y, 0, this.maxY);
            if (height > 0 && !(below = extent.getBlock(x, height - 1, z)).getBlockType().getMaterial().isMovementBlocker()) {
                return Integer.MAX_VALUE;
            }
        }
        return slope;
    }

    @Override
    public BaseBlock apply(BlockVector3 position) {
        BaseBlock block = this.extent.getFullBlock(position);
        int slope = this.getSlope(block, position, this.extent);
        if (slope == -1) {
            return block;
        }
        int color = this.holder.getTextureUtil().getColor(block.getBlockType());
        if (color == 0) {
            return block;
        }
        int newColor = this.getColor(color, slope);
        return this.holder.getTextureUtil().getNearestBlock(newColor).getDefaultState().toBaseBlock();
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        BlockState block = get.getBlock(extent);
        int slope = this.getSlope(block, get, extent);
        if (slope == -1) {
            return false;
        }
        int color = this.holder.getTextureUtil().getColor(block.getBlockType());
        if (color == 0) {
            return false;
        }
        int newColor = this.getColor(color, slope);
        BlockType newBlock = this.holder.getTextureUtil().getNearestBlock(newColor);
        if (newBlock == null) {
            return false;
        }
        return set.setBlock(extent, newBlock.getDefaultState());
    }
}

