/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;

public class MaskedPattern
extends AbstractPattern {
    private final Pattern primary;
    private final Pattern secondary;
    private Mask mask;

    public MaskedPattern(Mask mask, Pattern primary, Pattern secondary) {
        this.mask = mask;
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public BaseBlock apply(BlockVector3 position) {
        if (this.mask.test(position)) {
            return this.primary.apply(position);
        }
        return this.secondary.apply(position);
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        if (this.mask.test(get)) {
            return this.primary.apply(extent, get, set);
        }
        return this.secondary.apply(extent, get, set);
    }
}

