/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.object.pattern.ResettablePattern;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;

public class RelativePattern
extends AbstractPattern
implements ResettablePattern {
    private final Pattern pattern;
    private BlockVector3 origin;
    private final MutableBlockVector3 mutable = new MutableBlockVector3();

    public RelativePattern(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public BaseBlock apply(BlockVector3 pos) {
        if (this.origin == null) {
            this.origin = pos;
        }
        this.mutable.mutX(pos.getX() - this.origin.getX());
        this.mutable.mutY(pos.getY() - this.origin.getY());
        this.mutable.mutZ(pos.getZ() - this.origin.getZ());
        return this.pattern.apply(this.mutable);
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        if (this.origin == null) {
            this.origin = set;
        }
        this.mutable.mutX(set.getX() - this.origin.getX());
        this.mutable.mutY(set.getY() - this.origin.getY());
        this.mutable.mutZ(set.getZ() - this.origin.getZ());
        return this.pattern.apply(extent, get, this.mutable);
    }

    @Override
    public void reset() {
        this.origin = null;
    }
}

