/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.util.TextureUtil;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockType;

public class ShadePattern
extends AbstractPattern {
    private final TextureUtil util;
    private final Extent extent;
    private final boolean darken;

    public ShadePattern(Extent extent, boolean darken, TextureUtil util) {
        Preconditions.checkNotNull((Object)extent);
        this.extent = extent;
        this.util = util;
        this.darken = darken;
    }

    @Override
    public BaseBlock apply(BlockVector3 position) {
        BlockType block = this.extent.getBlock(position).getBlockType();
        return (this.darken ? this.util.getDarkerBlock(block) : this.util.getLighterBlock(block)).getDefaultState().toBaseBlock();
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        BlockType newType;
        BlockType type = get.getBlock(extent).getBlockType();
        BlockType blockType = newType = this.darken ? this.util.getDarkerBlock(type) : this.util.getLighterBlock(type);
        if (type != newType) {
            return set.setBlock(extent, newType.getDefaultState());
        }
        return false;
    }
}

