/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.regions;

import com.boydti.fawe.object.collection.BlockVectorSet;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.World;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class FuzzyRegion
extends AbstractRegion {
    private final Mask mask;
    private BlockVectorSet set = new BlockVectorSet();
    private int minX;
    private int minY;
    private int minZ = Integer.MAX_VALUE;
    private int maxX;
    private int maxY;
    private int maxZ;
    private Extent extent;

    public FuzzyRegion(World world, Extent editSession, Mask mask) {
        super(world);
        this.minY = Integer.MAX_VALUE;
        this.minX = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.extent = editSession;
        this.mask = mask;
    }

    public Mask getMask() {
        return this.mask;
    }

    @Override
    public int getArea() {
        return this.set.size();
    }

    public void select(int x, int y, int z) {
        RecursiveVisitor search = new RecursiveVisitor(this.mask, p -> {
            this.setMinMax(p.getBlockX(), p.getBlockY(), p.getBlockZ());
            return true;
        }, 256);
        search.setVisited(this.set);
        search.visit(BlockVector3.at(x, y, z));
        Operations.completeBlindly(search);
    }

    @Override
    @NotNull
    public Iterator<BlockVector3> iterator() {
        return this.set.iterator();
    }

    private final void setMinMax(int x, int y, int z) {
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (x < this.minX) {
            this.minX = x;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (y < this.minY) {
            this.minY = y;
        }
    }

    public final void set(int x, int y, int z) throws RegionOperationException {
        this.set.add(x, y, z);
        this.setMinMax(x, y, z);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.set.contains(x, y, z);
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return BlockVector3.at(this.minX, this.minY, this.minZ);
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return BlockVector3.at(this.maxX, this.maxY, this.maxZ);
    }

    @Override
    public void expand(BlockVector3 ... changes) throws RegionOperationException {
        throw new RegionOperationException("Selection cannot expand");
    }

    @Override
    public void contract(BlockVector3 ... changes) throws RegionOperationException {
        throw new RegionOperationException("Selection cannot contract");
    }

    @Override
    public boolean contains(BlockVector3 position) {
        return this.contains(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    @Override
    public void shift(BlockVector3 change) throws RegionOperationException {
        throw new RegionOperationException("Selection cannot be shifted");
    }

    public void setExtent(EditSession extent) {
        this.extent = extent;
    }

    @Override
    public boolean containsEntireCuboid(int bx, int tx, int by, int ty, int bz, int tz) {
        return false;
    }
}

