/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.task;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.util.TaskManager;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class SingleThreadIntervalQueue<T> {
    private final ConcurrentMap<T, Long> objMap = new ConcurrentHashMap<T, Long>();
    private final Runnable task;
    private AtomicBoolean queued = new AtomicBoolean();

    public SingleThreadIntervalQueue(final int interval) {
        this.task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long allowedTick = Fawe.get().getTimer().getTick() - 1L;
                Iterator iter = SingleThreadIntervalQueue.this.objMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Long time = (Long)entry.getValue();
                    if (time >= allowedTick) continue;
                    Object obj = entry.getKey();
                    iter.remove();
                    SingleThreadIntervalQueue.this.operate(obj);
                }
                ConcurrentMap concurrentMap = SingleThreadIntervalQueue.this.objMap;
                synchronized (concurrentMap) {
                    if (!SingleThreadIntervalQueue.this.objMap.isEmpty()) {
                        TaskManager.IMP.laterAsync(this, interval);
                    } else {
                        SingleThreadIntervalQueue.this.queued.set(false);
                    }
                }
            }
        };
    }

    public abstract void operate(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dequeue(T obj) {
        ConcurrentMap<T, Long> concurrentMap = this.objMap;
        synchronized (concurrentMap) {
            return this.objMap.remove(obj) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(T obj) {
        ConcurrentMap<T, Long> concurrentMap = this.objMap;
        synchronized (concurrentMap) {
            this.objMap.put(obj, Fawe.get().getTimer().getTick());
            if (!this.queued.get()) {
                this.queued.set(true);
                TaskManager.IMP.laterAsync(this.task, 3);
            }
        }
    }
}

