/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

public class CachedMathMan {
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final int ATAN2_DIM;
    private static final float INV_ATAN2_DIM_MINUS_1;
    private static final float[] atan2;
    private static float[] ANGLES;
    private static char[] SQRT;

    protected static int usqrt(int i) {
        return SQRT[i];
    }

    protected static float sinInexact(double paramFloat) {
        return ANGLES[(int)(paramFloat * 10430.3779296875) & 0xFFFF];
    }

    protected static float cosInexact(double paramFloat) {
        return ANGLES[(int)(paramFloat * 10430.3779296875 + 16384.0) & 0xFFFF];
    }

    protected static float atan2(float i, float j) {
        float add;
        float mul;
        if (j < 0.0f) {
            if (i < 0.0f) {
                j = -j;
                i = -i;
                mul = 1.0f;
            } else {
                j = -j;
                mul = -1.0f;
            }
            add = (float)(-Math.PI);
        } else {
            if (i < 0.0f) {
                i = -i;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = 1.0f / (Math.max(j, i) * INV_ATAN2_DIM_MINUS_1);
        int xi = (int)(j * invDiv);
        int yi = (int)(i * invDiv);
        return (atan2[yi * ATAN2_DIM + xi] + add) * mul;
    }

    static {
        int i;
        ATAN2_DIM = (int)Math.sqrt(16384.0);
        INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(ATAN2_DIM - 1);
        atan2 = new float[16384];
        for (i = 0; i < ATAN2_DIM; ++i) {
            for (int j = 0; j < ATAN2_DIM; ++j) {
                float x0 = (float)i / (float)ATAN2_DIM;
                float y0 = (float)j / (float)ATAN2_DIM;
                CachedMathMan.atan2[j * CachedMathMan.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
            }
        }
        ANGLES = new float[65536];
        for (i = 0; i < 65536; ++i) {
            CachedMathMan.ANGLES[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
        SQRT = new char[65536];
        for (i = 0; i < SQRT.length; ++i) {
            CachedMathMan.SQRT[i] = (char)Math.round(Math.sqrt(i));
        }
    }
}

