/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.IQueueChunk;
import com.boydti.fawe.beta.IQueueExtent;
import com.boydti.fawe.beta.implementation.lighting.NMSRelighter;
import com.boydti.fawe.beta.implementation.lighting.NullRelighter;
import com.boydti.fawe.beta.implementation.lighting.RelightProcessor;
import com.boydti.fawe.beta.implementation.lighting.Relighter;
import com.boydti.fawe.beta.implementation.processors.LimitExtent;
import com.boydti.fawe.beta.implementation.queue.ParallelQueueExtent;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.logging.rollback.RollbackOptimizedHistory;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.HistoryExtent;
import com.boydti.fawe.object.NullChangeSet;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.RelightMode;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.object.changeset.AbstractChangeSet;
import com.boydti.fawe.object.changeset.BlockBagChangeSet;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.boydti.fawe.object.changeset.MemoryOptimizedHistory;
import com.boydti.fawe.object.extent.FaweRegionExtent;
import com.boydti.fawe.object.extent.MultiRegionExtent;
import com.boydti.fawe.object.extent.SingleRegionExtent;
import com.boydti.fawe.object.extent.SlowExtent;
import com.boydti.fawe.object.extent.StripNBTExtent;
import com.boydti.fawe.util.MemUtil;
import com.boydti.fawe.util.Permission;
import com.boydti.fawe.wrappers.WorldWrapper;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.util.Identifiable;
import com.sk89q.worldedit.util.eventbus.EventBus;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class EditSessionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDelegateExtent.class);
    @NotNull
    private World world;
    private Player player;
    private FaweLimit limit;
    private AbstractChangeSet changeSet;
    private Region[] allowedRegions;
    private Boolean autoQueue;
    private Boolean fastmode;
    private Boolean checkMemory;
    private Boolean combineStages;
    @NotNull
    private EventBus eventBus = WorldEdit.getInstance().getEventBus();
    private BlockBag blockBag;
    private EditSessionEvent event;
    private String command;
    private RelightMode relightMode;
    private Relighter relighter;
    private Boolean wnaMode;
    private AbstractChangeSet changeTask;
    private Extent bypassHistory;
    private Extent bypassAll;
    private Extent extent;
    private boolean compiled;
    private boolean wrapped;

    public EditSessionBuilder(@NotNull World world) {
        Preconditions.checkNotNull((Object)world);
        this.world = world;
    }

    public EditSessionBuilder player(@Nullable Player player) {
        this.player = player;
        return this.setDirty();
    }

    public EditSessionBuilder limit(@Nullable FaweLimit limit) {
        this.limit = limit;
        return this.setDirty();
    }

    public EditSessionBuilder limitUnlimited() {
        return this.limit(FaweLimit.MAX.copy());
    }

    public EditSessionBuilder limitUnprocessed(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.limitUnlimited();
        FaweLimit tmp = player.getLimit();
        this.limit.INVENTORY_MODE = tmp.INVENTORY_MODE;
        return this.setDirty();
    }

    public EditSessionBuilder changeSet(@Nullable AbstractChangeSet changeSet) {
        this.changeSet = changeSet;
        return this.setDirty();
    }

    public EditSessionBuilder changeSetNull() {
        return this.changeSet(new NullChangeSet(this.world));
    }

    public EditSessionBuilder world(@NotNull World world) {
        Preconditions.checkNotNull((Object)world);
        this.world = world;
        return this.setDirty();
    }

    public EditSessionBuilder command(String command) {
        this.command = command;
        return this;
    }

    public EditSessionBuilder changeSet(boolean disk, @Nullable UUID uuid, int compression) {
        this.changeSet = disk ? (Settings.IMP.HISTORY.USE_DATABASE ? new RollbackOptimizedHistory(this.world, uuid) : new DiskStorageHistory(this.world, uuid)) : new MemoryOptimizedHistory(this.world);
        return this.setDirty();
    }

    public EditSessionBuilder allowedRegions(@Nullable Region[] allowedRegions) {
        this.allowedRegions = allowedRegions;
        return this.setDirty();
    }

    @Deprecated
    public EditSessionBuilder allowedRegions(@Nullable RegionWrapper[] allowedRegions) {
        this.allowedRegions = allowedRegions;
        return this.setDirty();
    }

    public EditSessionBuilder allowedRegions(@Nullable RegionWrapper allowedRegion) {
        this.allowedRegions = allowedRegion == null ? null : allowedRegion.toArray();
        return this.setDirty();
    }

    public EditSessionBuilder allowedRegionsEverywhere() {
        return this.allowedRegions(new Region[]{RegionWrapper.GLOBAL()});
    }

    public EditSessionBuilder autoQueue(@Nullable Boolean autoQueue) {
        this.autoQueue = autoQueue;
        return this.setDirty();
    }

    public EditSessionBuilder fastmode(@Nullable Boolean fastmode) {
        this.fastmode = fastmode;
        return this.setDirty();
    }

    public EditSessionBuilder relightMode(@Nullable RelightMode relightMode) {
        this.relightMode = relightMode;
        return this.setDirty();
    }

    public EditSessionBuilder checkMemory(@Nullable Boolean checkMemory) {
        this.checkMemory = checkMemory;
        return this.setDirty();
    }

    public EditSessionBuilder combineStages(@Nullable Boolean combineStages) {
        this.combineStages = combineStages;
        return this.setDirty();
    }

    public EditSessionBuilder blockBag(@Nullable BlockBag blockBag) {
        this.blockBag = blockBag;
        return this.setDirty();
    }

    public EditSessionBuilder eventBus(@NotNull EventBus eventBus) {
        this.eventBus = eventBus;
        return this.setDirty();
    }

    public EditSessionBuilder event(@Nullable EditSessionEvent event) {
        this.event = event;
        return this.setDirty();
    }

    public EditSessionBuilder forceWNA() {
        this.wnaMode = true;
        return this.setDirty();
    }

    private EditSessionBuilder setDirty() {
        this.compiled = false;
        return this;
    }

    private Extent wrapExtent(Extent extent, EventBus eventBus, EditSessionEvent event, EditSession.Stage stage) {
        event = event.clone(stage);
        event.setExtent(extent);
        eventBus.post(event);
        if (event.isCancelled()) {
            return new com.boydti.fawe.object.extent.NullExtent(extent, FaweCache.MANUAL);
        }
        Extent toReturn = event.getExtent();
        if (toReturn instanceof NullExtent) {
            return new com.boydti.fawe.object.extent.NullExtent(toReturn, FaweCache.MANUAL);
        }
        if (toReturn != extent) {
            String className = toReturn.getClass().getName().toLowerCase(Locale.ROOT);
            for (String allowed : Settings.IMP.EXTENT.ALLOWED_PLUGINS) {
                if (!className.contains(allowed.toLowerCase(Locale.ROOT))) continue;
                this.wrapped = true;
                return toReturn;
            }
            if (Settings.IMP.EXTENT.DEBUG) {
                if (event.getActor() != null) {
                    event.getActor().printDebug("Potentially unsafe extent blocked: " + toReturn.getClass().getName());
                    event.getActor().printDebug(" - For area restrictions, it is recommended to use the FaweAPI");
                    event.getActor().printDebug(" - For block logging, it is recommended to use BlocksHub");
                    event.getActor().printDebug(" - To allow this plugin add it to the FAWE `allowed-plugins` list");
                    event.getActor().printDebug(" - To hide this message set `debug` to false in the FAWE config.yml");
                } else {
                    logger.debug("Potentially unsafe extent blocked: " + toReturn.getClass().getName());
                    logger.debug(" - For area restrictions, it is recommended to use the FaweAPI");
                    logger.debug(" - For block logging, it is recommended to use BlocksHub");
                    logger.debug(" - To allow this plugin add it to the FAWE `allowed-plugins` list");
                    logger.debug(" - To hide this message set `debug` to false in the FAWE config.yml");
                }
            }
        }
        return extent;
    }

    public EditSessionBuilder compile() {
        if (this.compiled) {
            return this;
        }
        this.compiled = true;
        this.wrapped = false;
        if (this.event == null) {
            this.event = new EditSessionEvent(this.world, this.player, -1, null);
        }
        if (this.player == null && this.event.getActor() != null) {
            this.player = (Player)this.event.getActor();
        }
        if (this.limit == null) {
            this.limit = this.player == null ? FaweLimit.MAX : this.player.getLimit();
        }
        if (this.autoQueue == null) {
            this.autoQueue = true;
        }
        if (this.fastmode == null) {
            this.fastmode = this.player == null ? Boolean.valueOf(!Settings.IMP.HISTORY.ENABLE_FOR_CONSOLE) : Boolean.valueOf(this.player.getSession().hasFastMode());
        }
        if (this.checkMemory == null) {
            this.checkMemory = this.player != null && this.fastmode == false;
        }
        if (this.checkMemory.booleanValue() && MemUtil.isMemoryLimitedSlow()) {
            if (Permission.hasPermission(this.player, "worldedit.fast")) {
                this.player.print(TranslatableComponent.of("fawe.info.worldedit.oom.admin"));
            }
            throw FaweCache.LOW_MEMORY;
        }
        this.blockBag = this.limit.INVENTORY_MODE != 0 ? this.blockBag : null;
        this.limit = this.limit.copy();
        if (this.extent == null) {
            boolean placeChunks;
            Extent queue = null;
            World unwrapped = WorldWrapper.unwrap(this.world);
            boolean bl = placeChunks = this.fastmode != false || this.limit.FAST_PLACEMENT;
            if (placeChunks && (this.wnaMode == null || !this.wnaMode.booleanValue())) {
                this.wnaMode = false;
                if (unwrapped instanceof IQueueExtent) {
                    queue = (IQueueExtent<IQueueChunk>)((Object)unwrapped);
                    this.extent = queue;
                } else if (Settings.IMP.QUEUE.PARALLEL_THREADS > 1 && !Fawe.isMainThread()) {
                    ParallelQueueExtent parallel = new ParallelQueueExtent(Fawe.get().getQueueHandler(), this.world, this.fastmode);
                    queue = parallel.getExtent();
                    this.extent = parallel;
                } else {
                    this.extent = queue = Fawe.get().getQueueHandler().getQueue(this.world);
                }
            } else {
                this.wnaMode = true;
                this.extent = this.world;
            }
            Extent root = this.extent;
            if (this.combineStages == null) {
                this.combineStages = Settings.IMP.HISTORY.COMBINE_STAGES && this.limit.FAST_PLACEMENT && this.blockBag == null;
            }
            this.extent = this.bypassAll = this.wrapExtent(this.extent, this.eventBus, this.event, EditSession.Stage.BEFORE_CHANGE);
            this.bypassHistory = this.extent = this.wrapExtent(this.bypassAll, this.eventBus, this.event, EditSession.Stage.BEFORE_REORDER);
            if (!this.fastmode.booleanValue() || this.changeSet != null) {
                if (this.changeSet == null) {
                    if (Settings.IMP.HISTORY.USE_DISK) {
                        UUID uuid;
                        UUID uUID = uuid = this.player == null ? Identifiable.CONSOLE : this.player.getUniqueId();
                        this.changeSet = Settings.IMP.HISTORY.USE_DATABASE ? new RollbackOptimizedHistory(this.world, uuid) : new DiskStorageHistory(this.world, uuid);
                    } else {
                        if (!this.combineStages.booleanValue() || Settings.IMP.HISTORY.COMPRESSION_LEVEL == 0) {
                            // empty if block
                        }
                        this.changeSet = new MemoryOptimizedHistory(this.world);
                    }
                }
                if (this.limit.SPEED_REDUCTION > 0) {
                    this.extent = this.bypassHistory = new SlowExtent(this.bypassHistory, this.limit.SPEED_REDUCTION);
                }
                if (this.command != null && this.changeSet instanceof RollbackOptimizedHistory) {
                    ((RollbackOptimizedHistory)this.changeSet).setCommand(this.command);
                }
                if (!(this.changeSet instanceof NullChangeSet)) {
                    if (this.blockBag != null) {
                        this.changeSet = new BlockBagChangeSet(this.changeSet, this.blockBag, this.limit.INVENTORY_MODE == 1);
                    }
                    if (this.combineStages.booleanValue()) {
                        this.changeTask = this.changeSet;
                        this.extent = this.extent.enableHistory(this.changeSet);
                    } else {
                        this.extent = new HistoryExtent(this.extent, this.changeSet);
                    }
                }
            }
            if (!(this.allowedRegions != null || this.player == null || this.player.hasPermission("fawe.bypass") || this.player.hasPermission("fawe.bypass.regions") || root instanceof VirtualWorld)) {
                this.allowedRegions = this.player.getCurrentRegions();
            }
            FaweRegionExtent regionExtent = null;
            if (this.allowedRegions != null) {
                regionExtent = this.allowedRegions.length == 0 ? new com.boydti.fawe.object.extent.NullExtent(this.extent, FaweCache.NO_REGION) : (this.allowedRegions.length == 1 ? new SingleRegionExtent(this.extent, this.limit, this.allowedRegions[0]) : new MultiRegionExtent(this.extent, this.limit, this.allowedRegions));
            } else {
                this.allowedRegions = new Region[]{RegionWrapper.GLOBAL()};
            }
            if (placeChunks && (this.relightMode != null && this.relightMode != RelightMode.NONE || this.relightMode == null && Settings.IMP.LIGHTING.MODE > 0)) {
                this.relighter = new NMSRelighter((IQueueExtent<IQueueChunk>)queue, Settings.IMP.LIGHTING.DO_HEIGHTMAPS, this.relightMode != null ? this.relightMode : RelightMode.valueOf(Settings.IMP.LIGHTING.MODE));
                this.extent.addProcessor(new RelightProcessor(this.relighter));
            } else {
                this.relighter = NullRelighter.INSTANCE;
            }
            if (this.limit != null && !this.limit.isUnlimited() && regionExtent != null) {
                this.extent = new LimitExtent(regionExtent, this.limit);
            } else if (this.limit != null && !this.limit.isUnlimited()) {
                this.extent = new LimitExtent(this.extent, this.limit);
            } else if (regionExtent != null) {
                this.extent = regionExtent;
            }
            if (this.limit != null && this.limit.STRIP_NBT != null && !this.limit.STRIP_NBT.isEmpty()) {
                this.extent = new StripNBTExtent(this.extent, this.limit.STRIP_NBT);
            }
            this.extent = this.wrapExtent(this.extent, this.eventBus, this.event, EditSession.Stage.BEFORE_HISTORY);
        }
        return this;
    }

    public EditSession build() {
        return new EditSession(this);
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    public Extent getExtent() {
        return this.extent != null ? this.extent : this.world;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public Extent getBypassHistory() {
        return this.bypassHistory;
    }

    public Extent getBypassAll() {
        return this.bypassAll;
    }

    @NotNull
    public FaweLimit getLimit() {
        return this.limit;
    }

    public Player getPlayer() {
        return this.player;
    }

    public AbstractChangeSet getChangeTask() {
        return this.changeTask;
    }

    public BlockBag getBlockBag() {
        return this.blockBag;
    }

    public Relighter getRelighter() {
        return this.relighter;
    }

    public boolean isWNAMode() {
        return this.wnaMode;
    }

    @Nullable
    public Region[] getAllowedRegions() {
        return this.allowedRegions;
    }
}

