/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.util.ReflectionUtils9;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtils {
    public static <T> T as(Class<T> t, Object o) {
        return t.isInstance(o) ? (T)t.cast(o) : null;
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName) {
        return ReflectionUtils9.addEnum(enumType, enumName);
    }

    public static void setAccessibleNonFinal(Field field) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            try {
                Field lookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                lookupField.setAccessible(true);
                ((MethodHandles.Lookup)lookupField.get(null)).findSetter(Field.class, "modifiers", Integer.TYPE).invokeExact(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ReflectionUtils.setAccessibleNonFinal(field);
        field.set(target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            AccessibleObject.setAccessible(new Field[]{field}, true);
            ReflectionUtils.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    static void cleanEnumCache(Class<?> enumClass) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ReflectionUtils.blankField(enumClass, "enumConstantDirectory");
        ReflectionUtils.blankField(enumClass, "enumConstants");
    }

    public static Object getHandle(Object wrapper) {
        Method getHandle = ReflectionUtils.makeMethod(wrapper.getClass(), "getHandle", new Class[0]);
        return ReflectionUtils.callMethod(getHandle, wrapper, new Object[0]);
    }

    public static Method makeMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            return clazz.getDeclaredMethod(methodName, parameters);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T callMethod(Method method, Object instance, Object ... parameters) {
        if (method == null) {
            throw new RuntimeException("No such method");
        }
        method.setAccessible(true);
        try {
            return (T)method.invoke(instance, parameters);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> Constructor<T> makeConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T callConstructor(Constructor<T> constructor, Object ... parameters) {
        if (constructor == null) {
            throw new RuntimeException("No such constructor");
        }
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(parameters);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Field makeField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Field findField(Class<?> clazz, Class<?> type, int hasMods, int noMods) {
        for (Field field : clazz.getDeclaredFields()) {
            int mods;
            if (type != null && !type.isAssignableFrom(field.getType()) || ((mods = field.getModifiers()) & hasMods) != hasMods || (mods & noMods) != 0) continue;
            return ReflectionUtils.setAccessible(field);
        }
        return null;
    }

    public static Field findField(Class<?> clazz, Class<?> type) {
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type) continue;
            return ReflectionUtils.setAccessible(field);
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, Class<?> returnType, Class<?> ... params) {
        return ReflectionUtils.findMethod(clazz, 0, returnType, params);
    }

    public static Method findMethod(Class<?> clazz, int index, int hasMods, int noMods, Class<?> returnType, Class<?> ... params) {
        block0: for (Method method : ReflectionUtils.sortMethods(clazz.getDeclaredMethods())) {
            if (returnType != null && method.getReturnType() != returnType) continue;
            Class<?>[] mp = method.getParameterTypes();
            int mods = method.getModifiers();
            if ((mods & hasMods) != hasMods || (mods & noMods) != 0) continue;
            if (params == null) {
                if (index-- != 0) continue;
                return ReflectionUtils.setAccessible(method);
            }
            if (mp.length != params.length) continue;
            for (int i = 0; i < mp.length; ++i) {
                if (mp[i] != params[i]) continue block0;
            }
            if (index-- != 0) continue;
            return ReflectionUtils.setAccessible(method);
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, int index, Class<?> returnType, Class<?> ... params) {
        return ReflectionUtils.findMethod(clazz, index, 0, 0, returnType, params);
    }

    public static Method[] sortMethods(Method[] methods) {
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        return methods;
    }

    public static Field[] sortFields(Field[] fields) {
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        return fields;
    }

    public static <T extends AccessibleObject> T setAccessible(T ao) {
        ao.setAccessible(true);
        return ao;
    }

    public static <T> T getField(@NotNull Field field, Object instance) {
        field.setAccessible(true);
        try {
            return (T)field.get(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setField(@NotNull Field field, Object instance, Object value) {
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static <T> Class<? extends T> getClass(String name, Class<T> superClass) {
        try {
            return Class.forName(name).asSubclass(superClass);
        }
        catch (ClassCastException | ClassNotFoundException ex) {
            return null;
        }
    }

    public static RefClass getRefClass(Class<?> clazz) {
        return new RefClass(clazz);
    }

    public static class RefField {
        private final Field field;

        private RefField(Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        public Field getField() {
            return this.field;
        }

        public RefClass getRefClass() {
            return new RefClass(this.field.getDeclaringClass());
        }

        public RefClass getFieldRefClass() {
            return new RefClass(this.field.getType());
        }

        public RefExecutor of(Object e) {
            return new RefExecutor(e);
        }

        public class RefExecutor {
            final Object executor;

            public RefExecutor(Object e) {
                this.executor = e;
            }

            public void set(Object param) {
                try {
                    RefField.this.field.set(this.executor, param);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public Object get() {
                try {
                    return RefField.this.field.get(this.executor);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class RefConstructor {
        private final Constructor<?> constructor;

        private RefConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
            constructor.setAccessible(true);
        }

        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        public RefClass getRefClass() {
            return new RefClass(this.constructor.getDeclaringClass());
        }

        public Object create(Object ... params) {
            try {
                return this.constructor.newInstance(params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class RefMethod {
        private final Method method;

        private RefMethod(Method method) {
            this.method = method;
            method.setAccessible(true);
        }

        public Method getMethod() {
            return this.method;
        }

        public RefClass getRefClass() {
            return new RefClass(this.method.getDeclaringClass());
        }

        public RefClass getReturnRefClass() {
            return new RefClass(this.method.getReturnType());
        }

        public RefExecutor of(Object e) {
            return new RefExecutor(e);
        }

        public Object call(Object ... params) {
            try {
                return this.method.invoke(null, params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public class RefExecutor {
            final Object executor;

            public RefExecutor(Object executor) {
                this.executor = executor;
            }

            public Object call(Object ... params) {
                try {
                    return RefMethod.this.method.invoke(this.executor, params);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class RefClass {
        private final Class<?> clazz;

        private RefClass(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public boolean isInstance(Object object) {
            return this.clazz.isInstance(object);
        }

        public RefMethod getMethod(String name, Object ... types) {
            try {
                Class[] classes = new Class[types.length];
                int i = 0;
                for (Object e : types) {
                    classes[i++] = e instanceof Class ? (Class)e : (e instanceof RefClass ? ((RefClass)e).getClazz() : e.getClass());
                }
                try {
                    return new RefMethod(this.clazz.getMethod(name, classes));
                }
                catch (NoSuchMethodException ignored) {
                    return new RefMethod(this.clazz.getDeclaredMethod(name, classes));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public RefConstructor getConstructor(Object ... types) {
            try {
                Class[] classes = new Class[types.length];
                int i = 0;
                for (Object e : types) {
                    classes[i++] = e instanceof Class ? (Class)e : (e instanceof RefClass ? ((RefClass)e).getClazz() : e.getClass());
                }
                try {
                    return new RefConstructor(this.clazz.getConstructor(classes));
                }
                catch (NoSuchMethodException ignored) {
                    return new RefConstructor(this.clazz.getDeclaredConstructor(classes));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public RefMethod findMethod(Object ... types) {
            Object[] classes = new Class[types.length];
            int t = 0;
            for (Object e : types) {
                classes[t++] = e instanceof Class ? (Class)e : (e instanceof RefClass ? ((RefClass)e).getClazz() : e.getClass());
            }
            ArrayList methods = new ArrayList();
            Collections.addAll(methods, this.clazz.getMethods());
            Collections.addAll(methods, this.clazz.getDeclaredMethods());
            for (Method m : methods) {
                Object[] objectArray;
                int n;
                int n2;
                Object[] methodTypes = m.getParameterTypes();
                if (methodTypes.length != classes.length || (n2 = 0) >= (n = (objectArray = classes).length)) continue;
                Class aClass = objectArray[n2];
                if (!Arrays.equals(classes, methodTypes)) continue;
                return new RefMethod(m);
            }
            throw new RuntimeException("no such method");
        }

        public RefMethod findMethodByName(String ... names) {
            ArrayList methods = new ArrayList();
            Collections.addAll(methods, this.clazz.getMethods());
            Collections.addAll(methods, this.clazz.getDeclaredMethods());
            for (Method m : methods) {
                for (String name : names) {
                    if (!m.getName().equals(name)) continue;
                    return new RefMethod(m);
                }
            }
            throw new RuntimeException("no such method");
        }

        public RefMethod findMethodByReturnType(RefClass type) {
            return this.findMethodByReturnType(type.clazz);
        }

        public RefMethod findMethodByReturnType(Class<?> type) {
            if (type == null) {
                type = Void.TYPE.getComponentType();
            }
            ArrayList methods = new ArrayList();
            Collections.addAll(methods, this.clazz.getMethods());
            Collections.addAll(methods, this.clazz.getDeclaredMethods());
            for (Method m : methods) {
                if (!type.equals(m.getReturnType())) continue;
                return new RefMethod(m);
            }
            throw new RuntimeException("no such method");
        }

        public RefConstructor findConstructor(int number) {
            ArrayList constructors = new ArrayList();
            Collections.addAll(constructors, this.clazz.getConstructors());
            Collections.addAll(constructors, this.clazz.getDeclaredConstructors());
            for (Constructor m : constructors) {
                if (m.getParameterTypes().length != number) continue;
                return new RefConstructor(m);
            }
            throw new RuntimeException("no such constructor");
        }

        public RefField getField(String name) {
            try {
                try {
                    return new RefField(this.clazz.getField(name));
                }
                catch (NoSuchFieldException ignored) {
                    return new RefField(this.clazz.getDeclaredField(name));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public RefField findField(RefClass type) throws NoSuchFieldException {
            return this.findField(type.clazz);
        }

        public RefField findField(Class<?> type) throws NoSuchFieldException {
            if (type == null) {
                type = Void.TYPE;
            }
            ArrayList fields = new ArrayList();
            Collections.addAll(fields, this.clazz.getFields());
            Collections.addAll(fields, this.clazz.getDeclaredFields());
            for (Field f : fields) {
                if (!type.equals(f.getType())) continue;
                return new RefField(f);
            }
            throw new NoSuchFieldException();
        }
    }
}

