/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.util.ReflectionUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import sun.misc.Unsafe;

public class ReflectionUtils9 {
    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName) {
        Field[] fields;
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new RuntimeException("class " + enumType + " is not an instance of Enum");
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            if (!field.getName().contains("$VALUES")) continue;
            valuesField = field;
            break;
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            Enum newValue = (Enum)ReflectionUtils9.makeEnum(enumType, enumName, values.size());
            values.add(newValue);
            try {
                ReflectionUtils.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            }
            catch (Throwable e) {
                Field ordinalField = Enum.class.getDeclaredField("ordinal");
                ReflectionUtils.setFailsafeFieldValue(ordinalField, newValue, 0);
            }
            ReflectionUtils.cleanEnumCache(enumType);
            return (T)newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Object makeEnum(Class<?> enumClass, String value, int ordinal) throws Exception {
        Constructor<?> constructor = Unsafe.class.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Unsafe unsafe = (Unsafe)constructor.newInstance(new Object[0]);
        Object instance = unsafe.allocateInstance(enumClass);
        Field ordinalField = Enum.class.getDeclaredField("ordinal");
        ReflectionUtils.setFailsafeFieldValue(ordinalField, instance, 0);
        Field nameField = Enum.class.getDeclaredField("name");
        ReflectionUtils.setFailsafeFieldValue(nameField, instance, value);
        return instance;
    }
}

