/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.beta.implementation.queue.QueueHandler;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.RunnableVal;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public abstract class TaskManager {
    public static TaskManager IMP;
    private final ForkJoinPool pool = new ForkJoinPool();

    public abstract int repeat(@NotNull Runnable var1, int var2);

    public abstract int repeatAsync(@NotNull Runnable var1, int var2);

    public abstract void async(@NotNull Runnable var1);

    public abstract void task(@NotNull Runnable var1);

    public ForkJoinPool getPublicForkJoinPool() {
        return this.pool;
    }

    public void parallel(Collection<Runnable> runnables) {
        for (Runnable run : runnables) {
            this.pool.submit(run);
        }
        this.pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public void parallel(Collection<Runnable> runnables, @Nullable Integer numThreads) {
        if (runnables == null) {
            return;
        }
        if (numThreads == null) {
            numThreads = Settings.IMP.QUEUE.PARALLEL_THREADS;
        }
        if (numThreads <= 1) {
            for (Runnable run : runnables) {
                if (run == null) continue;
                run.run();
            }
            return;
        }
        int numRuns = runnables.size();
        int amountPerThread = 1 + numRuns / numThreads;
        Runnable[][] split = new Runnable[numThreads.intValue()][amountPerThread];
        Thread[] threads = new Thread[numThreads.intValue()];
        int i = 0;
        int j = 0;
        Thread[] threadArray = runnables.iterator();
        while (threadArray.hasNext()) {
            Runnable run;
            split[i][j] = run = threadArray.next();
            if (++i < numThreads) continue;
            i = 0;
            ++j;
        }
        for (i = 0; i < threads.length; ++i) {
            Runnable[] toRun = split[i];
            Thread thread = threads[i] = new Thread(() -> {
                for (Runnable run : toRun) {
                    if (run == null) continue;
                    run.run();
                }
            });
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void runUnsafe(Runnable run) {
        QueueHandler queue = Fawe.get().getQueueHandler();
        queue.startSet(true);
        try {
            run.run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        queue.endSet(true);
    }

    public void taskNow(@NotNull Runnable runnable, boolean async) {
        if (async) {
            this.async(runnable);
        } else {
            runnable.run();
        }
    }

    public void taskNowMain(@NotNull Runnable runnable) {
        if (Fawe.isMainThread()) {
            runnable.run();
        } else {
            this.task(runnable);
        }
    }

    public void taskNowAsync(@NotNull Runnable runnable) {
        this.taskNow(runnable, Fawe.isMainThread());
    }

    public void taskSoonMain(@NotNull Runnable runnable, boolean async) {
        if (async) {
            this.async(runnable);
        } else {
            this.task(runnable);
        }
    }

    public abstract void later(@NotNull Runnable var1, int var2);

    public abstract void laterAsync(@NotNull Runnable var1, int var2);

    public abstract void cancel(int var1);

    public <T> void objectTask(Collection<T> objects, final RunnableVal<T> task, final Runnable whenDone) {
        final Iterator<T> iterator = objects.iterator();
        this.task(new Runnable(){

            @Override
            public void run() {
                boolean hasNext;
                long start = System.currentTimeMillis();
                while ((hasNext = iterator.hasNext()) && System.currentTimeMillis() - start < 5L) {
                    task.value = iterator.next();
                    task.run();
                }
                if (!hasNext) {
                    TaskManager.this.later(whenDone, 1);
                } else {
                    TaskManager.this.later(this, 1);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(AtomicBoolean running, int timeout) {
        try {
            long start = System.currentTimeMillis();
            AtomicBoolean atomicBoolean = running;
            synchronized (atomicBoolean) {
                while (running.get()) {
                    running.wait(timeout);
                    if (!running.get() || System.currentTimeMillis() - start <= (long)Settings.IMP.QUEUE.DISCARD_AFTER_MS) continue;
                    new RuntimeException("FAWE is taking a long time to execute a task (might just be a symptom): ").printStackTrace();
                    LoggerFactory.getLogger(TaskManager.class).debug("For full debug information use: /fawe threads");
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(AtomicBoolean running) {
        running.set(false);
        AtomicBoolean atomicBoolean = running;
        synchronized (atomicBoolean) {
            running.notifyAll();
        }
    }

    public void taskWhenFree(@NotNull Runnable run) {
        if (Fawe.isMainThread()) {
            run.run();
        } else {
            Fawe.get().getQueueHandler().sync(run);
        }
    }

    public <T> T syncWhenFree(@NotNull RunnableVal<T> function) {
        if (Fawe.isMainThread()) {
            function.run();
            return function.value;
        }
        try {
            return Fawe.get().getQueueHandler().sync(function).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T syncWhenFree(@NotNull Supplier<T> supplier) {
        if (Fawe.isMainThread()) {
            return supplier.get();
        }
        try {
            return Fawe.get().getQueueHandler().sync(supplier).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T sync(@NotNull RunnableVal<T> function) {
        return this.sync((Supplier<T>)function);
    }

    public <T> T sync(Supplier<T> function) {
        if (Fawe.isMainThread()) {
            return function.get();
        }
        try {
            return Fawe.get().getQueueHandler().sync(function).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

