/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.extent.NullExtent;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;

public class WEManager {
    private static final Logger log = LoggerFactory.getLogger(WEManager.class);
    public static final WEManager IMP = new WEManager();
    public final ArrayDeque<FaweMaskManager> managers = new ArrayDeque();

    public void cancelEditSafe(AbstractDelegateExtent parent, FaweException reason) throws FaweException {
        log.warn("CancelEditSafe was hit. Please ignore this message.");
        Extent currentExtent = parent.getExtent();
        if (!(currentExtent instanceof NullExtent)) {
            parent.extent = new NullExtent(parent.extent, reason);
        }
        throw reason;
    }

    public void cancelEdit(AbstractDelegateExtent parent, FaweException reason) throws WorldEditException {
        this.cancelEditSafe(parent, reason);
    }

    @Deprecated
    public Region[] getMask(Player player) {
        return this.getMask(player, FaweMaskManager.MaskType.getDefaultMaskType());
    }

    public boolean isIn(int x, int y, int z, Region region) {
        return region.contains(x, y, z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region[] getMask(Player player, FaweMaskManager.MaskType type) {
        FaweMask mask;
        if (!Settings.IMP.REGION_RESTRICTIONS || player.hasPermission("fawe.bypass") || player.hasPermission("fawe.bypass.regions")) {
            return new Region[]{RegionWrapper.GLOBAL()};
        }
        Location loc = player.getLocation();
        String world = player.getWorld().getName();
        if (!world.equals(player.getMeta("lastMaskWorld"))) {
            player.deleteMeta("lastMaskWorld");
            player.deleteMeta("lastMask");
        }
        player.setMeta("lastMaskWorld", world);
        HashSet<FaweMask> masks = (HashSet<FaweMask>)player.getMeta("lastMask");
        HashSet<Region> backupRegions = new HashSet<Region>();
        HashSet<Region> regions = new HashSet<Region>();
        if (masks == null) {
            masks = new HashSet<FaweMask>();
        } else {
            HashSet<FaweMask> hashSet = masks;
            synchronized (hashSet) {
                boolean removed = false;
                if (!masks.isEmpty()) {
                    Iterator iterator = masks.iterator();
                    while (iterator.hasNext()) {
                        mask = (FaweMask)iterator.next();
                        if (mask.isValid(player, type)) {
                            Region region = mask.getRegion();
                            if (region.contains(loc.toBlockPoint())) {
                                regions.add(region);
                                continue;
                            }
                            removed = true;
                            backupRegions.add(region);
                            continue;
                        }
                        player.printDebug(TextComponent.of("Invalid Mask"));
                        removed = true;
                        iterator.remove();
                    }
                }
                if (!removed) {
                    return regions.toArray(new Region[0]);
                }
                masks.clear();
            }
        }
        HashSet tmpMasks = new HashSet();
        for (FaweMaskManager manager : this.managers) {
            if (player.hasPermission("fawe." + manager.getKey())) {
                try {
                    if (manager.isExclusive() && !masks.isEmpty() || (mask = manager.getMask(player, FaweMaskManager.MaskType.getDefaultMaskType())) == null) continue;
                    regions.add(mask.getRegion());
                    masks.add(mask);
                    if (!manager.isExclusive()) continue;
                    break;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
            }
            player.printError(TextComponent.of("Missing permission fawe." + manager.getKey()));
        }
        log.debug("Region info for " + player.getName());
        log.debug("There are " + backupRegions.size() + " backupRegions being added to Regions. Regions has " + regions.size() + " before backupRegions are added");
        regions.addAll(backupRegions);
        log.debug("Finished adding regions for " + player.getName());
        if (!masks.isEmpty()) {
            player.setMeta("lastMask", masks);
        } else {
            player.deleteMeta("lastMask");
        }
        return regions.toArray(new Region[0]);
    }

    public boolean intersects(Region region1, Region region2) {
        BlockVector3 rg1P1 = region1.getMinimumPoint();
        BlockVector3 rg1P2 = region1.getMaximumPoint();
        BlockVector3 rg2P1 = region2.getMinimumPoint();
        BlockVector3 rg2P2 = region2.getMaximumPoint();
        return rg1P1.getBlockX() <= rg2P2.getBlockX() && rg1P2.getBlockX() >= rg2P1.getBlockX() && rg1P1.getBlockZ() <= rg2P2.getBlockZ() && rg1P2.getBlockZ() >= rg2P1.getBlockZ();
    }

    public boolean regionContains(Region selection, HashSet<Region> mask) {
        for (Region region : mask) {
            if (!this.intersects(region, selection)) continue;
            return true;
        }
        return false;
    }
}

