/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util.image;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.platform.binding.ProvideBindings;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;

public class ImageUtil {
    public static BufferedImage getScaledInstance(BufferedImage image, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int height;
        int width;
        if (image.getHeight() == targetHeight && image.getWidth() == targetWidth) {
            return image;
        }
        int type = image.getTransparency() == 1 ? 1 : 2;
        BufferedImage scaledImage = image;
        if (higherQuality) {
            width = scaledImage.getWidth();
            height = scaledImage.getHeight();
        } else {
            width = targetWidth;
            height = targetHeight;
        }
        do {
            if (higherQuality && width > targetWidth) {
                width /= 2;
            }
            if (width < targetWidth) {
                width = targetWidth;
            }
            if (higherQuality && height > targetHeight) {
                height /= 2;
            }
            if (height < targetHeight) {
                height = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(width, height, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2.drawImage(scaledImage, 0, 0, width, height, null);
            g2.dispose();
            scaledImage = tmp;
        } while (width != targetWidth || height != targetHeight);
        return scaledImage;
    }

    public static void fadeAlpha(BufferedImage image) {
        int z;
        float distance;
        int[] raw = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int centerX = width / 2;
        int centerZ = height / 2;
        float invRadiusX = 1.0f / (float)centerX;
        float invRadiusZ = 1.0f / (float)centerZ;
        float[] sqrX = new float[width];
        float[] sqrZ = new float[height];
        for (int x = 0; x < width; ++x) {
            distance = (float)Math.abs(x - centerX) * invRadiusX;
            sqrX[x] = distance * distance;
        }
        for (z = 0; z < height; ++z) {
            distance = (float)Math.abs(z - centerZ) * invRadiusZ;
            sqrZ[z] = distance * distance;
        }
        int index = 0;
        for (z = 0; z < height; ++z) {
            float dz2 = sqrZ[z];
            int x = 0;
            while (x < width) {
                int color = raw[index];
                int alpha = color >> 24 & 0xFF;
                if (alpha != 0) {
                    float dx2 = sqrX[x];
                    float distSqr = dz2 + dx2;
                    if (distSqr > 1.0f) {
                        raw[index] = 0;
                    } else {
                        alpha = (int)((float)alpha * (1.0f - distSqr));
                        raw[index] = (color & 0xFFFFFF) + (alpha << 24);
                    }
                }
                ++x;
                ++index;
            }
        }
    }

    public static void scaleAlpha(BufferedImage image, double alphaScale) {
        int[] raw = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int defined = MathMan.clamp((int)(255.0 * alphaScale), 0, 255) << 24;
        block4: for (int i = 0; i < raw.length; ++i) {
            int color = raw[i];
            int alpha = color >> 24 & 0xFF;
            switch (alpha) {
                case 0: {
                    continue block4;
                }
                case 255: {
                    raw[i] = (color & 0xFFFFFF) + defined;
                    continue block4;
                }
                default: {
                    alpha = MathMan.clamp((int)((double)alpha * alphaScale), 0, 255);
                    raw[i] = (color & 0xFFFFFF) + (alpha << 24);
                    continue block4;
                }
            }
        }
    }

    public static int getColor(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        long totalRed = 0L;
        long totalGreen = 0L;
        long totalBlue = 0L;
        long totalAlpha = 0L;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = image.getRGB(x, y);
                totalRed += (long)(color >> 16 & 0xFF);
                totalGreen += (long)(color >> 8 & 0xFF);
                totalBlue += (long)(color >> 0 & 0xFF);
                totalAlpha += (long)(color >> 24 & 0xFF);
            }
        }
        int a = width * height;
        int red = (int)(totalRed / (long)a);
        int green = (int)(totalGreen / (long)a);
        int blue = (int)(totalBlue / (long)a);
        int alpha = (int)(totalAlpha / (long)a);
        return (alpha << 24) + (red << 16) + (green << 8) + (blue << 0);
    }

    public static BufferedImage load(@Nullable ProvideBindings.ImageUri uri) throws InputParseException {
        return uri == null ? null : uri.load();
    }

    public static BufferedImage load(URI uri) throws InputParseException {
        try {
            return MainUtil.readImage(ImageUtil.getInputStream(uri));
        }
        catch (IOException e) {
            throw new InputParseException(e.getMessage());
        }
    }

    public static InputStream getInputStream(URI uri) throws InputParseException {
        try {
            String uriStr = uri.toString();
            if (uriStr.startsWith("file:/")) {
                File file = new File(uri.getPath());
                return new FileInputStream(file);
            }
            return new URL(uriStr).openStream();
        }
        catch (IOException e) {
            throw new InputParseException(e.getMessage());
        }
    }

    public static BufferedImage getImage(String arg) throws InputParseException {
        try {
            if (arg.startsWith("http")) {
                URL url;
                BufferedImage img;
                if (arg.contains("imgur.com") && !arg.contains("i.imgur.com")) {
                    arg = "https://i.imgur.com/" + arg.split("imgur.com/")[1] + ".png";
                }
                if ((img = MainUtil.readImage(url = new URL(arg))) == null) {
                    throw new IOException("Failed to read " + url + ", please try again later");
                }
                return img;
            }
            if (arg.startsWith("file:/")) {
                arg = arg.replaceFirst("file:/+", "");
                File file = MainUtil.getFile(MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HEIGHTMAP), arg);
                return MainUtil.readImage(file);
            }
            throw new InputParseException("Invalid image " + arg);
        }
        catch (IOException e) {
            throw new InputParseException(e.getMessage());
        }
    }

    public static URI getImageURI(String arg) throws InputParseException {
        try {
            if (arg.startsWith("http")) {
                if (arg.contains("imgur.com") && !arg.contains("i.imgur.com")) {
                    arg = "https://i.imgur.com/" + arg.split("imgur.com/")[1] + ".png";
                }
                return new URL(arg).toURI();
            }
            if (arg.startsWith("file:/")) {
                arg = arg.replaceFirst("file:/+", "");
                File file = MainUtil.getFile(MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HEIGHTMAP), arg);
                if (!file.exists()) {
                    throw new InputParseException("File not found " + file);
                }
                if (file.isDirectory()) {
                    throw new InputParseException("File is a directory " + file);
                }
                return file.toURI();
            }
            throw new InputParseException("Invalid image " + arg);
        }
        catch (IOException | URISyntaxException e) {
            throw new InputParseException(e.getMessage());
        }
    }
}

