/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.wrappers;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.wrappers.WorldWrapper;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.PlayerProxy;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TargetBlock;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockTypes;

public class AsyncPlayer
extends PlayerProxy {
    public AsyncPlayer(Player parent) {
        super(parent);
    }

    public static AsyncPlayer wrap(Player parent) {
        if (parent instanceof AsyncPlayer) {
            return (AsyncPlayer)parent;
        }
        return new AsyncPlayer(parent);
    }

    @Override
    public World getWorld() {
        return WorldWrapper.wrap(super.getWorld());
    }

    @Override
    public void findFreePosition(final Location searchPos) {
        TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                AsyncPlayer.this.getBasePlayer().findFreePosition(searchPos);
            }
        });
    }

    @Override
    public void setOnGround(final Location searchPos) {
        TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                AsyncPlayer.this.getBasePlayer().setOnGround(searchPos);
            }
        });
    }

    @Override
    public void findFreePosition() {
        TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            @Override
            public void run(Boolean value) {
                AsyncPlayer.this.getBasePlayer().findFreePosition();
            }
        });
    }

    @Override
    public boolean ascendLevel() {
        return TaskManager.IMP.sync(() -> this.getBasePlayer().ascendLevel());
    }

    @Override
    public boolean descendLevel() {
        return TaskManager.IMP.sync(() -> this.getBasePlayer().descendLevel());
    }

    @Override
    public boolean ascendToCeiling(int clearance) {
        return this.ascendToCeiling(clearance, true);
    }

    @Override
    public boolean ascendToCeiling(int clearance, boolean alwaysGlass) {
        int y;
        Location pos = this.getBlockLocation();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        Extent world = this.getLocation().getExtent();
        if (!world.getBlock(BlockVector3.at(x, y, z)).getBlockType().getMaterial().isAir()) {
            return false;
        }
        for (y = Math.max(0, pos.getBlockY() + 2); y <= world.getMaximumPoint().getY(); ++y) {
            if (!world.getBlock(BlockVector3.at(x, y, z)).getBlockType().getMaterial().isMovementBlocker()) continue;
            int platformY = Math.max(initialY, y - 3 - clearance);
            this.floatAt(x, platformY + 1, z, alwaysGlass);
            return true;
        }
        return false;
    }

    @Override
    public boolean ascendUpwards(int distance) {
        return this.ascendUpwards(distance, true);
    }

    @Override
    public boolean ascendUpwards(int distance, boolean alwaysGlass) {
        Location pos = this.getBlockLocation();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        int maxY = Math.min(this.getWorld().getMaxY() + 1, initialY + distance);
        Extent world = this.getLocation().getExtent();
        for (int y = Math.max(0, pos.getBlockY() + 1); y <= world.getMaximumPoint().getY() + 2 && !world.getBlock(BlockVector3.at(x, y, z)).getBlockType().getMaterial().isMovementBlocker() && y <= maxY + 1; ++y) {
            if (y != maxY + 1) continue;
            this.floatAt(x, y - 1, z, alwaysGlass);
            return true;
        }
        return false;
    }

    @Override
    public void floatAt(int x, int y, int z, boolean alwaysGlass) {
        if (alwaysGlass || !this.isAllowedToFly()) {
            RuntimeException caught = null;
            try {
                EditSession edit = new EditSessionBuilder(WorldWrapper.unwrap(this.getWorld())).player(AsyncPlayer.unwrap(this.getBasePlayer())).build();
                edit.setBlock(BlockVector3.at(x, y - 1, z), BlockTypes.GLASS);
                edit.flushQueue();
                LocalSession session = Fawe.get().getWorldEdit().getSessionManager().get(this);
                if (session != null) {
                    session.remember(edit, true, this.getBasePlayer().getLimit().MAX_HISTORY);
                }
            }
            catch (RuntimeException e) {
                caught = e;
            }
            if (caught != null) {
                throw caught;
            }
        } else {
            this.setFlying(true);
        }
        this.trySetPosition(Vector3.at((double)x + 0.5, y, (double)z + 0.5));
    }

    @Override
    public void setPosition(Vector3 pos, float pitch, float yaw) {
        Fawe.get().getQueueHandler().sync(() -> super.setPosition(pos, pitch, yaw));
    }

    @Override
    public Location getBlockTrace(int range, boolean useLastBlock) {
        return TaskManager.IMP.sync(() -> {
            TargetBlock tb = new TargetBlock(this, range, 0.2);
            return useLastBlock ? tb.getAnyTargetBlock() : tb.getTargetBlock();
        });
    }

    @Override
    public Location getBlockTraceFace(int range, boolean useLastBlock) {
        return TaskManager.IMP.sync(() -> {
            TargetBlock tb = new TargetBlock(this, range, 0.2);
            return useLastBlock ? tb.getAnyTargetBlockFace() : tb.getTargetBlockFace();
        });
    }

    @Override
    public Location getSolidBlockTrace(int range) {
        return TaskManager.IMP.sync(() -> {
            TargetBlock tb = new TargetBlock(this, range, 0.2);
            return tb.getSolidTargetBlock();
        });
    }

    @Override
    public Direction getCardinalDirection() {
        return this.getBasePlayer().getCardinalDirection();
    }

    @Override
    public boolean passThroughForwardWall(int range) {
        return TaskManager.IMP.sync(() -> {
            Location block;
            int searchDist = 0;
            TargetBlock hitBlox = new TargetBlock(this, range, 0.2);
            Extent world = this.getLocation().getExtent();
            boolean firstBlock = true;
            int freeToFind = 2;
            boolean inFree = false;
            while ((block = hitBlox.getNextBlock()) != null) {
                boolean free;
                boolean bl = free = !world.getBlock(BlockVector3.at(block.getBlockX(), block.getBlockY(), block.getBlockZ())).getBlockType().getMaterial().isMovementBlocker();
                if (firstBlock) {
                    firstBlock = false;
                    if (!free) {
                        --freeToFind;
                        continue;
                    }
                }
                if (++searchDist > 20) {
                    return false;
                }
                if (inFree != free && free) {
                    --freeToFind;
                }
                if (freeToFind == 0) {
                    this.setOnGround(block);
                    return true;
                }
                inFree = free;
            }
            return false;
        });
    }
}

