/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdInputStream
extends FilterInputStream {
    private long stream;
    private long dstPos = 0L;
    private long srcPos = 0L;
    private long srcSize = 0L;
    private byte[] src = new byte[srcBuffSize];
    private static final int srcBuffSize;
    private boolean isContinuous = false;
    private boolean frameFinished = false;
    private boolean isClosed = false;

    private static native long recommendedDInSize();

    private static native long recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int decompressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public ZstdInputStream(InputStream inStream) throws IOException {
        super(inStream);
        this.stream = ZstdInputStream.createDStream();
        int size = this.initDStream(this.stream);
        if (Zstd.isError(size)) {
            throw new IOException("Decompression error: " + Zstd.getErrorName(size));
        }
    }

    public ZstdInputStream setContinuous(boolean b) {
        this.isContinuous = b;
        return this;
    }

    public boolean getContinuous() {
        return this.isContinuous;
    }

    @Override
    public int read(byte[] dst, int offset, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (offset < 0 || len > dst.length - offset) {
            throw new IndexOutOfBoundsException("Requested length " + len + " from offset " + offset + " in buffer of size " + dst.length);
        }
        int dstSize = offset + len;
        this.dstPos = offset;
        while (this.dstPos < (long)dstSize) {
            int size;
            if (this.srcSize - this.srcPos == 0L) {
                this.srcSize = this.in.read(this.src, 0, srcBuffSize);
                this.srcPos = 0L;
                if (this.srcSize < 0L) {
                    this.srcSize = 0L;
                    if (this.frameFinished) {
                        return -1;
                    }
                    if (this.isContinuous) {
                        return (int)(this.dstPos - (long)offset);
                    }
                    throw new IOException("Read error or truncated source");
                }
                this.frameFinished = false;
            }
            if (Zstd.isError(size = this.decompressStream(this.stream, dst, dstSize, this.src, (int)this.srcSize))) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(size));
            }
            if (size != 0) continue;
            this.frameFinished = true;
            size = this.initDStream(this.stream);
            if (Zstd.isError(size)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(size));
            }
            return (int)(this.dstPos - (long)offset);
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        byte[] oneByte = new byte[1];
        int result = this.read(oneByte, 0, 1);
        if (result > 0) {
            return oneByte[0] & 0xFF;
        }
        return result;
    }

    @Override
    public int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (this.srcSize - this.srcPos > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        long skipped = 0L;
        int dstSize = (int)ZstdInputStream.recommendedDOutSize();
        byte[] dst = new byte[dstSize];
        while (toSkip > (long)dstSize) {
            long size = this.read(dst, 0, dstSize);
            toSkip -= size;
            skipped += size;
        }
        return skipped += (long)this.read(dst, 0, (int)toSkip);
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        ZstdInputStream.freeDStream(this.stream);
        this.in.close();
        this.isClosed = true;
    }

    static {
        Native.load();
        srcBuffSize = (int)ZstdInputStream.recommendedDInSize();
    }
}

