/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jnbt;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.Tag;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.jpountz.lz4.LZ4BlockInputStream;

public abstract class CompressedCompoundTag<T>
extends CompoundTag {
    private T in;

    public CompressedCompoundTag(T in) {
        super(new HashMap<String, Tag>());
        this.in = in;
    }

    @Override
    public Map<String, Tag> getValue() {
        if (this.in != null) {
            this.decompress();
        }
        return super.getValue();
    }

    public abstract LZ4BlockInputStream adapt(T var1) throws IOException;

    public T getSource() {
        return this.in;
    }

    private void decompress() {
        try (NBTInputStream nbtIn = new NBTInputStream(this.adapt(this.in));){
            this.in = null;
            CompoundTag tag = (CompoundTag)nbtIn.readTag();
            Object value = tag.getValue();
            Object raw = super.getValue();
            for (Map.Entry entry : value.entrySet()) {
                raw.put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

