/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class BukkitPermissionAttachmentManager {
    private final WorldEditPlugin plugin;
    private final Map<Player, PermissionAttachment> attachments = new ConcurrentHashMap<Player, PermissionAttachment>();

    public BukkitPermissionAttachmentManager(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    public PermissionAttachment getOrAddAttachment(@Nullable Player p) {
        if (p == null) {
            return null;
        }
        return this.attachments.computeIfAbsent(p, k -> k.addAttachment((Plugin)this.plugin));
    }

    public void removeAttachment(@Nullable Player p) {
        if (p == null) {
            return;
        }
        PermissionAttachment attach = this.attachments.remove(p);
        if (attach != null) {
            p.removeAttachment(attach);
        }
    }
}

