/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.boydti.fawe.config.Caption;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.util.StringUtil;
import com.sk89q.wepif.VaultResolver;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayerBlockBag;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.WorldEditText;
import com.sk89q.worldedit.util.formatting.component.TextUtils;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.adapter.bukkit.TextAdapter;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class BukkitPlayer
extends AbstractPlayerActor {
    private final Player player;
    private final WorldEditPlugin plugin;
    private final PermissionAttachment permAttachment;

    public BukkitPlayer(@Nullable Player player) {
        super(player != null ? BukkitPlayer.getExistingMap(WorldEditPlugin.getInstance(), player) : new ConcurrentHashMap());
        this.plugin = WorldEditPlugin.getInstance();
        this.player = player;
        this.permAttachment = this.plugin.getPermissionAttachmentManager().getOrAddAttachment(player);
    }

    public BukkitPlayer(@Nonnull WorldEditPlugin plugin, @Nullable Player player) {
        this.plugin = plugin;
        this.player = player;
        this.permAttachment = plugin.getPermissionAttachmentManager().getOrAddAttachment(player);
        if (player != null && Settings.IMP.CLIPBOARD.USE_DISK) {
            this.loadClipboardFromDisk();
        }
    }

    private static Map<String, Object> getExistingMap(WorldEditPlugin plugin, Player player) {
        BukkitPlayer cached = plugin.getCachedPlayer(player);
        if (cached != null) {
            return cached.getRawMeta();
        }
        return new ConcurrentHashMap<String, Object>();
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public BaseItemStack getItemInHand(HandSide handSide) {
        ItemStack itemStack = handSide == HandSide.MAIN_HAND ? this.player.getInventory().getItemInMainHand() : this.player.getInventory().getItemInOffHand();
        return BukkitAdapter.adapt(itemStack);
    }

    @Override
    public BaseBlock getBlockInHand(HandSide handSide) throws WorldEditException {
        ItemStack itemStack = handSide == HandSide.MAIN_HAND ? this.player.getInventory().getItemInMainHand() : this.player.getInventory().getItemInOffHand();
        return BukkitAdapter.asBlockState(itemStack).toBaseBlock();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public String getDisplayName() {
        return this.player.getDisplayName();
    }

    @Override
    public void giveItem(BaseItemStack itemStack) {
        PlayerInventory inv = this.player.getInventory();
        ItemStack newItem = BukkitAdapter.adapt(itemStack);
        if (itemStack.getType().getId().equalsIgnoreCase(WorldEdit.getInstance().getConfiguration().wandItem)) {
            inv.remove(newItem);
        }
        ItemStack item = this.player.getInventory().getItemInMainHand();
        this.player.getInventory().setItemInMainHand(newItem);
        final HashMap overflow = inv.addItem(new ItemStack[]{item});
        if (!overflow.isEmpty()) {
            TaskManager.IMP.sync(new RunnableVal<Object>(){

                @Override
                public void run(Object value) {
                    for (Map.Entry entry : overflow.entrySet()) {
                        ItemStack stack = (ItemStack)entry.getValue();
                        if (stack.getType() == Material.AIR || stack.getAmount() <= 0) continue;
                        Item dropped = BukkitPlayer.this.player.getWorld().dropItem(BukkitPlayer.this.player.getLocation(), stack);
                        PlayerDropItemEvent event = new PlayerDropItemEvent(BukkitPlayer.this.player, dropped);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) continue;
                        dropped.remove();
                    }
                }
            });
        }
        this.player.updateInventory();
    }

    @Override
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(part);
        }
    }

    @Override
    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7d" + part);
        }
    }

    @Override
    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a77" + part);
        }
    }

    @Override
    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7c" + part);
        }
    }

    @Override
    public void print(Component component) {
        component = Caption.color((Component)TranslatableComponent.of("prefix", component), this.getLocale());
        TextAdapter.sendComponent((CommandSender)this.player, component);
    }

    @Override
    public boolean trySetPosition(Vector3 pos, float pitch, float yaw) {
        com.sk89q.worldedit.util.Location loc;
        Extent extent;
        org.bukkit.World world = this.player.getWorld();
        if (pos instanceof com.sk89q.worldedit.util.Location && (extent = (loc = (com.sk89q.worldedit.util.Location)pos).getExtent()) instanceof World) {
            world = Bukkit.getWorld((String)((World)extent).getName());
        }
        org.bukkit.World finalWorld = world;
        return TaskManager.IMP.sync(() -> this.player.teleport(new Location(finalWorld, pos.getX(), pos.getY(), pos.getZ(), yaw, pitch)));
    }

    @Override
    public String[] getGroups() {
        return this.plugin.getPermissionsResolver().getGroups((OfflinePlayer)this.player);
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return new BukkitPlayerBlockBag(this.player);
    }

    @Override
    public GameMode getGameMode() {
        return GameModes.get(this.player.getGameMode().name().toLowerCase(Locale.ROOT));
    }

    @Override
    public void setGameMode(GameMode gameMode) {
        this.player.setGameMode(org.bukkit.GameMode.valueOf((String)gameMode.getId().toUpperCase(Locale.ROOT)));
    }

    @Override
    public boolean hasPermission(String perm) {
        return !this.plugin.getLocalConfiguration().noOpPermissions && this.player.isOp() || this.plugin.getPermissionsResolver().hasPermission(this.player.getWorld().getName(), (OfflinePlayer)this.player, perm);
    }

    @Override
    public void setPermission(String permission, boolean value) {
        boolean usesuperperms;
        boolean bl = usesuperperms = VaultResolver.perms == null;
        if (VaultResolver.perms != null) {
            if (value) {
                if (!VaultResolver.perms.playerAdd(this.player, permission)) {
                    usesuperperms = true;
                }
            } else if (!VaultResolver.perms.playerRemove(this.player, permission)) {
                usesuperperms = true;
            }
        }
        if (usesuperperms) {
            this.permAttachment.setPermission(permission, value);
        }
    }

    @Override
    public World getWorld() {
        return BukkitAdapter.adapt(this.player.getWorld());
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString(params, "|");
        }
        this.player.sendPluginMessage((Plugin)this.plugin, "worldedit:cui", send.getBytes(CUIChannelListener.UTF_8_CHARSET));
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public boolean isAllowedToFly() {
        return this.player.getAllowFlight();
    }

    @Override
    public void setFlying(boolean flying) {
        this.player.setFlying(flying);
    }

    @Override
    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    @Override
    public com.sk89q.worldedit.util.Location getLocation() {
        Location nativeLocation = this.player.getLocation();
        Vector3 position = BukkitAdapter.asVector(nativeLocation);
        return new com.sk89q.worldedit.util.Location((Extent)this.getWorld(), position, nativeLocation.getYaw(), nativeLocation.getPitch());
    }

    @Override
    public boolean setLocation(com.sk89q.worldedit.util.Location location) {
        return this.player.teleport(BukkitAdapter.adapt(location));
    }

    @Override
    public Locale getLocale() {
        return TextUtils.getLocaleByMinecraftTag(this.player.getLocale());
    }

    @Override
    public void sendAnnouncements() {
        if (WorldEditPlugin.getInstance().getBukkitImplAdapter() == null) {
            this.printError(TranslatableComponent.of("worldedit.version.bukkit.unsupported-adapter", TextComponent.of("https://intellectualsites.github.io/download/fawe.html", TextColor.AQUA).clickEvent(ClickEvent.openUrl("https://intellectualsites.github.io/download/fawe.html"))));
        }
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    @Override
    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player.getUniqueId(), this.player.getName());
    }

    @Override
    public <B extends BlockStateHolder<B>> void sendFakeBlock(BlockVector3 pos, B block) {
        Location loc = new Location(this.player.getWorld(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (block == null) {
            this.player.sendBlockChange(loc, this.player.getWorld().getBlockAt(loc).getBlockData());
        } else {
            BukkitImplAdapter adapter;
            this.player.sendBlockChange(loc, BukkitAdapter.adapt(block));
            if (block instanceof BaseBlock && ((BaseBlock)block).hasNbtData() && (adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter()) != null && block.getBlockType() == BlockTypes.STRUCTURE_BLOCK) {
                adapter.sendFakeNBT(this.player, pos, ((BaseBlock)block).getNbtData());
                adapter.sendFakeOP(this.player);
            }
        }
    }

    @Override
    public void sendTitle(Component title, Component sub) {
        String titleStr = WorldEditText.reduceToText(title, this.getLocale());
        String subStr = WorldEditText.reduceToText(sub, this.getLocale());
        this.player.sendTitle(titleStr, subStr, 0, 70, 20);
    }

    @Override
    public void unregister() {
        this.player.removeMetadata("WE", (Plugin)WorldEditPlugin.getInstance());
        this.plugin.getPermissionAttachmentManager().removeAttachment(this.player);
        super.unregister();
    }

    private static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private SessionKeyImpl(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        @Override
        public UUID getUniqueId() {
            return this.uuid;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isActive() {
            return Bukkit.getServer().getPlayer(this.uuid) != null;
        }

        @Override
        public boolean isPersistent() {
            return true;
        }
    }
}

