/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.NotABlockException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitEntity;
import com.sk89q.worldedit.bukkit.BukkitItemStack;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public interface IBukkitAdapter {
    default public BukkitWorld asBukkitWorld(World world) {
        if (world instanceof BukkitWorld) {
            return (BukkitWorld)world;
        }
        BukkitWorld bukkitWorld = WorldEditPlugin.getInstance().getInternalPlatform().matchWorld(world);
        if (bukkitWorld == null) {
            throw new RuntimeException("World '" + world.getName() + "' has no matching version in Bukkit");
        }
        return bukkitWorld;
    }

    default public org.bukkit.World adapt(World world) {
        Preconditions.checkNotNull((Object)world);
        if (world instanceof BukkitWorld) {
            return ((BukkitWorld)world).getWorld();
        }
        org.bukkit.World match = Bukkit.getServer().getWorld(world.getName());
        if (match != null) {
            return match;
        }
        throw new IllegalArgumentException("Can't find a Bukkit world for " + world);
    }

    default public Location adapt(org.bukkit.World world, Vector3 position) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)position);
        return new Location(world, position.getX(), position.getY(), position.getZ());
    }

    default public Location adapt(org.bukkit.World world, BlockVector3 position) {
        return this.adapt(world, position.toVector3());
    }

    default public Location adapt(org.bukkit.World world, com.sk89q.worldedit.util.Location location) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)location);
        return new Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    default public Vector3 asVector(Location location) {
        Preconditions.checkNotNull((Object)location);
        return Vector3.at(location.getX(), location.getY(), location.getZ());
    }

    default public BlockVector3 asBlockVector(Location location) {
        Preconditions.checkNotNull((Object)location);
        return BlockVector3.at(location.getX(), location.getY(), location.getZ());
    }

    default public Entity adapt(org.bukkit.entity.Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        return new BukkitEntity(entity);
    }

    default public Material adapt(ItemType itemType) {
        Preconditions.checkNotNull((Object)itemType);
        if (!itemType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports Minecraft items");
        }
        return Material.getMaterial((String)itemType.getId().substring(10).toUpperCase(Locale.ROOT));
    }

    default public Material adapt(BlockType blockType) {
        Preconditions.checkNotNull((Object)blockType);
        if (!blockType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports Minecraft blocks");
        }
        String id = blockType.getId().substring(10).toUpperCase(Locale.ROOT);
        return Material.getMaterial((String)id);
    }

    default public EntityType adapt(com.sk89q.worldedit.world.entity.EntityType entityType) {
        if (!entityType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports vanilla entities");
        }
        return EntityType.fromName((String)entityType.getId().substring(10).toLowerCase(Locale.ROOT));
    }

    default public BlockType asBlockType(Material material) {
        Preconditions.checkNotNull((Object)material);
        if (!material.isBlock()) {
            throw new IllegalArgumentException(material.getKey().toString() + " is not a block!"){

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            };
        }
        return BlockTypes.get(material.getKey().toString());
    }

    default public ItemType asItemType(Material material) {
        return ItemTypes.get(material.getKey().toString());
    }

    default public BlockState adapt(BlockData blockData) {
        String id = blockData.getAsString();
        return BlockState.get(id);
    }

    default public <B extends BlockStateHolder<B>> BlockData adapt(B block) {
        return Bukkit.createBlockData((String)block.getAsString());
    }

    default public BaseItemStack adapt(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack);
        return new BukkitItemStack(itemStack);
    }

    default public ItemStack adapt(BaseItemStack item) {
        Preconditions.checkNotNull((Object)item);
        if (item instanceof BukkitItemStack) {
            return ((BukkitItemStack)item).getBukkitItemStack();
        }
        return new ItemStack(this.adapt(item.getType()), item.getAmount());
    }

    default public BukkitPlayer adapt(org.bukkit.entity.Player player) {
        return WorldEditPlugin.getInstance().wrapPlayer(player);
    }

    default public org.bukkit.entity.Player adapt(Player player) {
        return ((BukkitPlayer)player).getPlayer();
    }

    default public Biome adapt(BiomeType biomeType) {
        if (!biomeType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports vanilla biomes");
        }
        try {
            return Biome.valueOf((String)biomeType.getId().substring(10).toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    default public BiomeType adapt(Biome biome) {
        return BiomeTypes.get(biome.name().toLowerCase(Locale.ROOT));
    }

    default public boolean equals(BlockType blockType, Material type) {
        return blockType == this.asItemType(type).getBlockType();
    }

    default public World adapt(org.bukkit.World world) {
        Preconditions.checkNotNull((Object)world);
        return new BukkitWorld(world);
    }

    default public GameMode adapt(org.bukkit.GameMode gameMode) {
        Preconditions.checkNotNull((Object)gameMode);
        return GameModes.get(gameMode.name().toLowerCase(Locale.ROOT));
    }

    default public com.sk89q.worldedit.world.entity.EntityType adapt(EntityType entityType) {
        return EntityTypes.get(entityType.getName().toLowerCase(Locale.ROOT));
    }

    default public BlockState asBlockState(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack);
        if (itemStack.getType().isBlock()) {
            return this.adapt(itemStack.getType().createBlockData());
        }
        throw new NotABlockException();
    }
}

