/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter;

import com.boydti.fawe.beta.IChunkCache;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.implementation.queue.SingleThreadQueueExtent;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.bukkit.fastutil.ints.Int2ObjectOpenHashMap;
import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectOpenHashMap;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.generator.BlockPopulator;

public abstract class Regenerator<IChunkAccess, ProtoChunk extends IChunkAccess, Chunk extends IChunkAccess, ChunkStatus extends ChunkStatusWrapper<IChunkAccess>> {
    public static final Logger logger = LoggerFactory.getLogger(Regenerator.class);
    protected final World originalBukkitWorld;
    protected final Region region;
    protected final Extent target;
    protected final RegenOptions options;
    protected final Map<ChunkStatus, Concurrency> chunkStati = new LinkedHashMap<ChunkStatus, Concurrency>();
    protected boolean generateConcurrent = true;
    protected long seed;
    private final Long2ObjectLinkedOpenHashMap<ProtoChunk> protoChunks = new Long2ObjectLinkedOpenHashMap();
    private final Long2ObjectOpenHashMap<Chunk> chunks = new Long2ObjectOpenHashMap();
    private ExecutorService executor;
    private SingleThreadQueueExtent source;

    public Regenerator(World originalBukkitWorld, Region region, Extent target, RegenOptions options) {
        this.originalBukkitWorld = originalBukkitWorld;
        this.region = region;
        this.target = target;
        this.options = options;
    }

    public boolean regenerate() throws Exception {
        if (!this.prepare()) {
            return false;
        }
        try {
            if (!this.initNewWorld()) {
                this.cleanup0();
                return false;
            }
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        try {
            if (!this.generate()) {
                this.cleanup0();
                return false;
            }
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        try {
            this.copyToWorld();
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        this.cleanup0();
        return true;
    }

    protected ProtoChunk getProtoChunkAt(int x, int z) {
        return this.protoChunks.get(MathMan.pairInt(x, z));
    }

    protected Chunk getChunkAt(int x, int z) {
        return this.chunks.get(MathMan.pairInt(x, z));
    }

    private boolean generate() throws Exception {
        if (this.generateConcurrent) {
            this.executor = Executors.newFixedThreadPool(Settings.IMP.QUEUE.PARALLEL_THREADS);
        }
        Int2ObjectOpenHashMap chunkCoordsForRadius = new Int2ObjectOpenHashMap();
        this.chunkStati.keySet().stream().map(ChunkStatusWrapper::requiredNeigborChunkRadius0).distinct().forEach(radius -> {
            if (radius == -1) {
                return;
            }
            int border = 16 - radius;
            chunkCoordsForRadius.put((Integer)radius, this.getChunkCoordsRegen(this.region, border));
        });
        for (Iterator xz : (List)chunkCoordsForRadius.get(0)) {
            ProtoChunk ProtoChunk2 = this.createProtoChunk(MathMan.unpairIntX((Long)((Object)xz)), MathMan.unpairIntY((Long)((Object)xz)));
            this.protoChunks.put((Long)((Object)xz), ProtoChunk2);
        }
        Int2ObjectOpenHashMap worldlimits = new Int2ObjectOpenHashMap();
        this.chunkStati.keySet().stream().map(ChunkStatusWrapper::requiredNeigborChunkRadius0).distinct().forEach(radius -> {
            if (radius == -1) {
                return;
            }
            Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
            for (Long xz : (List)chunkCoordsForRadius.get(radius)) {
                int x = MathMan.unpairIntX(xz);
                int z = MathMan.unpairIntY(xz);
                ArrayList<ProtoChunk> l = new ArrayList<ProtoChunk>((radius + 1 + radius) * (radius + 1 + radius));
                for (int zz = z - radius; zz <= z + radius; ++zz) {
                    for (int xx = x - radius; xx <= x + radius; ++xx) {
                        l.add(this.protoChunks.get(MathMan.pairInt(xx, zz)));
                    }
                }
                map.put(xz, l);
            }
            worldlimits.put((Integer)radius, map);
        });
        for (Map.Entry entry : this.chunkStati.entrySet()) {
            Object scheduled;
            ChunkStatusWrapper chunkStatus = (ChunkStatusWrapper)entry.getKey();
            int radius2 = chunkStatus.requiredNeigborChunkRadius0();
            List coords = (List)chunkCoordsForRadius.get(radius2);
            if (this.generateConcurrent && entry.getValue() == Concurrency.RADIUS) {
                SequentialTasks<ConcurrentTasks<SequentialTasks<Long>>> tasks = this.getChunkStatusTaskRows(coords, radius2);
                for (ConcurrentTasks concurrentTasks : tasks) {
                    ArrayList<Callable<Object>> scheduled2 = new ArrayList<Callable<Object>>(tasks.size());
                    for (SequentialTasks row : concurrentTasks) {
                        scheduled2.add(() -> {
                            for (Long xz : row) {
                                chunkStatus.processChunkSave(xz, (List)((Long2ObjectOpenHashMap)worldlimits.get(radius2)).get(xz));
                            }
                            return null;
                        });
                    }
                    try {
                        List futures = this.executor.invokeAll(scheduled2);
                        for (Future future : futures) {
                            future.get();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            if (this.generateConcurrent && entry.getValue() == Concurrency.FULL) {
                scheduled = new ArrayList(coords.size());
                Iterator<Object> iterator = coords.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    scheduled.add(() -> {
                        chunkStatus.processChunkSave(xz, (List)((Long2ObjectOpenHashMap)worldlimits.get(radius2)).get(xz));
                        return null;
                    });
                }
                try {
                    List futures = this.executor.invokeAll(scheduled);
                    for (Future future : futures) {
                        future.get();
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            scheduled = coords.iterator();
            while (scheduled.hasNext()) {
                long xz = (Long)scheduled.next();
                chunkStatus.processChunkSave(xz, (List)((Long2ObjectOpenHashMap)worldlimits.get(radius2)).get(xz));
            }
        }
        for (Long l : (List)chunkCoordsForRadius.get(0)) {
            Object proto = this.protoChunks.get(l);
            this.chunks.put(l, this.createChunk(proto));
        }
        ChunkStatus FULL = this.getFullChunkStatus();
        for (Long xz : (List)chunkCoordsForRadius.get(0)) {
            Object chunk = this.chunks.get(xz);
            ((ChunkStatusWrapper)FULL).processChunkSave(xz, Arrays.asList(chunk));
        }
        List<BlockPopulator> list = this.getBlockPopulators();
        for (Long xz : (List)chunkCoordsForRadius.get(0)) {
            int x = MathMan.unpairIntX(xz);
            int z = MathMan.unpairIntY(xz);
            Random random = Regenerator.getChunkRandom(this.seed, x, z);
            Object v = this.chunks.get(xz);
            list.forEach(pop -> this.populate((Chunk)c, random, (BlockPopulator)pop));
        }
        this.source = new SingleThreadQueueExtent();
        this.source.init(null, this.initSourceQueueCache(), null);
        return true;
    }

    private void copyToWorld() {
        long start = System.currentTimeMillis();
        boolean genbiomes = this.options.shouldRegenBiomes();
        boolean hasBiome = this.options.hasBiomeType();
        BiomeType biome = this.options.getBiomeType();
        for (BlockVector3 vec : this.region) {
            this.target.setBlock(vec, this.source.getBlock(vec));
            if (hasBiome) {
                this.target.setBiome(vec, biome);
                continue;
            }
            if (!genbiomes) continue;
            this.target.setBiome(vec, this.source.getBiome(vec));
        }
    }

    private void cleanup0() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.cleanup();
    }

    protected abstract boolean prepare();

    protected abstract boolean initNewWorld() throws Exception;

    protected abstract void cleanup();

    protected abstract ProtoChunk createProtoChunk(int var1, int var2);

    protected abstract Chunk createChunk(ProtoChunk var1);

    protected abstract ChunkStatus getFullChunkStatus();

    protected abstract List<BlockPopulator> getBlockPopulators();

    protected abstract void populate(Chunk var1, Random var2, BlockPopulator var3);

    protected abstract IChunkCache<IChunkGet> initSourceQueueCache();

    private List<Long> getChunkCoordsRegen(Region region, int border) {
        BlockVector3 oldMin = region.getMinimumPoint();
        BlockVector3 newMin = BlockVector3.at((oldMin.getX() >> 4 << 4) - border * 16, oldMin.getY(), (oldMin.getZ() >> 4 << 4) - border * 16);
        BlockVector3 oldMax = region.getMaximumPoint();
        BlockVector3 newMax = BlockVector3.at((oldMax.getX() >> 4 << 4) + (border + 1) * 16 - 1, oldMax.getY(), (oldMax.getZ() >> 4 << 4) + (border + 1) * 16 - 1);
        CuboidRegion adjustedRegion = new CuboidRegion(newMin, newMax);
        return adjustedRegion.getChunks().stream().map(c -> BlockVector2.at(c.getX(), c.getZ())).sorted(Comparator.comparingInt(c -> c.getZ()).thenComparingInt(c -> c.getX())).map(c -> MathMan.pairInt(c.getX(), c.getZ())).collect(Collectors.toList());
    }

    private SequentialTasks<ConcurrentTasks<SequentialTasks<Long>>> getChunkStatusTaskRows(List<Long> allcoords, int requiredNeighborChunkRadius) {
        SequentialTasks<ConcurrentTasks<SequentialTasks<Long>>> tasks;
        int maxz;
        int requiredneighbors = Math.max(0, requiredNeighborChunkRadius);
        int minx = allcoords.isEmpty() ? 0 : MathMan.unpairIntX(allcoords.get(0));
        int maxx = allcoords.isEmpty() ? 0 : MathMan.unpairIntX(allcoords.get(allcoords.size() - 1));
        int minz = allcoords.isEmpty() ? 0 : MathMan.unpairIntY(allcoords.get(0));
        int n = maxz = allcoords.isEmpty() ? 0 : MathMan.unpairIntY(allcoords.get(allcoords.size() - 1));
        if (maxz - minz > maxx - minx) {
            int numlists = Math.min(requiredneighbors * 2 + 1, maxx - minx + 1);
            Int2ObjectOpenHashMap byx = new Int2ObjectOpenHashMap();
            int expectedListLength = (allcoords.size() + 1) / (maxx - minx);
            for (int i = minx; i <= maxx; ++i) {
                byx.put(i, new SequentialTasks(expectedListLength));
            }
            for (Long xz : allcoords) {
                ((SequentialTasks)byx.get(MathMan.unpairIntX(xz))).add(xz);
            }
            tasks = new SequentialTasks<ConcurrentTasks<SequentialTasks<Long>>>(numlists);
            for (int offset = 0; offset < numlists; ++offset) {
                ConcurrentTasks para = new ConcurrentTasks((maxz - minz + 1) / numlists + 1);
                int i = 0;
                while (minx + i * numlists + offset <= maxx) {
                    para.add(byx.get(minx + i * numlists + offset));
                    ++i;
                }
                tasks.add(para);
            }
        } else {
            int numlists = Math.min(requiredneighbors * 2 + 1, maxz - minz + 1);
            Int2ObjectOpenHashMap byz = new Int2ObjectOpenHashMap();
            int expectedListLength = (allcoords.size() + 1) / (maxz - minz);
            for (int i = minz; i <= maxz; ++i) {
                byz.put(i, new SequentialTasks(expectedListLength));
            }
            for (Long xz : allcoords) {
                ((SequentialTasks)byz.get(MathMan.unpairIntY(xz))).add(xz);
            }
            tasks = new SequentialTasks(numlists);
            for (int offset = 0; offset < numlists; ++offset) {
                ConcurrentTasks para = new ConcurrentTasks((maxx - minx + 1) / numlists + 1);
                int i = 0;
                while (minz + i * numlists + offset <= maxz) {
                    para.add(byz.get(minz + i * numlists + offset));
                    ++i;
                }
                tasks.add(para);
            }
        }
        return tasks;
    }

    private static Random getChunkRandom(long worldseed, int x, int z) {
        Random random = new Random();
        random.setSeed(worldseed);
        long xRand = random.nextLong() / 2L * 2L + 1L;
        long zRand = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)x * xRand + (long)z * zRand ^ worldseed);
        return random;
    }

    public static class Tasks<T>
    implements Iterable<T> {
        private final List<T> tasks;

        public Tasks(int expectedsize) {
            this.tasks = new ArrayList<T>(expectedsize);
        }

        public void add(T task) {
            this.tasks.add(task);
        }

        public List<T> list() {
            return this.tasks;
        }

        public int size() {
            return this.tasks.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.tasks.iterator();
        }

        public String toString() {
            return this.tasks.toString();
        }
    }

    public static class ConcurrentTasks<T>
    extends Tasks<T> {
        public ConcurrentTasks(int expectedsize) {
            super(expectedsize);
        }
    }

    public static class SequentialTasks<T>
    extends Tasks<T> {
        public SequentialTasks(int expectedsize) {
            super(expectedsize);
        }
    }

    public static enum Concurrency {
        FULL,
        RADIUS,
        NONE;

    }

    public static abstract class ChunkStatusWrapper<IChunkAccess> {
        public abstract int requiredNeigborChunkRadius();

        int requiredNeigborChunkRadius0() {
            return Math.max(0, this.requiredNeigborChunkRadius());
        }

        public abstract String name();

        public abstract void processChunk(Long var1, List<IChunkAccess> var2);

        void processChunkSave(Long xz, List<IChunkAccess> accessibleChunks) {
            try {
                this.processChunk(xz, accessibleChunks);
            }
            catch (Exception e) {
                logger.error("Error while running " + this.name() + " on chunk " + MathMan.unpairIntX(xz) + "/" + MathMan.unpairIntY(xz), e);
            }
        }
    }
}

