/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.regen;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.beta.IChunkCache;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.bukkit.adapter.mc1_15_2.BukkitGetBlocks_1_15_2;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.sk89q.worldedit.bukkit.adapter.Regenerator;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.world.RegenOptions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import net.minecraft.server.v1_15_R1.Area;
import net.minecraft.server.v1_15_R1.AreaContextTransformed;
import net.minecraft.server.v1_15_R1.AreaFactory;
import net.minecraft.server.v1_15_R1.AreaTransformer8;
import net.minecraft.server.v1_15_R1.BiomeBase;
import net.minecraft.server.v1_15_R1.BiomeLayoutOverworldConfiguration;
import net.minecraft.server.v1_15_R1.Biomes;
import net.minecraft.server.v1_15_R1.Chunk;
import net.minecraft.server.v1_15_R1.ChunkConverter;
import net.minecraft.server.v1_15_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_15_R1.ChunkGenerator;
import net.minecraft.server.v1_15_R1.ChunkProviderFlat;
import net.minecraft.server.v1_15_R1.ChunkProviderGenerate;
import net.minecraft.server.v1_15_R1.ChunkProviderHell;
import net.minecraft.server.v1_15_R1.ChunkProviderServer;
import net.minecraft.server.v1_15_R1.ChunkProviderTheEnd;
import net.minecraft.server.v1_15_R1.ChunkStatus;
import net.minecraft.server.v1_15_R1.DedicatedServer;
import net.minecraft.server.v1_15_R1.DefinedStructureManager;
import net.minecraft.server.v1_15_R1.GenLayer;
import net.minecraft.server.v1_15_R1.GenLayers;
import net.minecraft.server.v1_15_R1.GeneratorAccess;
import net.minecraft.server.v1_15_R1.GeneratorSettingsEnd;
import net.minecraft.server.v1_15_R1.GeneratorSettingsFlat;
import net.minecraft.server.v1_15_R1.GeneratorSettingsNether;
import net.minecraft.server.v1_15_R1.GeneratorSettingsOverworld;
import net.minecraft.server.v1_15_R1.IChunkAccess;
import net.minecraft.server.v1_15_R1.IRegistry;
import net.minecraft.server.v1_15_R1.LightEngineThreaded;
import net.minecraft.server.v1_15_R1.LinearCongruentialGenerator;
import net.minecraft.server.v1_15_R1.MinecraftKey;
import net.minecraft.server.v1_15_R1.MinecraftServer;
import net.minecraft.server.v1_15_R1.NBTTagCompound;
import net.minecraft.server.v1_15_R1.NoiseGeneratorPerlin;
import net.minecraft.server.v1_15_R1.ProtoChunk;
import net.minecraft.server.v1_15_R1.WorldChunkManager;
import net.minecraft.server.v1_15_R1.WorldChunkManagerOverworld;
import net.minecraft.server.v1_15_R1.WorldData;
import net.minecraft.server.v1_15_R1.WorldLoadListener;
import net.minecraft.server.v1_15_R1.WorldNBTStorage;
import net.minecraft.server.v1_15_R1.WorldServer;
import net.minecraft.server.v1_15_R1.WorldType;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftMagicNumbers;
import org.bukkit.generator.BlockPopulator;

public class Regen_v1_15_R2
extends Regenerator<IChunkAccess, ProtoChunk, Chunk, ChunkStatusWrap> {
    private static final Field serverWorldsField;
    private static final Field worldPaperConfigField;
    private static final Field flatBedrockField;
    private static final Field delegateField;
    private static final Field chunkProviderField;
    private static final Map<ChunkStatus, Regenerator.Concurrency> chunkStati;
    private WorldServer originalNMSWorld;
    private ChunkProviderServer originalChunkProvider;
    private WorldServer freshNMSWorld;
    private ChunkProviderServer freshChunkProvider;
    private DefinedStructureManager structureManager;
    private LightEngineThreaded lightEngine;
    private ChunkGenerator generator;
    private Path tempDir;
    private boolean generateFlatBedrock = false;

    public Regen_v1_15_R2(World originalBukkitWorld, Region region, Extent target, RegenOptions options) {
        super(originalBukkitWorld, region, target, options);
    }

    @Override
    protected boolean prepare() {
        this.originalNMSWorld = ((CraftWorld)this.originalBukkitWorld).getHandle();
        this.originalChunkProvider = this.originalNMSWorld.getChunkProvider();
        if (!(this.originalChunkProvider instanceof ChunkProviderServer)) {
            return false;
        }
        try {
            this.generateFlatBedrock = flatBedrockField.getBoolean(worldPaperConfigField.get(this.originalNMSWorld));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.seed = this.options.getSeed().orElse(this.originalNMSWorld.getSeed());
        chunkStati.forEach((s, c) -> ((Regenerator)this).chunkStati.put(new ChunkStatusWrap((ChunkStatus)s), (Regenerator.Concurrency)((Object)c)));
        return true;
    }

    @Override
    protected boolean initNewWorld() throws Exception {
        this.tempDir = Files.createTempDirectory("WorldEditWorldGen", new FileAttribute[0]);
        World.Environment env = this.originalBukkitWorld.getEnvironment();
        org.bukkit.generator.ChunkGenerator gen = this.originalBukkitWorld.getGenerator();
        DedicatedServer server = this.originalNMSWorld.getServer().getServer();
        WorldData newWorldData = new WorldData(this.originalNMSWorld.worldData.a((NBTTagCompound)null), server.dataConverterManager, CraftMagicNumbers.INSTANCE.getDataVersion(), (NBTTagCompound)null);
        newWorldData.setName("worldeditregentempworld");
        WorldNBTStorage saveHandler = new WorldNBTStorage(new File(this.tempDir.toUri()), this.originalNMSWorld.getDataManager().getDirectory().getName(), (MinecraftServer)server, server.dataConverterManager);
        this.freshNMSWorld = Fawe.get().getQueueHandler().sync(() -> this.lambda$initNewWorld$1((MinecraftServer)server, saveHandler, newWorldData, env, gen)).get();
        this.freshNMSWorld.savingDisabled = true;
        this.removeWorldFromWorldsMap();
        newWorldData.checkName(this.originalNMSWorld.getWorldData().getName());
        try {
            Object paperconf = worldPaperConfigField.get(this.freshNMSWorld);
            flatBedrockField.setBoolean(paperconf, this.generateFlatBedrock);
        }
        catch (Exception paperconf) {
            // empty catch block
        }
        DefinedStructureManager tmpStructureManager = saveHandler.f();
        this.freshChunkProvider = new ChunkProviderServer(this.freshNMSWorld, saveHandler.getDirectory(), server.aC(), tmpStructureManager, server.executorService, this.originalChunkProvider.chunkGenerator, this.freshNMSWorld.spigotConfig.viewDistance, new RegenNoOpWorldLoadListener(), () -> this.freshNMSWorld.getWorldPersistentData()){

            public IChunkAccess getChunkAt(int x, int z, ChunkStatus chunkstatus, boolean flag) {
                return (IChunkAccess)Regen_v1_15_R2.this.getProtoChunkAt(x, z);
            }
        };
        chunkProviderField.set(this.freshNMSWorld, this.freshChunkProvider);
        if (this.originalChunkProvider.getChunkGenerator() instanceof ChunkProviderFlat) {
            GeneratorSettingsFlat generatorSettingFlat = (GeneratorSettingsFlat)this.originalChunkProvider.getChunkGenerator().getSettings();
            this.generator = new ChunkProviderFlat((GeneratorAccess)this.freshNMSWorld, this.originalChunkProvider.getChunkGenerator().getWorldChunkManager(), generatorSettingFlat);
        } else if (this.originalChunkProvider.getChunkGenerator() instanceof ChunkProviderGenerate) {
            GeneratorSettingsOverworld settings = (GeneratorSettingsOverworld)this.originalChunkProvider.getChunkGenerator().getSettings();
            WorldChunkManager chunkManager = this.originalChunkProvider.getChunkGenerator().getWorldChunkManager();
            if (chunkManager instanceof WorldChunkManagerOverworld) {
                chunkManager = this.fastOverWorldChunkManager(chunkManager);
            }
            this.generator = new ChunkProviderGenerate((GeneratorAccess)this.freshNMSWorld, chunkManager, settings);
        } else if (this.originalChunkProvider.getChunkGenerator() instanceof ChunkProviderHell) {
            GeneratorSettingsNether settings = (GeneratorSettingsNether)this.originalChunkProvider.getChunkGenerator().getSettings();
            this.generator = new ChunkProviderHell((net.minecraft.server.v1_15_R1.World)this.freshNMSWorld, this.originalChunkProvider.getChunkGenerator().getWorldChunkManager(), settings);
        } else if (this.originalChunkProvider.getChunkGenerator() instanceof ChunkProviderTheEnd) {
            GeneratorSettingsEnd settings = (GeneratorSettingsEnd)this.originalChunkProvider.getChunkGenerator().getSettings();
            this.generator = new ChunkProviderTheEnd((GeneratorAccess)this.freshNMSWorld, this.originalChunkProvider.getChunkGenerator().getWorldChunkManager(), settings);
        } else if (this.originalChunkProvider.getChunkGenerator() instanceof CustomChunkGenerator) {
            ChunkGenerator delegate;
            this.generator = delegate = (ChunkGenerator)delegateField.get(this.originalChunkProvider.getChunkGenerator());
        } else {
            System.out.println("Unsupported generator type " + this.originalChunkProvider.getChunkGenerator().getClass().getName());
            return false;
        }
        if (this.originalNMSWorld.generator != null) {
            this.generator = new CustomChunkGenerator((net.minecraft.server.v1_15_R1.World)this.freshNMSWorld, this.originalNMSWorld.generator);
            this.generateConcurrent = this.originalNMSWorld.generator.isParallelCapable();
        }
        this.structureManager = tmpStructureManager;
        this.lightEngine = this.freshChunkProvider.getLightEngine();
        return true;
    }

    @Override
    protected void cleanup() {
        try {
            Fawe.get().getQueueHandler().sync(() -> {
                try {
                    this.freshChunkProvider.close(false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.removeWorldFromWorldsMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SafeFiles.tryHardToDeleteDir(this.tempDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected ProtoChunk createProtoChunk(int x, int z) {
        return new ProtoChunk(new ChunkCoordIntPair(x, z), ChunkConverter.a){

            public boolean generateFlatBedrock() {
                return Regen_v1_15_R2.this.generateFlatBedrock;
            }
        };
    }

    @Override
    protected Chunk createChunk(ProtoChunk protoChunk) {
        return new Chunk((net.minecraft.server.v1_15_R1.World)this.freshNMSWorld, protoChunk);
    }

    @Override
    protected ChunkStatusWrap getFullChunkStatus() {
        return new ChunkStatusWrap(ChunkStatus.FULL);
    }

    @Override
    protected List<BlockPopulator> getBlockPopulators() {
        return this.originalNMSWorld.getWorld().getPopulators();
    }

    @Override
    protected void populate(Chunk chunk, Random random, BlockPopulator pop) {
        pop.populate((World)this.freshNMSWorld.getWorld(), random, chunk.bukkitChunk);
    }

    @Override
    protected IChunkCache<IChunkGet> initSourceQueueCache() {
        return (chunkX, chunkZ) -> new BukkitGetBlocks_1_15_2(this.freshNMSWorld, chunkX, chunkZ){

            @Override
            public Chunk ensureLoaded(net.minecraft.server.v1_15_R1.World nmsWorld, int x, int z) {
                return (Chunk)Regen_v1_15_R2.this.getChunkAt(x, z);
            }
        };
    }

    private void removeWorldFromWorldsMap() {
        Fawe.get().getQueueHandler().sync(() -> {
            try {
                Map map = (Map)serverWorldsField.get(Bukkit.getServer());
                map.remove("worldeditregentempworld");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private WorldChunkManager fastOverWorldChunkManager(WorldChunkManager chunkManager) throws Exception {
        Field genLayerField = WorldChunkManagerOverworld.class.getDeclaredField("d");
        genLayerField.setAccessible(true);
        Field areaLazyField = GenLayer.class.getDeclaredField("b");
        areaLazyField.setAccessible(true);
        Method initAreaFactoryMethod = GenLayers.class.getDeclaredMethod("a", WorldType.class, GeneratorSettingsOverworld.class, LongFunction.class);
        initAreaFactoryMethod.setAccessible(true);
        BiomeLayoutOverworldConfiguration biomeconfig = new BiomeLayoutOverworldConfiguration(this.freshNMSWorld.getWorldData()).a((GeneratorSettingsOverworld)this.originalChunkProvider.getChunkGenerator().getSettings());
        AreaFactory factory = (AreaFactory)initAreaFactoryMethod.invoke(null, biomeconfig.b(), biomeconfig.c(), l -> new FastWorldGenContextArea(this.seed, l));
        if (this.options.hasBiomeType()) {
            BiomeBase biome = (BiomeBase)IRegistry.BIOME.get(MinecraftKey.a((String)this.options.getBiomeType().getId()));
            chunkManager = new SingleBiomeWorldChunkManagerOverworld(biome);
        } else {
            chunkManager = new WorldChunkManagerOverworld(biomeconfig);
            genLayerField.set(chunkManager, (Object)new FastGenLayer((AreaFactory<FastAreaLazy>)factory));
        }
        return chunkManager;
    }

    private /* synthetic */ WorldServer lambda$initNewWorld$1(MinecraftServer server, WorldNBTStorage saveHandler, WorldData newWorldData, World.Environment env, org.bukkit.generator.ChunkGenerator gen) {
        return new WorldServer(server, server.executorService, saveHandler, newWorldData, this.originalNMSWorld.worldProvider.getDimensionManager(), this.originalNMSWorld.getMethodProfiler(), new RegenNoOpWorldLoadListener(), env, gen){
            private final BiomeBase singleBiome;
            {
                this.singleBiome = Regen_v1_15_R2.this.options.hasBiomeType() ? (BiomeBase)IRegistry.BIOME.get(MinecraftKey.a((String)Regen_v1_15_R2.this.options.getBiomeType().getId())) : null;
            }

            public void doTick(BooleanSupplier booleansupplier) {
            }

            public BiomeBase a(int i, int k, int j) {
                if (Regen_v1_15_R2.this.options.hasBiomeType()) {
                    return this.singleBiome;
                }
                return this.getChunkProvider().getChunkGenerator().getWorldChunkManager().getBiome(i, j, k);
            }
        };
    }

    static {
        chunkStati = new LinkedHashMap<ChunkStatus, Regenerator.Concurrency>();
        chunkStati.put(ChunkStatus.EMPTY, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.STRUCTURE_STARTS, Regenerator.Concurrency.NONE);
        chunkStati.put(ChunkStatus.STRUCTURE_REFERENCES, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.BIOMES, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.NOISE, Regenerator.Concurrency.RADIUS);
        chunkStati.put(ChunkStatus.SURFACE, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.CARVERS, Regenerator.Concurrency.NONE);
        chunkStati.put(ChunkStatus.LIQUID_CARVERS, Regenerator.Concurrency.NONE);
        chunkStati.put(ChunkStatus.FEATURES, Regenerator.Concurrency.NONE);
        chunkStati.put(ChunkStatus.LIGHT, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.SPAWN, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.HEIGHTMAPS, Regenerator.Concurrency.FULL);
        try {
            serverWorldsField = CraftServer.class.getDeclaredField("worlds");
            serverWorldsField.setAccessible(true);
            Field tmpPaperConfigField = null;
            Field tmpFlatBedrockField = null;
            try {
                tmpPaperConfigField = net.minecraft.server.v1_15_R1.World.class.getDeclaredField("paperConfig");
                tmpPaperConfigField.setAccessible(true);
                tmpFlatBedrockField = tmpPaperConfigField.getType().getDeclaredField("generateFlatBedrock");
                tmpFlatBedrockField.setAccessible(true);
            }
            catch (Exception e) {
                tmpPaperConfigField = null;
                tmpFlatBedrockField = null;
            }
            worldPaperConfigField = tmpPaperConfigField;
            flatBedrockField = tmpFlatBedrockField;
            delegateField = CustomChunkGenerator.class.getDeclaredField("delegate");
            delegateField.setAccessible(true);
            chunkProviderField = net.minecraft.server.v1_15_R1.World.class.getDeclaredField("chunkProvider");
            chunkProviderField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RegenNoOpWorldLoadListener
    implements WorldLoadListener {
        private RegenNoOpWorldLoadListener() {
        }

        public void a(ChunkCoordIntPair chunkCoordIntPair) {
        }

        public void a(ChunkCoordIntPair chunkCoordIntPair, @Nullable ChunkStatus chunkStatus) {
        }

        public void b() {
        }

        public void setChunkRadius(int i) {
        }
    }

    private static class FastAreaLazy
    implements Area {
        private final AreaTransformer8 transformer;
        private final ConcurrentHashMap<Long, Integer> sharedMap;

        public FastAreaLazy(ConcurrentHashMap<Long, Integer> sharedMap, AreaTransformer8 transformer) {
            this.sharedMap = sharedMap;
            this.transformer = transformer;
        }

        public int a(int x, int z) {
            long zx = ChunkCoordIntPair.pair((int)x, (int)z);
            return this.sharedMap.computeIfAbsent(zx, i -> this.transformer.apply(x, z));
        }
    }

    private static class FastGenLayer
    extends GenLayer {
        private final FastAreaLazy areaLazy;

        public FastGenLayer(AreaFactory<FastAreaLazy> factory) throws Exception {
            super(() -> null);
            this.areaLazy = (FastAreaLazy)factory.make();
        }

        public BiomeBase a(int x, int z) {
            BiomeBase biome = (BiomeBase)IRegistry.BIOME.fromId(this.areaLazy.a(x, z));
            if (biome == null) {
                return Biomes.b;
            }
            return biome;
        }
    }

    private static class FastWorldGenContextArea
    implements AreaContextTransformed<FastAreaLazy> {
        private final ConcurrentHashMap<Long, Integer> sharedAreaMap = new ConcurrentHashMap();
        private final NoiseGeneratorPerlin perlinNoise;
        private final long magicrandom;
        private final ConcurrentHashMap<Long, Long> map = new ConcurrentHashMap();

        public FastWorldGenContextArea(long seed, long lconst) {
            this.magicrandom = FastWorldGenContextArea.mix(seed, lconst);
            this.perlinNoise = new NoiseGeneratorPerlin(new Random(seed));
        }

        public FastAreaLazy a(AreaTransformer8 var0) {
            return new FastAreaLazy(this.sharedAreaMap, var0);
        }

        public void a(long x, long z) {
            long l = this.magicrandom;
            l = LinearCongruentialGenerator.a((long)l, (long)x);
            l = LinearCongruentialGenerator.a((long)l, (long)z);
            l = LinearCongruentialGenerator.a((long)l, (long)x);
            l = LinearCongruentialGenerator.a((long)l, (long)z);
            this.map.put(Thread.currentThread().getId(), l);
        }

        public int a(int y) {
            long tid = Thread.currentThread().getId();
            long e = this.map.computeIfAbsent(tid, i -> 0L);
            int mod = (int)Math.floorMod(e >> 24, (long)y);
            this.map.put(tid, LinearCongruentialGenerator.a((long)e, (long)this.magicrandom));
            return mod;
        }

        public NoiseGeneratorPerlin b() {
            return this.perlinNoise;
        }

        private static long mix(long seed, long lconst) {
            long l1 = lconst;
            l1 = LinearCongruentialGenerator.a((long)l1, (long)lconst);
            l1 = LinearCongruentialGenerator.a((long)l1, (long)lconst);
            l1 = LinearCongruentialGenerator.a((long)l1, (long)lconst);
            long l2 = seed;
            l2 = LinearCongruentialGenerator.a((long)l2, (long)l1);
            l2 = LinearCongruentialGenerator.a((long)l2, (long)l1);
            l2 = LinearCongruentialGenerator.a((long)l2, (long)l1);
            return l2;
        }
    }

    private static class SingleBiomeWorldChunkManagerOverworld
    extends WorldChunkManager {
        private final BiomeBase biome;

        public SingleBiomeWorldChunkManagerOverworld(BiomeBase biome) {
            super((Set)ImmutableSet.of((Object)biome));
            this.biome = biome;
        }

        public BiomeBase getBiome(int i, int i1, int i2) {
            return this.biome;
        }
    }

    protected class ChunkStatusWrap
    extends Regenerator.ChunkStatusWrapper<IChunkAccess> {
        private final ChunkStatus chunkStatus;

        public ChunkStatusWrap(ChunkStatus chunkStatus) {
            this.chunkStatus = chunkStatus;
        }

        @Override
        public int requiredNeigborChunkRadius() {
            return this.chunkStatus.f();
        }

        @Override
        public String name() {
            return this.chunkStatus.d();
        }

        @Override
        public void processChunk(Long xz, List<IChunkAccess> accessibleChunks) {
            this.chunkStatus.a(Regen_v1_15_R2.this.freshNMSWorld, Regen_v1_15_R2.this.generator, Regen_v1_15_R2.this.structureManager, Regen_v1_15_R2.this.lightEngine, c -> CompletableFuture.completedFuture(Either.left((Object)c)), accessibleChunks);
        }
    }
}

