/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.regen;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.beta.IChunkCache;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.bukkit.adapter.mc1_16_1.BukkitGetBlocks_1_16_1;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.sk89q.worldedit.bukkit.adapter.Regenerator;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.world.RegenOptions;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import net.minecraft.server.v1_16_R1.Area;
import net.minecraft.server.v1_16_R1.AreaContextTransformed;
import net.minecraft.server.v1_16_R1.AreaFactory;
import net.minecraft.server.v1_16_R1.AreaTransformer8;
import net.minecraft.server.v1_16_R1.BiomeBase;
import net.minecraft.server.v1_16_R1.Biomes;
import net.minecraft.server.v1_16_R1.Chunk;
import net.minecraft.server.v1_16_R1.ChunkConverter;
import net.minecraft.server.v1_16_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R1.ChunkGeneratorAbstract;
import net.minecraft.server.v1_16_R1.ChunkProviderFlat;
import net.minecraft.server.v1_16_R1.ChunkProviderServer;
import net.minecraft.server.v1_16_R1.ChunkStatus;
import net.minecraft.server.v1_16_R1.Convertable;
import net.minecraft.server.v1_16_R1.DedicatedServer;
import net.minecraft.server.v1_16_R1.DefinedStructureManager;
import net.minecraft.server.v1_16_R1.DynamicOpsNBT;
import net.minecraft.server.v1_16_R1.GenLayer;
import net.minecraft.server.v1_16_R1.GenLayers;
import net.minecraft.server.v1_16_R1.GeneratorSettingBase;
import net.minecraft.server.v1_16_R1.GeneratorSettings;
import net.minecraft.server.v1_16_R1.GeneratorSettingsFlat;
import net.minecraft.server.v1_16_R1.IChunkAccess;
import net.minecraft.server.v1_16_R1.IRegistry;
import net.minecraft.server.v1_16_R1.IWorldDataServer;
import net.minecraft.server.v1_16_R1.LightEngineThreaded;
import net.minecraft.server.v1_16_R1.LinearCongruentialGenerator;
import net.minecraft.server.v1_16_R1.MinecraftKey;
import net.minecraft.server.v1_16_R1.MinecraftServer;
import net.minecraft.server.v1_16_R1.NBTBase;
import net.minecraft.server.v1_16_R1.NBTTagCompound;
import net.minecraft.server.v1_16_R1.NoiseGeneratorPerlin;
import net.minecraft.server.v1_16_R1.ProtoChunk;
import net.minecraft.server.v1_16_R1.ResourceKey;
import net.minecraft.server.v1_16_R1.World;
import net.minecraft.server.v1_16_R1.WorldChunkManager;
import net.minecraft.server.v1_16_R1.WorldChunkManagerOverworld;
import net.minecraft.server.v1_16_R1.WorldDataServer;
import net.minecraft.server.v1_16_R1.WorldDimension;
import net.minecraft.server.v1_16_R1.WorldLoadListener;
import net.minecraft.server.v1_16_R1.WorldPersistentData;
import net.minecraft.server.v1_16_R1.WorldServer;
import net.minecraft.server.v1_16_R1.WorldSettings;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R1.CraftServer;
import org.bukkit.craftbukkit.v1_16_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R1.generator.CustomChunkGenerator;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;

public class Regen_v1_16_R1
extends Regenerator<IChunkAccess, ProtoChunk, Chunk, ChunkStatusWrap> {
    private static final Field serverWorldsField;
    private static final Field worldPaperConfigField;
    private static final Field flatBedrockField;
    private static final Field generatorSettingBaseField;
    private static final Field generatorSettingFlatField;
    private static final Field delegateField;
    private static final Field chunkProviderField;
    private static final Map<ChunkStatus, Regenerator.Concurrency> chunkStati;
    private WorldServer originalNMSWorld;
    private ChunkProviderServer originalChunkProvider;
    private WorldServer freshNMSWorld;
    private ChunkProviderServer freshChunkProvider;
    private Convertable.ConversionSession session;
    private DefinedStructureManager structureManager;
    private LightEngineThreaded lightEngine;
    private net.minecraft.server.v1_16_R1.ChunkGenerator generator;
    private Path tempDir;
    private boolean generateFlatBedrock = false;

    public Regen_v1_16_R1(org.bukkit.World originalBukkitWorld, Region region, Extent target, RegenOptions options) {
        super(originalBukkitWorld, region, target, options);
    }

    @Override
    protected boolean prepare() {
        this.originalNMSWorld = ((CraftWorld)this.originalBukkitWorld).getHandle();
        this.originalChunkProvider = this.originalNMSWorld.getChunkProvider();
        if (!(this.originalChunkProvider instanceof ChunkProviderServer)) {
            return false;
        }
        try {
            this.generateFlatBedrock = flatBedrockField.getBoolean(worldPaperConfigField.get(this.originalNMSWorld));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.seed = this.options.getSeed().orElse(this.originalNMSWorld.getSeed());
        chunkStati.forEach((s, c) -> ((Regenerator)this).chunkStati.put(new ChunkStatusWrap((ChunkStatus)s), (Regenerator.Concurrency)((Object)c)));
        return true;
    }

    @Override
    protected boolean initNewWorld() throws Exception {
        this.tempDir = Files.createTempDirectory("WorldEditWorldGen", new FileAttribute[0]);
        World.Environment env = this.originalBukkitWorld.getEnvironment();
        ChunkGenerator gen = this.originalBukkitWorld.getGenerator();
        Convertable convertable = Convertable.a((Path)this.tempDir);
        ResourceKey<WorldDimension> worldDimKey = this.getWorldDimKey(env);
        this.session = convertable.c("worldeditregentempworld", worldDimKey);
        WorldDataServer originalWorldData = this.originalNMSWorld.worldDataServer;
        DedicatedServer server = this.originalNMSWorld.getServer().getServer();
        WorldDataServer levelProperties = (WorldDataServer)server.getSaveData();
        GeneratorSettings newOpts = (GeneratorSettings)GeneratorSettings.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)levelProperties.getGeneratorSettings()).flatMap(tag -> GeneratorSettings.a.parse(this.recursivelySetSeed((Dynamic<NBTBase>)new Dynamic((DynamicOps)DynamicOpsNBT.a, tag), this.seed, new HashSet<Dynamic<NBTBase>>()))).result().orElseThrow(() -> new IllegalStateException("Unable to map GeneratorOptions"));
        WorldSettings newWorldSettings = new WorldSettings("worldeditregentempworld", originalWorldData.b.getGameType(), originalWorldData.b.hardcore, originalWorldData.b.getDifficulty(), originalWorldData.b.e(), originalWorldData.b.getGameRules(), originalWorldData.b.g());
        WorldDataServer newWorldData = new WorldDataServer(newWorldSettings, newOpts, Lifecycle.stable());
        this.freshNMSWorld = Fawe.get().getQueueHandler().sync(() -> this.lambda$initNewWorld$3((MinecraftServer)server, newWorldData, newOpts, worldDimKey, env, gen)).get();
        this.freshNMSWorld.savingDisabled = true;
        this.removeWorldFromWorldsMap();
        newWorldData.checkName(this.originalNMSWorld.worldDataServer.getName());
        this.freshChunkProvider = new ChunkProviderServer(this.freshNMSWorld, this.session, server.getDataFixer(), server.getDefinedStructureManager(), server.executorService, this.originalChunkProvider.chunkGenerator, this.freshNMSWorld.spigotConfig.viewDistance, server.isSyncChunkWrites(), new RegenNoOpWorldLoadListener(), () -> Regen_v1_16_R1.lambda$initNewWorld$4((MinecraftServer)server)){

            public IChunkAccess getChunkAt(int x, int z, ChunkStatus chunkstatus, boolean flag) {
                return (IChunkAccess)Regen_v1_16_R1.this.getProtoChunkAt(x, z);
            }
        };
        chunkProviderField.set(this.freshNMSWorld, this.freshChunkProvider);
        if (this.originalChunkProvider.getChunkGenerator() instanceof ChunkProviderFlat) {
            GeneratorSettingsFlat generatorSettingFlat = (GeneratorSettingsFlat)generatorSettingFlatField.get(this.originalChunkProvider.getChunkGenerator());
            this.generator = new ChunkProviderFlat(generatorSettingFlat);
        } else if (this.originalChunkProvider.getChunkGenerator() instanceof ChunkGeneratorAbstract) {
            GeneratorSettingBase generatorSettingBase = (GeneratorSettingBase)generatorSettingBaseField.get(this.originalChunkProvider.getChunkGenerator());
            WorldChunkManager chunkManager = this.originalChunkProvider.getChunkGenerator().getWorldChunkManager();
            if (chunkManager instanceof WorldChunkManagerOverworld) {
                chunkManager = this.fastOverWorldChunkManager(chunkManager);
            }
            this.generator = new ChunkGeneratorAbstract(chunkManager, this.seed, generatorSettingBase);
        } else if (this.originalChunkProvider.getChunkGenerator() instanceof CustomChunkGenerator) {
            net.minecraft.server.v1_16_R1.ChunkGenerator delegate;
            this.generator = delegate = (net.minecraft.server.v1_16_R1.ChunkGenerator)delegateField.get(this.originalChunkProvider.getChunkGenerator());
        } else {
            System.out.println("Unsupported generator type " + this.originalChunkProvider.getChunkGenerator().getClass().getName());
            return false;
        }
        if (this.originalNMSWorld.generator != null) {
            this.generator = new CustomChunkGenerator(this.freshNMSWorld, this.generator, this.originalNMSWorld.generator);
            this.generateConcurrent = this.originalNMSWorld.generator.isParallelCapable();
        }
        this.structureManager = server.getDefinedStructureManager();
        this.lightEngine = this.freshChunkProvider.getLightEngine();
        return true;
    }

    @Override
    protected void cleanup() {
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Fawe.get().getQueueHandler().sync(() -> {
                try {
                    this.freshChunkProvider.close(false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.removeWorldFromWorldsMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SafeFiles.tryHardToDeleteDir(this.tempDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected ProtoChunk createProtoChunk(int x, int z) {
        return new ProtoChunk(new ChunkCoordIntPair(x, z), ChunkConverter.a){

            public boolean generateFlatBedrock() {
                return Regen_v1_16_R1.this.generateFlatBedrock;
            }
        };
    }

    @Override
    protected Chunk createChunk(ProtoChunk protoChunk) {
        return new Chunk((World)this.freshNMSWorld, protoChunk);
    }

    @Override
    protected ChunkStatusWrap getFullChunkStatus() {
        return new ChunkStatusWrap(ChunkStatus.FULL);
    }

    @Override
    protected List<BlockPopulator> getBlockPopulators() {
        return this.originalNMSWorld.getWorld().getPopulators();
    }

    @Override
    protected void populate(Chunk chunk, Random random, BlockPopulator pop) {
        pop.populate((org.bukkit.World)this.freshNMSWorld.getWorld(), random, chunk.bukkitChunk);
    }

    @Override
    protected IChunkCache<IChunkGet> initSourceQueueCache() {
        return (chunkX, chunkZ) -> new BukkitGetBlocks_1_16_1(this.freshNMSWorld, chunkX, chunkZ){

            @Override
            public Chunk ensureLoaded(World nmsWorld, int x, int z) {
                return (Chunk)Regen_v1_16_R1.this.getChunkAt(x, z);
            }
        };
    }

    private void removeWorldFromWorldsMap() {
        Fawe.get().getQueueHandler().sync(() -> {
            try {
                Map map = (Map)serverWorldsField.get(Bukkit.getServer());
                map.remove("worldeditregentempworld");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private ResourceKey<WorldDimension> getWorldDimKey(World.Environment env) {
        switch (env) {
            case NETHER: {
                return WorldDimension.THE_NETHER;
            }
            case THE_END: {
                return WorldDimension.THE_END;
            }
        }
        return WorldDimension.OVERWORLD;
    }

    private Dynamic<NBTBase> recursivelySetSeed(Dynamic<NBTBase> dynamic, long seed, Set<Dynamic<NBTBase>> seen) {
        return !seen.add(dynamic) ? dynamic : dynamic.updateMapValues(pair -> {
            if (((Dynamic)pair.getFirst()).asString("").equals("seed")) {
                return pair.mapSecond(v -> v.createLong(seed));
            }
            return ((Dynamic)pair.getSecond()).getValue() instanceof NBTTagCompound ? pair.mapSecond(v -> this.recursivelySetSeed((Dynamic<NBTBase>)v, seed, seen)) : pair;
        });
    }

    private WorldChunkManager fastOverWorldChunkManager(WorldChunkManager chunkManager) throws Exception {
        Field legacyBiomeInitLayerField = WorldChunkManagerOverworld.class.getDeclaredField("i");
        legacyBiomeInitLayerField.setAccessible(true);
        Field largeBiomesField = WorldChunkManagerOverworld.class.getDeclaredField("j");
        largeBiomesField.setAccessible(true);
        Field genLayerField = WorldChunkManagerOverworld.class.getDeclaredField("f");
        genLayerField.setAccessible(true);
        Field areaLazyField = GenLayer.class.getDeclaredField("b");
        areaLazyField.setAccessible(true);
        Method initAreaFactoryMethod = GenLayers.class.getDeclaredMethod("a", Boolean.TYPE, Integer.TYPE, Integer.TYPE, LongFunction.class);
        initAreaFactoryMethod.setAccessible(true);
        boolean legacyBiomeInitLayer = legacyBiomeInitLayerField.getBoolean(chunkManager);
        boolean largeBiomes = largeBiomesField.getBoolean(chunkManager);
        AreaFactory factory = (AreaFactory)initAreaFactoryMethod.invoke(null, legacyBiomeInitLayer, largeBiomes ? 6 : 4, 4, l -> new FastWorldGenContextArea(this.seed, l));
        if (this.options.hasBiomeType()) {
            BiomeBase biome = (BiomeBase)IRegistry.BIOME.get(MinecraftKey.a((String)this.options.getBiomeType().getId()));
            chunkManager = new SingleBiomeWorldChunkManagerOverworld(biome);
        } else {
            chunkManager = new WorldChunkManagerOverworld(this.seed, legacyBiomeInitLayer, largeBiomes);
            genLayerField.set(chunkManager, (Object)new FastGenLayer((AreaFactory<FastAreaLazy>)factory));
        }
        return chunkManager;
    }

    private static /* synthetic */ WorldPersistentData lambda$initNewWorld$4(MinecraftServer server) {
        return server.D().getWorldPersistentData();
    }

    private /* synthetic */ WorldServer lambda$initNewWorld$3(MinecraftServer server, WorldDataServer newWorldData, GeneratorSettings newOpts, ResourceKey worldDimKey, World.Environment env, ChunkGenerator gen) {
        return new WorldServer(server, server.executorService, this.session, (IWorldDataServer)newWorldData, this.originalNMSWorld.getDimensionKey(), this.originalNMSWorld.getTypeKey(), this.originalNMSWorld.getDimensionManager(), new RegenNoOpWorldLoadListener(), ((WorldDimension)newOpts.e().a(worldDimKey)).c(), this.originalNMSWorld.isDebugWorld(), this.seed, (List)ImmutableList.of(), false, env, gen){
            private final BiomeBase singleBiome;
            {
                this.singleBiome = Regen_v1_16_R1.this.options.hasBiomeType() ? (BiomeBase)IRegistry.BIOME.get(MinecraftKey.a((String)Regen_v1_16_R1.this.options.getBiomeType().getId())) : null;
            }

            public void doTick(BooleanSupplier booleansupplier) {
            }

            public BiomeBase a(int i, int j, int k) {
                if (Regen_v1_16_R1.this.options.hasBiomeType()) {
                    return this.singleBiome;
                }
                return this.getChunkProvider().getChunkGenerator().getWorldChunkManager().getBiome(i, j, k);
            }
        };
    }

    static {
        chunkStati = new LinkedHashMap<ChunkStatus, Regenerator.Concurrency>();
        chunkStati.put(ChunkStatus.EMPTY, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.STRUCTURE_STARTS, Regenerator.Concurrency.NONE);
        chunkStati.put(ChunkStatus.STRUCTURE_REFERENCES, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.BIOMES, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.NOISE, Regenerator.Concurrency.RADIUS);
        chunkStati.put(ChunkStatus.SURFACE, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.CARVERS, Regenerator.Concurrency.NONE);
        chunkStati.put(ChunkStatus.LIQUID_CARVERS, Regenerator.Concurrency.NONE);
        chunkStati.put(ChunkStatus.FEATURES, Regenerator.Concurrency.NONE);
        chunkStati.put(ChunkStatus.LIGHT, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.SPAWN, Regenerator.Concurrency.FULL);
        chunkStati.put(ChunkStatus.HEIGHTMAPS, Regenerator.Concurrency.FULL);
        try {
            serverWorldsField = CraftServer.class.getDeclaredField("worlds");
            serverWorldsField.setAccessible(true);
            Field tmpPaperConfigField = null;
            Field tmpFlatBedrockField = null;
            try {
                tmpPaperConfigField = World.class.getDeclaredField("paperConfig");
                tmpPaperConfigField.setAccessible(true);
                tmpFlatBedrockField = tmpPaperConfigField.getType().getDeclaredField("generateFlatBedrock");
                tmpFlatBedrockField.setAccessible(true);
            }
            catch (Exception e) {
                tmpPaperConfigField = null;
                tmpFlatBedrockField = null;
            }
            worldPaperConfigField = tmpPaperConfigField;
            flatBedrockField = tmpFlatBedrockField;
            generatorSettingBaseField = ChunkGeneratorAbstract.class.getDeclaredField("h");
            generatorSettingBaseField.setAccessible(true);
            generatorSettingFlatField = ChunkProviderFlat.class.getDeclaredField("e");
            generatorSettingFlatField.setAccessible(true);
            delegateField = CustomChunkGenerator.class.getDeclaredField("delegate");
            delegateField.setAccessible(true);
            chunkProviderField = WorldServer.class.getDeclaredField("chunkProvider");
            chunkProviderField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RegenNoOpWorldLoadListener
    implements WorldLoadListener {
        private RegenNoOpWorldLoadListener() {
        }

        public void a(ChunkCoordIntPair chunkCoordIntPair) {
        }

        public void a(ChunkCoordIntPair chunkCoordIntPair, @Nullable ChunkStatus chunkStatus) {
        }

        public void b() {
        }

        public void setChunkRadius(int i) {
        }
    }

    private static class FastAreaLazy
    implements Area {
        private final AreaTransformer8 transformer;
        private final ConcurrentHashMap<Long, Integer> sharedMap;

        public FastAreaLazy(ConcurrentHashMap<Long, Integer> sharedMap, AreaTransformer8 transformer) {
            this.sharedMap = sharedMap;
            this.transformer = transformer;
        }

        public int a(int x, int z) {
            long zx = ChunkCoordIntPair.pair((int)x, (int)z);
            return this.sharedMap.computeIfAbsent(zx, i -> this.transformer.apply(x, z));
        }
    }

    private static class FastGenLayer
    extends GenLayer {
        private final FastAreaLazy areaLazy;

        public FastGenLayer(AreaFactory<FastAreaLazy> factory) throws Exception {
            super(() -> null);
            this.areaLazy = (FastAreaLazy)factory.make();
        }

        public BiomeBase a(int x, int z) {
            BiomeBase biome = (BiomeBase)IRegistry.BIOME.fromId(this.areaLazy.a(x, z));
            if (biome == null) {
                return Biomes.b;
            }
            return biome;
        }
    }

    private static class FastWorldGenContextArea
    implements AreaContextTransformed<FastAreaLazy> {
        private final ConcurrentHashMap<Long, Integer> sharedAreaMap = new ConcurrentHashMap();
        private final NoiseGeneratorPerlin perlinNoise;
        private final long magicrandom;
        private final ConcurrentHashMap<Long, Long> map = new ConcurrentHashMap();

        public FastWorldGenContextArea(long seed, long lconst) {
            this.magicrandom = FastWorldGenContextArea.mix(seed, lconst);
            this.perlinNoise = new NoiseGeneratorPerlin(new Random(seed));
        }

        public FastAreaLazy a(AreaTransformer8 var0) {
            return new FastAreaLazy(this.sharedAreaMap, var0);
        }

        public void a(long x, long z) {
            long l = this.magicrandom;
            l = LinearCongruentialGenerator.a((long)l, (long)x);
            l = LinearCongruentialGenerator.a((long)l, (long)z);
            l = LinearCongruentialGenerator.a((long)l, (long)x);
            l = LinearCongruentialGenerator.a((long)l, (long)z);
            this.map.put(Thread.currentThread().getId(), l);
        }

        public int a(int y) {
            long tid = Thread.currentThread().getId();
            long e = this.map.computeIfAbsent(tid, i -> 0L);
            int mod = (int)Math.floorMod(e >> 24, (long)y);
            this.map.put(tid, LinearCongruentialGenerator.a((long)e, (long)this.magicrandom));
            return mod;
        }

        public NoiseGeneratorPerlin b() {
            return this.perlinNoise;
        }

        private static long mix(long seed, long lconst) {
            long l1 = lconst;
            l1 = LinearCongruentialGenerator.a((long)l1, (long)lconst);
            l1 = LinearCongruentialGenerator.a((long)l1, (long)lconst);
            l1 = LinearCongruentialGenerator.a((long)l1, (long)lconst);
            long l2 = seed;
            l2 = LinearCongruentialGenerator.a((long)l2, (long)l1);
            l2 = LinearCongruentialGenerator.a((long)l2, (long)l1);
            l2 = LinearCongruentialGenerator.a((long)l2, (long)l1);
            return l2;
        }
    }

    private static class SingleBiomeWorldChunkManagerOverworld
    extends WorldChunkManager {
        private final BiomeBase biome;

        public SingleBiomeWorldChunkManagerOverworld(BiomeBase biome) {
            super(Arrays.asList(biome));
            this.biome = biome;
        }

        protected Codec<? extends WorldChunkManager> a() {
            return WorldChunkManagerOverworld.e;
        }

        public BiomeBase getBiome(int i, int i1, int i2) {
            return this.biome;
        }
    }

    protected class ChunkStatusWrap
    extends Regenerator.ChunkStatusWrapper<IChunkAccess> {
        private final ChunkStatus chunkStatus;

        public ChunkStatusWrap(ChunkStatus chunkStatus) {
            this.chunkStatus = chunkStatus;
        }

        @Override
        public int requiredNeigborChunkRadius() {
            return this.chunkStatus.f();
        }

        @Override
        public String name() {
            return this.chunkStatus.d();
        }

        @Override
        public void processChunk(Long xz, List<IChunkAccess> accessibleChunks) {
            this.chunkStatus.a(Regen_v1_16_R1.this.freshNMSWorld, Regen_v1_16_R1.this.generator, Regen_v1_16_R1.this.structureManager, Regen_v1_16_R1.this.lightEngine, c -> CompletableFuture.completedFuture(Either.left((Object)c)), accessibleChunks);
        }
    }
}

