/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.config.Caption;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.RelightMode;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.command.util.annotation.Confirm;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.GroundFunction;
import com.sk89q.worldedit.function.generator.FloraGenerator;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.NoiseFilter2D;
import com.sk89q.worldedit.function.mask.SolidBlockMask;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.LayerVisitor;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.convolution.GaussianKernel;
import com.sk89q.worldedit.math.convolution.HeightMap;
import com.sk89q.worldedit.math.convolution.HeightMapFilter;
import com.sk89q.worldedit.math.noise.RandomNoise;
import com.sk89q.worldedit.regions.ConvexPolyhedralRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class RegionCommands {
    @Command(name="/set", desc="Sets all the blocks in the region")
    @CommandPermissions(value={"worldedit.region.set"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int set(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The pattern of blocks to set") Pattern pattern) {
        int affected = editSession.setBlocks(region, pattern);
        if (affected != 0) {
            actor.printInfo(TranslatableComponent.of("worldedit.set.done"));
        }
        return affected;
    }

    @Command(name="/air", aliases={"/0"}, desc="Sets all the blocks in the region to air")
    @CommandPermissions(value={"worldedit.region.set"})
    @Logging(value=Logging.LogMode.REGION)
    public void air(Actor actor, EditSession editSession, @Selection Region region) throws WorldEditException {
        this.set(actor, editSession, region, BlockTypes.AIR);
    }

    @Command(name="/test", desc="test region")
    @CommandPermissions(value={"worldedit.region.test"})
    @Logging(value=Logging.LogMode.REGION)
    public void test(Player player, EditSession editSession, @Arg(desc="test") double testValue) throws WorldEditException {
        player.print(TextComponent.of(testValue));
    }

    @Command(name="/fixlighting", desc="Get the light at a position")
    @CommandPermissions(value={"worldedit.light.fix"})
    public void fixLighting(Player player) throws WorldEditException {
        Location loc = player.getLocation();
        Region selection = player.getSelection();
        if (selection == null) {
            int cx = loc.getBlockX() >> 4;
            int cz = loc.getBlockZ() >> 4;
            selection = new CuboidRegion(BlockVector3.at(cx - 8, 0, cz - 8).multiply(16), BlockVector3.at(cx + 8, 0, cz + 8).multiply(16));
        }
        int count = FaweAPI.fixLighting(player.getWorld(), selection, null, RelightMode.ALL);
        player.print(Caption.of("fawe.info.lighting.propagate.selection", count));
    }

    @Command(name="/removelighting", aliases={"/removelight"}, desc="Removing lighting in a selection")
    @CommandPermissions(value={"worldedit.light.remove"})
    public void removeLighting(Player player) {
        Region selection = player.getSelection();
        if (selection == null) {
            int cx = player.getLocation().getBlockX() >> 4;
            int cz = player.getLocation().getBlockZ() >> 4;
            selection = new CuboidRegion(BlockVector3.at(cx - 8, 0, cz - 8).multiply(16), BlockVector3.at(cx + 8, 0, cz + 8).multiply(16));
        }
        int count = FaweAPI.fixLighting(player.getWorld(), selection, null, RelightMode.NONE);
        player.print(Caption.of("fawe.info.updated.lighting.selection", count));
    }

    @Command(name="/nbtinfo", aliases={"/nbt"}, desc="View nbt info for a block")
    @CommandPermissions(value={"worldedit.nbtinfo"})
    public void nbtinfo(Player player, EditSession editSession) {
        Location pos = player.getBlockTrace(128);
        if (pos == null) {
            player.printError(TranslatableComponent.of("fawe.navigation.no.block"));
            return;
        }
        CompoundTag nbt = editSession.getFullBlock(pos.toBlockPoint()).getNbtData();
        if (nbt != null) {
            player.print(TextComponent.of(nbt.getValue().toString()));
        } else {
            player.printError(TranslatableComponent.of("fawe.navigation.no.block"));
        }
    }

    @Command(name="/setblocklight", aliases={"/setlight"}, desc="Set block lighting in a selection")
    @CommandPermissions(value={"worldedit.light.set"})
    public void setlighting(Player player, EditSession editSession, @Selection Region region) {
        player.print(TextComponent.of("Temporarily not working"));
    }

    @Command(name="/setskylight", desc="Set sky lighting in a selection")
    @CommandPermissions(value={"worldedit.light.set"})
    public void setskylighting(Player player, @Selection Region region) {
        player.printInfo(TextComponent.of("Temporarily not working"));
    }

    @Command(name="/line", desc="Draws line segments between cuboid selection corners or convex polyhedral selection vertices", descFooter="Can only be used with a cuboid selection or a convex polyhedral selection")
    @CommandPermissions(value={"worldedit.region.line"})
    @Logging(value=Logging.LogMode.REGION)
    public int line(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The pattern of blocks to place") Pattern pattern, @Arg(desc="The thickness of the line", def={"0"}) int thickness, @Switch(name=104, desc="Generate only a shell") boolean shell) throws WorldEditException {
        if (!(region instanceof CuboidRegion)) {
            actor.printError(TranslatableComponent.of("worldedit.line.cuboid-only"));
            return 0;
        }
        CommandUtil.checkCommandArgument(thickness >= 0, "Thickness must be >= 0");
        CuboidRegion cuboidregion = (CuboidRegion)region;
        BlockVector3 pos1 = cuboidregion.getPos1();
        BlockVector3 pos2 = cuboidregion.getPos2();
        int blocksChanged = editSession.drawLine(pattern, pos1, pos2, thickness, !shell);
        actor.printInfo(TranslatableComponent.of("worldedit.line.changed", TextComponent.of(blocksChanged)));
        return blocksChanged;
    }

    @Command(name="/curve", desc="Draws a spline through selected points", descFooter="Can only be used with a convex polyhedral selection")
    @CommandPermissions(value={"worldedit.region.curve"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int curve(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The pattern of blocks to place") Pattern pattern, @Arg(desc="The thickness of the curve", def={"0"}) int thickness, @Switch(name=104, desc="Generate only a shell") boolean shell) throws WorldEditException {
        if (!(region instanceof ConvexPolyhedralRegion)) {
            actor.printError(TranslatableComponent.of("worldedit.curve.invalid-type"));
            return 0;
        }
        CommandUtil.checkCommandArgument(thickness >= 0, "Thickness must be >= 0");
        ConvexPolyhedralRegion cpregion = (ConvexPolyhedralRegion)region;
        ArrayList<BlockVector3> vectors = new ArrayList<BlockVector3>(cpregion.getVertices());
        int blocksChanged = editSession.drawSpline(pattern, vectors, 0.0, 0.0, 0.0, 10.0, thickness, !shell);
        actor.printInfo(TranslatableComponent.of("worldedit.curve.changed", TextComponent.of(blocksChanged)));
        return blocksChanged;
    }

    @Command(name="/replace", aliases={"/re", "/rep"}, desc="Replace all blocks in the selection with another")
    @CommandPermissions(value={"worldedit.region.replace"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int replace(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The mask representing blocks to replace", def={""}) Mask from, @Arg(desc="The pattern of blocks to replace with") Pattern to) throws WorldEditException {
        if (from == null) {
            from = new ExistingBlockMask(editSession);
        }
        int affected = editSession.replaceBlocks(region, from, to);
        actor.printInfo(TranslatableComponent.of("worldedit.replace.replaced", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/overlay", desc="Set a block on top of blocks in the region")
    @CommandPermissions(value={"worldedit.region.overlay"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int overlay(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The pattern of blocks to overlay") Pattern pattern) throws WorldEditException {
        int affected = editSession.overlayCuboidBlocks(region, pattern);
        actor.printInfo(TranslatableComponent.of("worldedit.overlay.overlaid", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/lay", desc="Set the top block in the region")
    @CommandPermissions(value={"worldedit.region.overlay"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public void lay(Player player, EditSession editSession, @Selection Region region, @Arg(name="pattern", desc="The pattern of blocks to lay") Pattern patternArg) throws WorldEditException {
        BlockVector3 max = region.getMaximumPoint();
        int maxY = max.getBlockY();
        Iterable<BlockVector2> flat = Regions.asFlatRegion(region).asFlatRegion();
        Iterator<BlockVector2> iter = flat.iterator();
        int y = 0;
        int affected = 0;
        while (iter.hasNext()) {
            BlockVector2 pos = iter.next();
            int x = pos.getBlockX();
            int z = pos.getBlockZ();
            y = editSession.getNearestSurfaceTerrainBlock(x, z, y, 0, maxY);
            editSession.setBlock(x, y, z, patternArg);
            ++affected;
        }
        player.print(Caption.of("fawe.worldedit.visitor.visitor.block", affected));
    }

    @Command(name="/center", aliases={"/middle"}, desc="Set the center block(s)")
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.region.center"})
    public int center(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The pattern of blocks to set") Pattern pattern) throws WorldEditException {
        int affected = editSession.center(region, pattern);
        actor.printInfo(TranslatableComponent.of("worldedit.center.changed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/naturalize", desc="3 layers of dirt on top then rock below")
    @CommandPermissions(value={"worldedit.region.naturalize"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int naturalize(Actor actor, EditSession editSession, @Selection Region region) throws WorldEditException {
        int affected = editSession.naturalizeCuboidBlocks(region);
        actor.printInfo(TranslatableComponent.of("worldedit.naturalize.naturalized", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/walls", desc="Build the four sides of the selection")
    @CommandPermissions(value={"worldedit.region.walls"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int walls(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The pattern of blocks to set") Pattern pattern) throws WorldEditException {
        int affected = editSession.makeWalls(region, pattern);
        actor.printInfo(TranslatableComponent.of("worldedit.walls.changed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/faces", aliases={"/outline"}, desc="Build the walls, ceiling, and floor of a selection")
    @CommandPermissions(value={"worldedit.region.faces"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int faces(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The pattern of blocks to set") Pattern pattern) throws WorldEditException {
        int affected = editSession.makeCuboidFaces(region, pattern);
        actor.printInfo(TranslatableComponent.of("worldedit.faces.changed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/smooth", desc="Smooth the elevation in the selection", descFooter="Example: '//smooth 1 grass_block,dirt,stone' would only smooth natural surface terrain.")
    @CommandPermissions(value={"worldedit.region.smooth"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int smooth(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="# of iterations to perform", def={"1"}) int iterations, @Arg(desc="The mask of blocks to use as the height map", def={""}) Mask mask, @Switch(name=115, desc="The flag makes it only consider snow") boolean snow) throws WorldEditException {
        int affected;
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        long volume = ((long)max.getX() - (long)min.getX() + 1L) * ((long)max.getY() - (long)min.getY() + 1L) * ((long)max.getZ() - (long)min.getZ() + 1L);
        FaweLimit limit = actor.getLimit();
        if (volume >= (long)limit.MAX_CHECKS) {
            throw FaweCache.MAX_CHECKS;
        }
        try {
            HeightMap heightMap = new HeightMap(editSession, region, mask, snow);
            HeightMapFilter filter = new HeightMapFilter(new GaussianKernel(5, 1.0));
            affected = heightMap.applyFilter(filter, iterations);
            actor.printInfo(TranslatableComponent.of("worldedit.smooth.changed", TextComponent.of(affected)));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return affected;
    }

    @Command(name="/wea", aliases={"wea", "worldeditanywhere", "/worldeditanywhere", "/weanywhere"}, desc="Bypass region restrictions", descFooter="Bypass region restrictions")
    @CommandPermissions(value={"fawe.admin"})
    public void wea(Actor actor) throws WorldEditException {
        if (actor.togglePermission("fawe.bypass")) {
            actor.print(TranslatableComponent.of("fawe.info.worldedit.bypassed"));
        } else {
            actor.print(TranslatableComponent.of("fawe.info.worldedit.restricted"));
        }
    }

    @Command(name="/wer", aliases={"wer", "worldeditregion", "/worldeditregion", "select", "/select"}, desc="Select your current allowed region", descFooter="Select your current allowed region")
    @CommandPermissions(value={"fawe.worldeditregion"})
    public void wer(Player player) throws WorldEditException {
        Region region = player.getLargestRegion();
        if (region == null) {
            player.print(TranslatableComponent.of("fawe.error.no.region"));
        } else {
            player.setSelection(region);
            player.print(TranslatableComponent.of("fawe.info.set.region"));
        }
    }

    @Command(name="/move", aliases={"/mv"}, desc="Move the contents of the selection")
    @CommandPermissions(value={"worldedit.region.move"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int move(Actor actor, World world, EditSession editSession, LocalSession session, @Selection Region region, @Arg(desc="# of blocks to move", def={"1"}) int count, @Direction(includeDiagonals=true) @Arg(desc="The direction to move", def={"me"}) BlockVector3 direction, @Arg(desc="The pattern of blocks to leave", def={"air"}) Pattern replace, @Switch(name=115, desc="Shift the selection to the target location") boolean moveSelection, @Switch(name=97, desc="Ignore air blocks") boolean ignoreAirBlocks, @Switch(name=101, desc="Also copy entities") boolean copyEntities, @Switch(name=98, desc="Also copy biomes") boolean copyBiomes, @ArgFlag(name=109, desc="Set the include mask, non-matching blocks become air") Mask mask) throws WorldEditException {
        CommandUtil.checkCommandArgument(count >= 1, "Count must be >= 1");
        Mask combinedMask = ignoreAirBlocks ? (mask == null ? new ExistingBlockMask(editSession) : new MaskIntersection(mask, new ExistingBlockMask(editSession))) : mask;
        int affected = editSession.moveRegion(region, direction, count, copyEntities, copyBiomes, combinedMask, replace);
        if (moveSelection) {
            try {
                region.shift(direction.multiply(count));
                session.getRegionSelector(world).learnChanges();
                session.getRegionSelector(world).explainRegionAdjust(actor, session);
            }
            catch (RegionOperationException e) {
                actor.printError(TextComponent.of(e.getMessage()));
            }
        }
        actor.printInfo(TranslatableComponent.of("worldedit.move.moved", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/fall", desc="Have the blocks in the selection fall", descFooter="Make the blocks in the selection fall\n")
    @CommandPermissions(value={"worldedit.region.fall"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public void fall(Player player, EditSession editSession, LocalSession session, @Selection Region region, @Arg(desc="BlockStateHolder", def={"air"}) BlockStateHolder replace, @Switch(name=109, desc="Only fall within the vertical selection") boolean notFullHeight) throws WorldEditException {
        int affected = editSession.fall(region, !notFullHeight, replace);
        player.print(Caption.of("fawe.worldedit.visitor.visitor.block", affected));
    }

    @Command(name="/stack", desc="Repeat the contents of the selection")
    @CommandPermissions(value={"worldedit.region.stack"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    public int stack(Actor actor, World world, EditSession editSession, LocalSession session, @Selection Region region, @Confirm(value=Confirm.Processor.REGION) @Arg(desc="# of copies to stack", def={"1"}) int count, @Direction(includeDiagonals=true) @Arg(desc="The direction to stack", def={"me"}) BlockVector3 direction, @Switch(name=115, desc="Shift the selection to the last stacked copy") boolean moveSelection, @Switch(name=97, desc="Ignore air blocks") boolean ignoreAirBlocks, @Switch(name=101, desc="Also copy entities") boolean copyEntities, @Switch(name=98, desc="Also copy biomes") boolean copyBiomes, @ArgFlag(name=109, desc="Set the include mask, non-matching blocks become air") Mask mask) throws WorldEditException {
        Mask combinedMask = ignoreAirBlocks ? (mask == null ? new ExistingBlockMask(editSession) : new MaskIntersection(mask, new ExistingBlockMask(editSession))) : mask;
        int affected = editSession.stackCuboidRegion(region, direction, count, copyEntities, copyBiomes, combinedMask);
        if (moveSelection) {
            try {
                BlockVector3 size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
                BlockVector3 shiftVector = direction.multiply(size).multiply(count);
                region.shift(shiftVector);
                session.getRegionSelector(world).learnChanges();
                session.getRegionSelector(world).explainRegionAdjust(actor, session);
            }
            catch (RegionOperationException e) {
                actor.printError(TextComponent.of(e.getMessage()));
            }
        }
        actor.printInfo(TranslatableComponent.of("worldedit.stack.changed", TextComponent.of(affected)));
        return affected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="/regen", desc="Regenerates the contents of the selection", descFooter="This command might affect things outside the selection,\nif they are within the same chunk.")
    @CommandPermissions(value={"worldedit.regen"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    void regenerate(Actor actor, World world, LocalSession session, EditSession editSession, @Selection Region region, @Arg(desc="The seed to regenerate with, otherwise uses world seed", def={""}) Long seed, @Switch(name=98, desc="Regenerate biomes as well") boolean regenBiomes, @Arg(desc="Biome to apply for this regeneration (only works in overworld)", def={""}) BiomeType biomeType) throws WorldEditException {
        boolean success;
        Mask mask = session.getMask();
        try {
            session.setMask(null);
            session.setSourceMask(null);
            actor.printInfo(TranslatableComponent.of("fawe.regen.time"));
            RegenOptions options = RegenOptions.builder().seed(seed).regenBiomes(regenBiomes).biomeType(biomeType).build();
            success = world.regenerate(region, editSession, options);
        }
        finally {
            session.setMask(mask);
            session.setSourceMask(mask);
        }
        if (success) {
            actor.printInfo(TranslatableComponent.of("worldedit.regen.regenerated"));
        } else {
            actor.printError(TranslatableComponent.of("worldedit.regen.failed"));
        }
    }

    @Command(name="/deform", desc="Deforms a selected region with an expression", descFooter="The expression is executed for each block and is expected\nto modify the variables x, y and z to point to a new block\nto fetch. See also https://tinyurl.com/weexpr")
    @CommandPermissions(value={"worldedit.region.deform"})
    @Logging(value=Logging.LogMode.ALL)
    @Confirm(value=Confirm.Processor.REGION)
    public int deform(Actor actor, LocalSession session, EditSession editSession, @Selection Region region, @Arg(desc="The expression to use", variable=true) List<String> expression, @Switch(name=114, desc="Use the game's coordinate origin") boolean useRawCoords, @Switch(name=111, desc="Use the placement's coordinate origin") boolean offset, @Switch(name=99, desc="Use the selection's center as origin") boolean offsetCenter) throws WorldEditException {
        Vector3 max;
        Vector3 min;
        Vector3 unit;
        Vector3 zero;
        if (useRawCoords) {
            zero = Vector3.ZERO;
            unit = Vector3.ONE;
        } else if (offsetCenter) {
            min = region.getMinimumPoint().toVector3();
            max = region.getMaximumPoint().toVector3();
            zero = max.add(min).multiply(0.5);
            unit = Vector3.ONE;
        } else if (offset) {
            zero = session.getPlacementPosition(actor).toVector3();
            unit = Vector3.ONE;
        } else {
            min = region.getMinimumPoint().toVector3();
            max = region.getMaximumPoint().toVector3();
            unit = max.subtract(zero = max.add(min).divide(2.0));
            if (unit.getX() == 0.0) {
                unit = unit.withX(1.0);
            }
            if (unit.getY() == 0.0) {
                unit = unit.withY(1.0);
            }
            if (unit.getZ() == 0.0) {
                unit = unit.withZ(1.0);
            }
        }
        Vector3 unit1 = unit;
        try {
            int affected = editSession.deformRegion(region, zero, unit1, String.join((CharSequence)" ", expression), session.getTimeout());
            if (actor instanceof Player) {
                ((Player)actor).findFreePosition();
            }
            actor.printInfo(TranslatableComponent.of("worldedit.deform.deformed", TextComponent.of(affected)));
            return affected;
        }
        catch (ExpressionException e) {
            actor.printError(TextComponent.of(e.getMessage()));
            return 0;
        }
    }

    @Command(name="/hollow", desc="Hollows out the object contained in this selection", descFooter="Hollows out the object contained in this selection.\nOptionally fills the hollowed out part with the given block.\nThickness is measured in manhattan distance.")
    @CommandPermissions(value={"worldedit.region.hollow"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int hollow(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="Thickness of the shell to leave", def={"0"}) int thickness, @Arg(desc="The pattern of blocks to replace the hollowed area with", def={"air"}) Pattern pattern, @ArgFlag(name=109, desc="Mask to hollow with") Mask mask) throws WorldEditException {
        CommandUtil.checkCommandArgument(thickness >= 0, "Thickness must be >= 0");
        Mask finalMask = mask == null ? new SolidBlockMask(editSession) : mask;
        int affected = editSession.hollowOutRegion(region, thickness, pattern, finalMask);
        actor.printInfo(TranslatableComponent.of("worldedit.hollow.changed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/forest", desc="Make a forest within the region")
    @CommandPermissions(value={"worldedit.region.forest"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int forest(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The type of tree to place", def={"tree"}) TreeGenerator.TreeType type, @Arg(desc="The density of the forest", def={"5"}) double density) throws WorldEditException {
        CommandUtil.checkCommandArgument(0.0 <= density && density <= 100.0, "Density must be in [0, 100]");
        int affected = editSession.makeForest(region, density / 100.0, type);
        actor.printInfo(TranslatableComponent.of("worldedit.forest.created", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/flora", desc="Make flora within the region")
    @CommandPermissions(value={"worldedit.region.flora"})
    @Logging(value=Logging.LogMode.REGION)
    @Confirm(value=Confirm.Processor.REGION)
    public int flora(Actor actor, EditSession editSession, @Selection Region region, @Arg(desc="The density of the forest", def={"5"}) double density) throws WorldEditException {
        CommandUtil.checkCommandArgument(0.0 <= density && density <= 100.0, "Density must be in [0, 100]");
        FloraGenerator generator = new FloraGenerator(editSession);
        GroundFunction ground = new GroundFunction(new ExistingBlockMask(editSession), generator);
        LayerVisitor visitor = new LayerVisitor(Regions.asFlatRegion(region), Regions.minimumBlockY(region), Regions.maximumBlockY(region), ground);
        visitor.setMask(new NoiseFilter2D(new RandomNoise(), density /= 100.0));
        Operations.completeLegacy(visitor);
        int affected = ground.getAffected();
        actor.printInfo(TranslatableComponent.of("worldedit.flora.created", TextComponent.of(affected)));
        return affected;
    }
}

