/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.config.Caption;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.clipboard.MultiClipboardHolder;
import com.boydti.fawe.object.clipboard.URIClipboardHolder;
import com.boydti.fawe.object.schematic.MinecraftStructure;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.ReflectionUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.FlattenedClipboardTransform;
import com.sk89q.worldedit.command.UtilityCommands;
import com.sk89q.worldedit.command.argument.Arguments;
import com.sk89q.worldedit.command.util.AsyncCommandBuilder;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.extent.ActorSaveClipboardEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.util.formatting.component.ErrorFormat;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.component.TextComponentProducer;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.io.Closer;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;
import org.enginehub.piston.exception.StopExecutionException;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class SchematicCommands {
    private static final Logger log = LoggerFactory.getLogger(SchematicCommands.class);
    private final WorldEdit worldEdit;

    public SchematicCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    private static List<File> getFiles(File root, String filter, ClipboardFormat format) {
        File[] files = root.listFiles();
        if (files == null) {
            return null;
        }
        if (format != null) {
            files = (File[])Arrays.stream(files).filter(format::isFormat).toArray(File[]::new);
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (File f : files) {
            if (f.isDirectory()) {
                List<File> subFiles = SchematicCommands.getFiles(f, filter, format);
                if (subFiles == null) continue;
                fileList.addAll(subFiles);
                continue;
            }
            fileList.add(f);
        }
        return fileList;
    }

    @Command(name="loadall", desc="Load multiple clipboards (paste will randomly choose one)")
    @Deprecated
    @CommandPermissions(value={"worldedit.clipboard.load", "worldedit.schematic.load", "worldedit.schematic.load.web", "worldedit.schematic.load.asset"})
    public void loadall(Player player, LocalSession session, @Arg(desc="Format name.", def={"fast"}) String formatName, @Arg(desc="File name.") String filename, @Switch(name=114, desc="Apply random rotation") boolean randomRotate) throws FilenameException {
        ClipboardFormat format = ClipboardFormats.findByAlias(formatName);
        if (format == null) {
            player.print(Caption.of("fawe.worldedit.clipboard.clipboard.invalid.format", formatName));
            return;
        }
        try {
            MultiClipboardHolder all = ClipboardFormats.loadAllFromInput(player, filename, null, true);
            if (all != null) {
                session.addClipboard(all);
                player.print(Caption.of("fawe.worldedit.schematic.schematic.loaded", filename));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Command(name="clear", desc="Clear your clipboard")
    @CommandPermissions(value={"worldedit.clipboard.clear", "worldedit.schematic.clear"})
    public void clear(Player player, LocalSession session) throws WorldEditException {
        session.setClipboard(null);
        player.print(TranslatableComponent.of("fawe.worldedit.clipboard.clipboard.cleared"));
    }

    @Command(name="unload", desc="Remove a clipboard from your multi-clipboard")
    @CommandPermissions(value={"worldedit.clipboard.clear", "worldedit.schematic.clear"})
    public void unload(Player player, LocalSession session, String fileName) throws WorldEditException {
        URIClipboardHolder identifiable;
        URI uri;
        if (fileName.startsWith("file:/") || fileName.startsWith("http://") || fileName.startsWith("https://")) {
            uri = URI.create(fileName);
        } else {
            LocalConfiguration config = this.worldEdit.getConfiguration();
            File working = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
            File root = Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? new File(working, player.getUniqueId().toString()) : working;
            uri = new File(root, fileName).toURI();
        }
        ClipboardHolder clipboard = session.getClipboard();
        if (clipboard instanceof URIClipboardHolder && (identifiable = (URIClipboardHolder)clipboard).contains(uri)) {
            if (identifiable instanceof MultiClipboardHolder) {
                MultiClipboardHolder multi = (MultiClipboardHolder)identifiable;
                multi.remove(uri);
                if (multi.getHolders().isEmpty()) {
                    session.setClipboard(null);
                }
            } else {
                session.setClipboard(null);
            }
            player.print(TranslatableComponent.of("fawe.worldedit.clipboard.clipboard.cleared"));
            return;
        }
        player.print(Caption.of("fawe.worldedit.clipboard.clipboard.uri.not.found", fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(name="load", desc="Load a schematic into your clipboard")
    @CommandPermissions(value={"worldedit.clipboard.load", "worldedit.schematic.load", "worldedit.schematic.load.asset", "worldedit.schematic.load.web", "worldedit.schematic.load.other"})
    public void load(Actor actor, LocalSession session, @Arg(desc="File name.") String filename, @Arg(desc="Format name.", def={"fast"}) String formatName) throws FilenameException {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        ClipboardFormat format = null;
        InputStream in = null;
        try {
            URI uri;
            if (formatName.startsWith("url:")) {
                String t = filename;
                filename = formatName;
                formatName = t;
            }
            if (filename.startsWith("url:")) {
                if (!actor.hasPermission("worldedit.schematic.load.web")) {
                    actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.load.web"));
                    return;
                }
                UUID uuid = UUID.fromString(filename.substring(4));
                URL webUrl = new URL(Settings.IMP.WEB.URL);
                format = ClipboardFormats.findByAlias(formatName);
                URL url = new URL(webUrl, "uploads/" + uuid + "." + format.getPrimaryFileExtension());
                ReadableByteChannel byteChannel = Channels.newChannel(url.openStream());
                in = Channels.newInputStream(byteChannel);
                uri = url.toURI();
            } else {
                File file;
                File dir;
                File saveDir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
                File file2 = dir = Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? new File(saveDir, actor.getUniqueId().toString()) : saveDir;
                if (filename.startsWith("#")) {
                    format = ClipboardFormats.findByAlias(formatName);
                    String[] extensions = format != null ? format.getFileExtensions().toArray(new String[0]) : ClipboardFormats.getFileExtensionArray();
                    file = actor.openFileOpenDialog(extensions);
                    if (file == null || !file.exists()) {
                        actor.printError(TranslatableComponent.of("worldedit.schematic.load.does-not-exist", TextComponent.of(filename)));
                        return;
                    }
                } else {
                    if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && !actor.hasPermission("worldedit.schematic.load.other") && Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matcher(filename).find()) {
                        actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.load.other"));
                        return;
                    }
                    format = filename.matches(".*\\.[\\w].*") ? ClipboardFormats.findByExtension(filename.substring(filename.lastIndexOf(46) + 1)) : ClipboardFormats.findByAlias(formatName);
                    file = MainUtil.resolve(dir, filename, format, false);
                }
                if (!(file != null && file.exists() || filename.contains("../"))) {
                    dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
                    file = MainUtil.resolve(dir, filename, format, false);
                }
                if (file == null || !file.exists() || !MainUtil.isInSubDirectory(saveDir, file)) {
                    actor.printError("Schematic " + filename + " does not exist! (" + (file != null && file.exists()) + "|" + file + "|" + (file != null && !MainUtil.isInSubDirectory(saveDir, file)) + ")");
                    return;
                }
                if (format == null && (format = ClipboardFormats.findByFile(file)) == null) {
                    actor.printError(TranslatableComponent.of("worldedit.schematic.unknown-format", TextComponent.of(formatName)));
                    return;
                }
                in = new FileInputStream(file);
                uri = file.toURI();
            }
            format.hold(actor, uri, in);
            actor.print(Caption.of("fawe.worldedit.schematic.schematic.loaded", filename));
            return;
        }
        catch (IllegalArgumentException e) {
            actor.printError("Unknown filename: " + filename);
            return;
        }
        catch (IOException | URISyntaxException e) {
            actor.printError("File could not be read or it does not exist: " + e.getMessage());
            log.warn("Failed to load a saved clipboard", e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Command(name="save", desc="Save a schematic into your clipboard")
    @CommandPermissions(value={"worldedit.clipboard.save", "worldedit.schematic.save", "worldedit.schematic.save.other"})
    public void save(Actor actor, LocalSession session, @Arg(desc="File name.") String filename, @Arg(desc="Format name.", def={"fast"}) String formatName, @Switch(name=102, desc="Overwrite an existing file.") boolean allowOverwrite, @Switch(name=103, desc="//TODO") boolean global) throws WorldEditException {
        File parent;
        File f;
        boolean overwrite;
        ClipboardFormat format;
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        if (!global && Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS) {
            dir = new File(dir, actor.getUniqueId().toString());
        }
        if ((format = ClipboardFormats.findByAlias(formatName)) == null) {
            actor.printError(TranslatableComponent.of("worldedit.schematic.unknown-format", TextComponent.of(formatName)));
            return;
        }
        boolean other = false;
        if (filename.contains("../")) {
            other = true;
            if (!actor.hasPermission("worldedit.schematic.save.other")) {
                actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.save.other"));
                return;
            }
            if (filename.startsWith("../")) {
                dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
                filename = filename.substring(3);
            }
        }
        if (overwrite = (f = this.worldEdit.getSafeSaveFile(actor, dir, filename, format.getPrimaryFileExtension(), new String[0])).exists()) {
            if (!actor.hasPermission("worldedit.schematic.delete")) {
                throw new StopExecutionException(TextComponent.of("That schematic already exists!"));
            }
            if (other && !actor.hasPermission("worldedit.schematic.delete.other")) {
                actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.delete.other"));
                return;
            }
            if (!allowOverwrite) {
                actor.printError(TranslatableComponent.of("worldedit.schematic.save.already-exists"));
                return;
            }
        }
        if ((parent = f.getParentFile()) != null && !parent.exists() && !parent.mkdirs()) {
            throw new StopExecutionException(TranslatableComponent.of("worldedit.schematic.save.failed-directory"));
        }
        ClipboardHolder holder = session.getClipboard();
        SchematicSaveTask task = new SchematicSaveTask(actor, f, dir, format, holder, overwrite);
        AsyncCommandBuilder.wrap(task, actor).registerWithSupervisor(this.worldEdit.getSupervisor(), "Saving schematic " + filename).sendMessageAfterDelay(TranslatableComponent.of("worldedit.schematic.save.saving")).onSuccess(filename + " saved" + (overwrite ? " (overwriting previous file)." : "."), null).onFailure("Failed to save schematic", this.worldEdit.getPlatformManager().getPlatformCommandManager().getExceptionConverter()).buildAndExec(this.worldEdit.getExecutorService());
    }

    @Command(name="move", aliases={"m"}, desc="Move your loaded schematic")
    @CommandPermissions(value={"worldedit.schematic.move", "worldedit.schematic.move.other"})
    public void move(Player player, LocalSession session, String directory) throws WorldEditException, IOException {
        File dir;
        File destDir;
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File working = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        if (!MainUtil.isInSubDirectory(working, destDir = new File(dir = Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? new File(working, player.getUniqueId().toString()) : working, directory))) {
            player.printError("Directory " + destDir + " does not exist!");
            return;
        }
        if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && !MainUtil.isInSubDirectory(dir, destDir) && !player.hasPermission("worldedit.schematic.move.other")) {
            player.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.move.other"));
            return;
        }
        ClipboardHolder clipboard = session.getClipboard();
        List<File> sources = this.getFiles(clipboard);
        if (sources.isEmpty()) {
            player.printError(TranslatableComponent.of("fawe.worldedit.schematic.schematic.none"));
            return;
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            player.printError("Creation of " + destDir + " failed! (check file permissions)");
            return;
        }
        for (File source : sources) {
            File destFile = new File(destDir, source.getName());
            if (destFile.exists()) {
                player.print(Caption.of("fawe.worldedit.schematic.schematic.move.exists", destFile));
                continue;
            }
            if (!(!Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS || MainUtil.isInSubDirectory(dir, destFile) && MainUtil.isInSubDirectory(dir, source) || player.hasPermission("worldedit.schematic.delete.other"))) {
                player.print(Caption.of("fawe.worldedit.schematic.schematic.move.failed", destFile, Caption.of("fawe.error.no-perm", "worldedit.schematic.move.other")));
                continue;
            }
            try {
                File cached = new File(source.getParentFile(), "." + source.getName() + ".cached");
                Files.move(source.toPath(), destFile.toPath(), new CopyOption[0]);
                if (cached.exists()) {
                    Files.move(cached.toPath(), destFile.toPath(), new CopyOption[0]);
                }
                player.print(Caption.of("fawe.worldedit.schematic.schematic.move.success", source, destFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<File> getFiles(ClipboardHolder clipboard) {
        Collection<Object> uris = Collections.emptyList();
        if (clipboard instanceof URIClipboardHolder) {
            uris = ((URIClipboardHolder)clipboard).getURIs();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (URI uRI : uris) {
            File file = new File(uRI);
            if (!file.exists()) continue;
            files.add(file);
        }
        return files;
    }

    @Command(name="formats", aliases={"listformats", "f"}, desc="List available formats")
    @CommandPermissions(value={"worldedit.schematic.formats"})
    public void formats(Actor actor) {
        actor.printInfo(TranslatableComponent.of("worldedit.schematic.formats.title"));
        boolean first = true;
        for (ClipboardFormat format : ClipboardFormats.getAll()) {
            StringBuilder builder = new StringBuilder();
            builder.append(format.getName()).append(": ");
            for (String lookupName : format.getAliases()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(lookupName);
                first = false;
            }
            first = true;
            actor.printInfo(TextComponent.of(builder.toString()));
        }
    }

    @Command(name="list", aliases={"all", "ls"}, desc="List saved schematics", descFooter="Note: Format is not fully verified until loading.")
    @CommandPermissions(value={"worldedit.schematic.list"})
    public void list(Actor actor, LocalSession session, @ArgFlag(name=112, desc="Page to view.", def={"1"}) int page, @Switch(name=100, desc="Sort by date, oldest first") boolean oldFirst, @Switch(name=110, desc="Sort by date, newest first") boolean newFirst, @ArgFlag(name=102, desc="Restricts by format.", def={""}) String formatName, @Arg(name="filter", desc="Filter for schematics", def={"all"}) String filter, Arguments arguments) throws WorldEditException {
        if (oldFirst && newFirst) {
            throw new StopExecutionException(TextComponent.of("Cannot sort by oldest and newest."));
        }
        String pageCommand = "/" + arguments.get();
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        String schemCmd = "//schematic";
        String loadSingle = schemCmd + " load";
        String loadMulti = schemCmd + " loadall";
        String unload = schemCmd + " unload";
        String delete = schemCmd + " delete";
        String list = schemCmd + " list";
        String showCmd = schemCmd + " show";
        List<String> args = filter.isEmpty() ? Collections.emptyList() : Arrays.asList(filter.split(" "));
        URIClipboardHolder multi = ReflectionUtils.as(URIClipboardHolder.class, session.getExistingClipboard());
        boolean hasShow = false;
        boolean playerFolder = Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS;
        UUID uuid = playerFolder ? actor.getUniqueId() : null;
        List<File> files = UtilityCommands.getFiles(dir, actor, args, formatName, playerFolder, oldFirst, newFirst);
        List<Map.Entry<URI, String>> entries = UtilityCommands.filesToEntry(dir, files, uuid);
        Function isLoaded = multi == null ? f -> false : multi::contains;
        List<Component> components = UtilityCommands.entryToComponent(dir, entries, (Function<URI, Boolean>)isLoaded, (name, path, type, loaded) -> {
            TextColor color = TextColor.GRAY;
            switch (type) {
                case URL: {
                    color = TextColor.DARK_GRAY;
                    break;
                }
                case FILE: {
                    color = TextColor.GREEN;
                    break;
                }
                case DIRECTORY: {
                    color = TextColor.GOLD;
                }
            }
            TextComponentProducer msg = new TextComponentProducer();
            msg.append(TextComponent.of(" - ", color));
            if (loaded.booleanValue()) {
                msg.append(((TextComponent)TextComponent.of("[-]", TextColor.RED).clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, unload + " " + path))).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of("Unload"))));
            } else {
                msg.append(((TextComponent)TextComponent.of("[+]", TextColor.GREEN).clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, loadMulti + " " + path))).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of("Add to clipboard"))));
            }
            if (type != UtilityCommands.URIType.DIRECTORY) {
                msg.append(((TextComponent)TextComponent.of("[X]", TextColor.DARK_RED).clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, delete + " " + path))).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of("delete"))));
            }
            TextComponent msgElem = TextComponent.of(name, color);
            if (type != UtilityCommands.URIType.DIRECTORY) {
                msgElem = (TextComponent)msgElem.clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, loadSingle + " " + path));
                msgElem = (TextComponent)msgElem.hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of("Load")));
            } else {
                msgElem = (TextComponent)msgElem.clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, list + " " + path));
                msgElem = (TextComponent)msgElem.hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of("List")));
            }
            msg.append(msgElem);
            if (type == UtilityCommands.URIType.FILE) {
                long filesize = 0L;
                try {
                    filesize = Files.size(Paths.get(dir.getAbsolutePath() + File.separator + (playerFolder ? uuid.toString() + File.separator : "") + path, new String[0]));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                TextComponent sizeElem = TextComponent.of(String.format(" (%.1f kb)", (double)filesize / 1000.0), TextColor.GRAY);
                msg.append(sizeElem);
            }
            return msg.create();
        });
        long totalBytes = 0L;
        File parentDir = new File(dir.getAbsolutePath() + (playerFolder ? File.separator + uuid.toString() : ""));
        try {
            List<File> toAddUp = SchematicCommands.getFiles(parentDir, null, null);
            if (toAddUp != null && toAddUp.size() != 0) {
                for (File schem : toAddUp) {
                    if (!schem.getName().endsWith(".schem") && !schem.getName().endsWith(".schematic")) continue;
                    totalBytes += Files.size(Paths.get(schem.getAbsolutePath(), new String[0]));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String headerBytesElem = String.format("%.1fkb", (double)totalBytes / 1000.0);
        if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && Settings.IMP.EXPERIMENTAL.PER_PLAYER_FILE_SIZE_LIMIT > -1) {
            headerBytesElem = headerBytesElem + String.format(" / %dkb", Settings.IMP.EXPERIMENTAL.PER_PLAYER_FILE_SIZE_LIMIT);
        }
        String fullHeader = "| Schematics: " + headerBytesElem + " |";
        PaginationBox paginationBox = PaginationBox.fromComponents(fullHeader, pageCommand, components);
        actor.print(paginationBox.create(page));
    }

    @Command(name="delete", aliases={"d"}, desc="Delete a saved schematic")
    @CommandPermissions(value={"worldedit.schematic.delete"})
    public void delete(Actor actor, LocalSession session, @Arg(desc="File name.") String filename) throws WorldEditException, IOException {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File working = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        File dir = Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? new File(working, actor.getUniqueId().toString()) : working;
        ArrayList<File> files = new ArrayList<File>();
        if (filename.equalsIgnoreCase("*")) {
            files.addAll(this.getFiles(session.getClipboard()));
        } else {
            File f = MainUtil.resolveRelative(new File(dir, filename));
            files.add(f);
        }
        if (files.isEmpty()) {
            actor.printError(TranslatableComponent.of("worldedit.schematic.delete.does-not-exist", TextComponent.of(filename)));
            return;
        }
        for (File f : files) {
            if (!MainUtil.isInSubDirectory(working, f) || !f.exists()) {
                actor.printError(TranslatableComponent.of("worldedit.schematic.delete.does-not-exist", TextComponent.of(filename)));
                continue;
            }
            if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && !MainUtil.isInSubDirectory(dir, f) && !actor.hasPermission("worldedit.schematic.delete.other")) {
                actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.delete.other"));
                continue;
            }
            if (!this.deleteFile(f)) {
                actor.printError(TranslatableComponent.of("worldedit.schematic.delete.failed", TextComponent.of(filename)));
                continue;
            }
            actor.print(Caption.of("worldedit.schematic.delete.deleted", filename));
        }
    }

    private boolean deleteFile(File file) {
        if (file.delete()) {
            new File(file.getParentFile(), "." + file.getName() + ".cached").delete();
            return true;
        }
        return false;
    }

    private static class SchematicPaginationBox
    extends PaginationBox {
        private final String prefix;
        private final File[] files;

        SchematicPaginationBox(String rootDir, File[] files, String pageCommand) {
            super("Available schematics", pageCommand);
            this.prefix = rootDir == null ? "" : rootDir;
            this.files = files;
        }

        @Override
        public Component getComponent(int number) {
            Preconditions.checkArgument((number < this.files.length && number >= 0 ? 1 : 0) != 0);
            File file = this.files[number];
            Multimap<String, ClipboardFormat> exts = ClipboardFormats.getFileExtensionMap();
            String format = exts.get((Object)com.google.common.io.Files.getFileExtension((String)file.getName())).stream().findFirst().map(ClipboardFormat::getName).orElse("Unknown");
            boolean inRoot = file.getParentFile().getName().equals(this.prefix);
            String path = inRoot ? file.getName() : file.getPath().split(Pattern.quote(this.prefix + File.separator))[1];
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().content("").append(((TextComponent)((TextComponent)TextComponent.of("[L]").color(TextColor.GOLD)).clickEvent(ClickEvent.of(ClickEvent.Action.RUN_COMMAND, "/schem load \"" + path + "\""))).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of("Click to load"))))).append((Component)TextComponent.space())).append(((TextComponent)TextComponent.of(path).color(TextColor.DARK_GREEN)).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of(format))))).build();
        }

        @Override
        public int getComponentsSize() {
            return this.files.length;
        }
    }

    private static class SchematicListTask
    implements Callable<Component> {
        private final String prefix;
        private final int sortType;
        private final int page;
        private final File rootDir;
        private final String pageCommand;
        private final String filter;
        private final String formatName;

        SchematicListTask(String prefix, int sortType, int page, String pageCommand, String filter, String formatName) {
            this.prefix = prefix;
            this.sortType = sortType;
            this.page = page;
            this.rootDir = WorldEdit.getInstance().getWorkingDirectoryFile(prefix);
            this.pageCommand = pageCommand;
            this.filter = filter;
            this.formatName = formatName;
        }

        @Override
        public Component call() throws Exception {
            ClipboardFormat format = ClipboardFormats.findByAlias(this.formatName);
            List fileList = SchematicCommands.getFiles(this.rootDir, this.filter, format);
            if (fileList == null || fileList.isEmpty()) {
                return ErrorFormat.wrap("No schematics found.");
            }
            File[] files = new File[fileList.size()];
            fileList.toArray(files);
            Arrays.sort(files, (f1, f2) -> {
                int res;
                if (this.sortType == 0) {
                    int p = f1.getParent().compareTo(f2.getParent());
                    res = p == 0 ? f1.getName().compareTo(f2.getName()) : p;
                } else {
                    res = Long.compare(f1.lastModified(), f2.lastModified());
                    if (this.sortType == 1) {
                        res = -res;
                    }
                }
                return res;
            });
            SchematicPaginationBox paginationBox = new SchematicPaginationBox(this.prefix, files, this.pageCommand);
            return paginationBox.create(this.page);
        }
    }

    private static class SchematicSaveTask
    implements Callable<Void> {
        private final Actor actor;
        private final ClipboardFormat format;
        private final ClipboardHolder holder;
        private final boolean overwrite;
        private final File rootDir;
        private File file;

        SchematicSaveTask(Actor actor, File file, File rootDir, ClipboardFormat format, ClipboardHolder holder, boolean overwrite) {
            this.actor = actor;
            this.file = file;
            this.rootDir = rootDir;
            this.format = format;
            this.holder = holder;
            this.overwrite = overwrite;
        }

        @Override
        public Void call() throws Exception {
            Clipboard target;
            List toAddUp;
            Clipboard clipboard = this.holder.getClipboard();
            Transform transform = this.holder.getTransform();
            boolean checkFilesize = false;
            if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && Settings.IMP.EXPERIMENTAL.PER_PLAYER_FILE_SIZE_LIMIT > -1) {
                checkFilesize = true;
            }
            double directorysizeKb = 0.0;
            String curFilepath = this.file.getAbsolutePath();
            String SCHEMATIC_NAME = this.file.getName();
            double oldKbOverwritten = 0.0;
            String overwrittenPath = curFilepath;
            int numFiles = -1;
            if (checkFilesize) {
                toAddUp = SchematicCommands.getFiles(this.rootDir, null, null);
                if (toAddUp != null && toAddUp.size() != 0) {
                    for (File child : toAddUp) {
                        if (!child.getName().endsWith(".schem") && !child.getName().endsWith(".schematic")) continue;
                        directorysizeKb += (double)Files.size(Paths.get(child.getAbsolutePath(), new String[0])) / 1000.0;
                        ++numFiles;
                    }
                }
                if (this.overwrite) {
                    oldKbOverwritten = (double)Files.size(Paths.get(this.file.getAbsolutePath(), new String[0])) / 1000.0;
                    int iter = 1;
                    while (new File(overwrittenPath + "." + iter + "." + this.format.getPrimaryFileExtension()).exists()) {
                        ++iter;
                    }
                    this.file = new File(overwrittenPath + "." + iter + "." + this.format.getPrimaryFileExtension());
                }
            }
            if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && Settings.IMP.EXPERIMENTAL.PER_PLAYER_FILE_NUM_LIMIT > -1) {
                int limit;
                if (numFiles == -1) {
                    numFiles = 0;
                    toAddUp = SchematicCommands.getFiles(this.rootDir, null, null);
                    if (toAddUp != null && toAddUp.size() != 0) {
                        for (File child : toAddUp) {
                            if (!child.getName().endsWith(".schem") && !child.getName().endsWith(".schematic")) continue;
                            ++numFiles;
                        }
                    }
                }
                if (numFiles >= (limit = Settings.IMP.EXPERIMENTAL.PER_PLAYER_FILE_NUM_LIMIT)) {
                    TextComponent noSlotsErr = TextComponent.of(String.format("You have " + numFiles + "/" + limit + " saved schematics. Delete some to save this one!", TextColor.RED));
                    log.info(this.actor.getName() + " failed to save " + this.file.getCanonicalPath() + " - too many schematics!");
                    throw new WorldEditException(noSlotsErr){};
                }
            }
            if (transform.isIdentity()) {
                target = clipboard;
            } else {
                FlattenedClipboardTransform result = FlattenedClipboardTransform.transform(clipboard, transform);
                target = new BlockArrayClipboard(result.getTransformedRegion());
                target.setOrigin(clipboard.getOrigin());
                Operations.completeLegacy(result.copyTo(target));
            }
            Closer closer = Closer.create();
            Object object = null;
            try {
                FileOutputStream fos = closer.register(new FileOutputStream(this.file));
                BufferedOutputStream bos = closer.register(new BufferedOutputStream(fos));
                ClipboardWriter writer = closer.register(this.format.getWriter(bos));
                URI uri = null;
                if (this.holder instanceof URIClipboardHolder) {
                    uri = ((URIClipboardHolder)this.holder).getURI(clipboard);
                }
                if (new ActorSaveClipboardEvent(this.actor, clipboard, uri, this.file.toURI()).call()) {
                    if (writer instanceof MinecraftStructure) {
                        ((MinecraftStructure)writer).write(target, this.actor.getName());
                    } else {
                        writer.write(target);
                    }
                    closer.close();
                    double filesizeKb = (double)Files.size(Paths.get(this.file.getAbsolutePath(), new String[0])) / 1000.0;
                    TextComponent filesizeNotif = TextComponent.of(SCHEMATIC_NAME + " size: " + String.format("%.1f", filesizeKb) + "kb", TextColor.GRAY);
                    this.actor.print(filesizeNotif);
                    if (checkFilesize) {
                        double curKb = filesizeKb + directorysizeKb;
                        int allocatedKb = Settings.IMP.EXPERIMENTAL.PER_PLAYER_FILE_SIZE_LIMIT;
                        if (this.overwrite) {
                            curKb -= oldKbOverwritten;
                        }
                        if (curKb > (double)allocatedKb) {
                            this.file.delete();
                            TextComponent notEnoughKbErr = TextComponent.of("You're about to be at " + String.format("%.1f", curKb) + "kb of schematics. (" + String.format("%dkb", allocatedKb) + " available) Delete some first to save this one!", TextColor.RED);
                            log.info(this.actor.getName() + " failed to save " + SCHEMATIC_NAME + " - not enough space!");
                            throw new WorldEditException(notEnoughKbErr){};
                        }
                        if (this.overwrite) {
                            new File(curFilepath).delete();
                            this.file.renameTo(new File(curFilepath));
                        } else {
                            ++numFiles;
                        }
                        TextComponent kbRemainingNotif = TextComponent.of("You have " + String.format("%.1f", (double)allocatedKb - curKb) + "kb left for schematics.", TextColor.GRAY);
                        this.actor.print(kbRemainingNotif);
                    }
                    if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && Settings.IMP.EXPERIMENTAL.PER_PLAYER_FILE_NUM_LIMIT > -1) {
                        TextComponent slotsRemainingNotif = TextComponent.of("You have " + (Settings.IMP.EXPERIMENTAL.PER_PLAYER_FILE_NUM_LIMIT - numFiles) + " schematic file slots left.", TextColor.GRAY);
                        this.actor.print(slotsRemainingNotif);
                    }
                    log.info(this.actor.getName() + " saved " + this.file.getCanonicalPath());
                } else {
                    this.actor.printError(TranslatableComponent.of("fawe.cancel.worldedit.cancel.reason.manual"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (closer != null) {
                    if (object != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
            return null;
        }
    }

    private static class SchematicLoadTask
    implements Callable<ClipboardHolder> {
        private final Actor actor;
        private final ClipboardFormat format;
        private final File file;

        SchematicLoadTask(Actor actor, File file, ClipboardFormat format) {
            this.actor = actor;
            this.file = file;
            this.format = format;
        }

        @Override
        public ClipboardHolder call() throws Exception {
            try (Closer closer = Closer.create();){
                FileInputStream fis = closer.register(new FileInputStream(this.file));
                BufferedInputStream bis = closer.register(new BufferedInputStream(fis));
                ClipboardReader reader = closer.register(this.format.getReader(bis));
                Clipboard clipboard = reader.read();
                log.info(this.actor.getName() + " loaded " + this.file.getCanonicalPath());
                ClipboardHolder clipboardHolder = new ClipboardHolder(clipboard);
                return clipboardHolder;
            }
        }
    }
}

