/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Caption;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.DelegateConsumer;
import com.boydti.fawe.object.function.QuadFunction;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.image.ImageUtil;
import com.google.common.base.Function;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.CreatureButcher;
import com.sk89q.worldedit.command.util.EntityRemover;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.command.util.PrintCommandHelp;
import com.sk89q.worldedit.command.util.WorldEditAsyncCommandBuilder;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.function.EntityFunction;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.EntityVisitor;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.internal.annotation.VertHeight;
import com.sk89q.worldedit.internal.expression.EvaluationException;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.formatting.component.SubtleFormat;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;
import org.enginehub.piston.exception.StopExecutionException;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class UtilityCommands {
    private final WorldEdit we;

    public UtilityCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(name="/macro", desc="Generate or run a macro")
    @CommandPermissions(value={"worldedit.macro"})
    public void macro(Player player, LocalSession session, String name, String argument) throws IOException {
    }

    @Command(name="/heightmapinterface", aliases={"/hmi", "hmi"}, desc="Generate the heightmap interface: https://github.com/boy0001/HeightMap")
    @CommandPermissions(value={"fawe.admin"})
    public void heightmapInterface(Player player, @Arg(name="min", desc="int", def={"100"}) int min, @Arg(name="max", desc="int", def={"200"}) int max) throws IOException {
        player.print(TextComponent.of("Please wait while we generate the minified heightmaps."));
        File srcFolder = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HEIGHTMAP);
        File webSrc = new File(Fawe.imp().getDirectory(), "web" + File.separator + "heightmap");
        File minImages = new File(webSrc, "images" + File.separator + "min");
        File maxImages = new File(webSrc, "images" + File.separator + "max");
        int sub = srcFolder.getAbsolutePath().length();
        ArrayList images = new ArrayList();
        MainUtil.iterateFiles(srcFolder, file -> {
            switch (file.getName().substring(file.getName().lastIndexOf(46)).toLowerCase(Locale.ROOT)) {
                case ".png": 
                case ".jpeg": {
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                String name = file.getAbsolutePath().substring(sub);
                if (name.startsWith(File.separator)) {
                    name = name.replaceFirst(Pattern.quote(File.separator), "");
                }
                BufferedImage img = MainUtil.readImage(file);
                BufferedImage minImg = ImageUtil.getScaledInstance(img, min, min, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                BufferedImage maxImg = max == -1 ? img : ImageUtil.getScaledInstance(img, max, max, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                player.print(TextComponent.of(String.format("Writing %s", name)));
                File minFile = new File(minImages, name);
                File maxFile = new File(maxImages, name);
                minFile.getParentFile().mkdirs();
                maxFile.getParentFile().mkdirs();
                ImageIO.write((RenderedImage)minImg, "png", minFile);
                ImageIO.write((RenderedImage)maxImg, "png", maxFile);
                images.add(name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        StringBuilder config = new StringBuilder();
        config.append("var images = [\n");
        for (String image : images) {
            config.append('\"' + image.replace(File.separator, "/") + "\",\n");
        }
        config.append("];\n");
        config.append("// The low res images (they should all be the same size)\n");
        config.append("var src_min = \"images/min/\";\n");
        config.append("// The max resolution images (Use the same if there are no higher resolution ones available)\n");
        config.append("var src_max = \"images/max/\";\n");
        config.append("// The local source for the image (used in commands)\n");
        config.append("var src_local = \"file://\";\n");
        File configFile = new File(webSrc, "config.js");
        player.print(TextComponent.of(String.format("Writing %s", configFile)));
        Files.write(configFile.toPath(), config.toString().getBytes(), new OpenOption[0]);
        player.print(TextComponent.of("Done! See: `FastAsyncWorldEdit/web/heightmap`"));
    }

    @Command(name="/cancel", aliases={"fcancel"}, desc="Cancel your current command")
    @CommandPermissions(value={"fawe.cancel"}, queued=false)
    public void cancel(Player player) {
        int cancelled = player.cancel(false);
        player.print(Caption.of("fawe.cancel.worldedit.cancel.count", cancelled));
    }

    @Command(name="/fill", desc="Fill a hole")
    @CommandPermissions(value={"worldedit.fill"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int fill(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The blocks to fill with") com.sk89q.worldedit.function.pattern.Pattern pattern, @Arg(desc="The radius to fill in") Expression radiusExp, @Arg(desc="The depth to fill", def={"1"}) int depth, @Direction @Arg(desc="The direction to move", def={"down"}) BlockVector3 direction) throws WorldEditException, EvaluationException {
        double radius = radiusExp.evaluate(new double[0]);
        radius = Math.max(1.0, radius);
        this.we.checkMaxRadius(radius);
        depth = Math.max(1, depth);
        BlockVector3 pos = session.getPlacementPosition(actor);
        int affected = editSession.fillDirection(pos, pattern, radius, depth, direction);
        actor.printInfo(TranslatableComponent.of("worldedit.fill.created", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/fillr", desc="Fill a hole recursively")
    @CommandPermissions(value={"worldedit.fill.recursive"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int fillr(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The blocks to fill with") com.sk89q.worldedit.function.pattern.Pattern pattern, @Arg(desc="The radius to fill in") Expression radiusExp, @Arg(desc="The depth to fill", def={""}) Integer depth) throws WorldEditException {
        double radius = radiusExp.evaluate(new double[0]);
        radius = Math.max(1.0, radius);
        this.we.checkMaxRadius(radius);
        depth = depth == null ? Integer.MAX_VALUE : Math.max(1, depth);
        this.we.checkMaxRadius(radius);
        BlockVector3 pos = session.getPlacementPosition(actor);
        int affected = editSession.fillXZ(pos, pattern, radius, (int)depth, true);
        actor.printInfo(TranslatableComponent.of("worldedit.fillr.created", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="/drain", desc="Drain a pool")
    @CommandPermissions(value={"worldedit.drain"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int drain(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The radius to drain") Expression radiusExp, @Switch(name=119, desc="Also un-waterlog blocks") boolean waterlogged, @Switch(name=112, desc="Also remove water plants") boolean plants) throws WorldEditException {
        double radius = radiusExp.evaluate(new double[0]);
        radius = Math.max(0.0, radius);
        this.we.checkMaxRadius(radius);
        int affected = editSession.drainArea(session.getPlacementPosition(actor), radius, waterlogged, plants);
        actor.printInfo(TranslatableComponent.of("worldedit.drain.drained", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="fixlava", aliases={"/fixlava"}, desc="Fix lava to be stationary")
    @CommandPermissions(value={"worldedit.fixlava"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int fixLava(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The radius to fix in") double radius) throws WorldEditException {
        radius = Math.max(0.0, radius);
        this.we.checkMaxRadius(radius);
        int affected = editSession.fixLiquid(session.getPlacementPosition(actor), radius, BlockTypes.LAVA);
        actor.printInfo(TranslatableComponent.of("worldedit.fixlava.fixed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="fixwater", aliases={"/fixwater"}, desc="Fix water to be stationary")
    @CommandPermissions(value={"worldedit.fixwater"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int fixWater(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The radius to fix in") double radius) throws WorldEditException {
        radius = Math.max(0.0, radius);
        this.we.checkMaxRadius(radius);
        int affected = editSession.fixLiquid(session.getPlacementPosition(actor), radius, BlockTypes.WATER);
        actor.printInfo(TranslatableComponent.of("worldedit.fixwater.fixed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="removeabove", aliases={"/removeabove"}, desc="Remove blocks above your head.")
    @CommandPermissions(value={"worldedit.removeabove"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int removeAbove(Actor actor, World world, LocalSession session, EditSession editSession, @Arg(desc="The apothem of the square to remove from", def={"1"}) int size, @Arg(desc="The maximum height above you to remove from", def={""}) Integer height) throws WorldEditException {
        size = Math.max(1, size);
        this.we.checkMaxRadius(size);
        height = height != null ? Math.min(world.getMaxY() + 1, height + 1) : world.getMaxY() + 1;
        int affected = editSession.removeAbove(session.getPlacementPosition(actor), size, height);
        actor.printInfo(TranslatableComponent.of("worldedit.removeabove.removed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="removebelow", aliases={"/removebelow"}, desc="Remove blocks below you.")
    @CommandPermissions(value={"worldedit.removebelow"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int removeBelow(Actor actor, World world, LocalSession session, EditSession editSession, @Arg(desc="The apothem of the square to remove from", def={"1"}) int size, @Arg(desc="The maximum height below you to remove from", def={""}) Integer height) throws WorldEditException {
        size = Math.max(1, size);
        this.we.checkMaxRadius(size);
        height = height != null ? Math.min(world.getMaxY() + 1, height + 1) : world.getMaxY() + 1;
        int affected = editSession.removeBelow(session.getPlacementPosition(actor), size, height);
        actor.printInfo(TranslatableComponent.of("worldedit.removebelow.removed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="removenear", aliases={"/removenear"}, desc="Remove blocks near you.")
    @CommandPermissions(value={"worldedit.removenear"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int removeNear(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The mask of blocks to remove") Mask mask, @Arg(desc="The radius of the square to remove from", def={"50"}) int radius) throws WorldEditException {
        radius = Math.max(1, radius);
        this.we.checkMaxRadius(radius);
        int affected = editSession.removeNear(session.getPlacementPosition(actor), mask, radius);
        actor.printInfo(TranslatableComponent.of("worldedit.removenear.removed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="replacenear", aliases={"/replacenear"}, desc="Replace nearby blocks")
    @CommandPermissions(value={"worldedit.replacenear"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int replaceNear(Actor actor, World world, LocalSession session, EditSession editSession, @Arg(desc="The radius of the square to remove in") int radius, @Arg(desc="The mask matching blocks to remove", def={""}) Mask from, @Arg(desc="The pattern of blocks to replace with") com.sk89q.worldedit.function.pattern.Pattern to) throws WorldEditException {
        radius = Math.max(1, radius);
        this.we.checkMaxRadius(radius);
        BlockVector3 base = session.getPlacementPosition(actor);
        BlockVector3 min = base.subtract(radius, radius, radius);
        BlockVector3 max = base.add(radius, radius, radius);
        CuboidRegion region = new CuboidRegion(world, min, max);
        if (from == null) {
            from = new ExistingBlockMask(editSession);
        }
        int affected = editSession.replaceBlocks((Region)region, from, to);
        actor.printInfo(TranslatableComponent.of("worldedit.replacenear.replaced", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="snow", aliases={"/snow"}, desc="Simulates snow")
    @CommandPermissions(value={"worldedit.snow"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int snow(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The radius of the cylinder to snow in", def={"10"}) double size, @VertHeight @Arg(desc="The height of the cylinder to snow in", def={"default-vertical-height"}) int height, @Switch(name=115, desc="Stack snow layers") boolean stack) throws WorldEditException {
        size = Math.max(1.0, size);
        height = Math.max(1, height);
        this.we.checkMaxRadius(size);
        BlockVector3 position = session.getPlacementPosition(actor);
        CylinderRegion region = new CylinderRegion(position, Vector2.at(size, size), position.getBlockY() - height, position.getBlockY() + height);
        int affected = editSession.simulateSnow(region, stack);
        actor.printInfo(TranslatableComponent.of("worldedit.snow.created", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="thaw", aliases={"/thaw"}, desc="Thaws the area")
    @CommandPermissions(value={"worldedit.thaw"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int thaw(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The radius of the cylinder to thaw in", def={"10"}) double size, @VertHeight @Arg(desc="The height of the cylinder to thaw in", def={"default-vertical-height"}) int height) throws WorldEditException {
        size = Math.max(1.0, size);
        height = Math.max(1, height);
        this.we.checkMaxRadius(size);
        int affected = editSession.thaw(session.getPlacementPosition(actor), size, height);
        actor.printInfo(TranslatableComponent.of("worldedit.thaw.removed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="green", aliases={"/green"}, desc="Converts dirt to grass blocks in the area")
    @CommandPermissions(value={"worldedit.green"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int green(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The radius of the cylinder to convert in", def={"10"}) double size, @VertHeight @Arg(desc="The height of the cylinder to convert in", def={"default-vertical-height"}) int height, @Switch(name=102, desc="Also convert coarse dirt") boolean convertCoarse) throws WorldEditException {
        size = Math.max(1.0, size);
        height = Math.max(1, height);
        this.we.checkMaxRadius(size);
        boolean onlyNormalDirt = !convertCoarse;
        int affected = editSession.green(session.getPlacementPosition(actor), size, height, onlyNormalDirt);
        actor.printInfo(TranslatableComponent.of("worldedit.green.changed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="extinguish", aliases={"/ex", "/ext", "/extinguish", "ex", "ext"}, desc="Extinguish nearby fire")
    @CommandPermissions(value={"worldedit.extinguish"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int extinguish(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The radius of the square to remove in", def={""}) Integer radius) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        int defaultRadius = config.maxRadius != -1 ? Math.min(40, config.maxRadius) : 40;
        int size = radius != null ? Math.max(1, radius) : defaultRadius;
        this.we.checkMaxRadius(size);
        BlockTypeMask mask = new BlockTypeMask((Extent)editSession, BlockTypes.FIRE);
        int affected = editSession.removeNear(session.getPlacementPosition(actor), mask, size);
        actor.printInfo(TranslatableComponent.of("worldedit.extinguish.removed", TextComponent.of(affected)));
        return affected;
    }

    @Command(name="butcher", aliases={"/butcher"}, desc="Kill all or nearby mobs")
    @CommandPermissions(value={"worldedit.butcher"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int butcher(Actor actor, @Arg(desc="Radius to kill mobs in", def={""}) Integer radius, @Switch(name=112, desc="Also kill pets") boolean killPets, @Switch(name=110, desc="Also kill NPCs") boolean killNpcs, @Switch(name=103, desc="Also kill golems") boolean killGolems, @Switch(name=97, desc="Also kill animals") boolean killAnimals, @Switch(name=98, desc="Also kill ambient mobs") boolean killAmbient, @Switch(name=116, desc="Also kill mobs with name tags") boolean killWithName, @Switch(name=102, desc="Also kill all friendly mobs (Applies the flags `-abgnpt`)") boolean killFriendly, @Switch(name=114, desc="Also destroy armor stands") boolean killArmorStands, @Switch(name=119, desc="Also kill water mobs") boolean killWater) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (radius == null) {
            radius = config.butcherDefaultRadius;
        } else {
            if (radius < -1) {
                actor.printError(TranslatableComponent.of("worldedit.butcher.explain-all"));
                return 0;
            }
            if (radius == -1 && config.butcherMaxRadius != -1) {
                radius = config.butcherMaxRadius;
            }
        }
        if (config.butcherMaxRadius != -1) {
            radius = Math.min(radius, config.butcherMaxRadius);
        }
        CreatureButcher flags = new CreatureButcher(actor);
        flags.or(191, killFriendly);
        flags.or(1, killPets, "worldedit.butcher.pets");
        flags.or(2, killNpcs, "worldedit.butcher.npcs");
        flags.or(8, killGolems, "worldedit.butcher.golems");
        flags.or(4, killAnimals, "worldedit.butcher.animals");
        flags.or(16, killAmbient, "worldedit.butcher.ambient");
        flags.or(32, killWithName, "worldedit.butcher.tagged");
        flags.or(64, killArmorStands, "worldedit.butcher.armorstands");
        flags.or(128, killWater, "worldedit.butcher.water");
        int killed = this.killMatchingEntities(radius, actor, flags::createFunction);
        actor.printInfo(TranslatableComponent.of("worldedit.butcher.killed", TextComponent.of(killed), TextComponent.of(radius)));
        return killed;
    }

    @Command(name="remove", aliases={"rem", "rement", "/remove", "/rem", "/rement"}, desc="Remove all entities of a type")
    @CommandPermissions(value={"worldedit.remove"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int remove(Actor actor, @Arg(desc="The type of entity to remove") EntityRemover remover, @Arg(desc="The radius of the cuboid to remove from") int radius) throws WorldEditException {
        if (radius < -1) {
            actor.printError(TranslatableComponent.of("worldedit.remove.explain-all"));
            return 0;
        }
        int removed = this.killMatchingEntities(radius, actor, remover::createFunction);
        actor.printInfo(TranslatableComponent.of("worldedit.remove.removed", TextComponent.of(removed)));
        return removed;
    }

    private int killMatchingEntities(Integer radius, Actor actor, Supplier<EntityFunction> func) throws IncompleteRegionException, MaxChangedBlocksException {
        List<? extends Entity> entities;
        ArrayList<EntityVisitor> visitors = new ArrayList<EntityVisitor>();
        LocalSession session = this.we.getSessionManager().get(actor);
        BlockVector3 center = session.getPlacementPosition(actor);
        EditSession editSession = session.createEditSession(actor);
        if (radius >= 0) {
            CylinderRegion region = CylinderRegion.createRadius(editSession, center, radius.intValue());
            entities = editSession.getEntities(region);
        } else {
            entities = editSession.getEntities();
        }
        visitors.add(new EntityVisitor(entities.iterator(), func.get()));
        int killed = 0;
        for (EntityVisitor visitor : visitors) {
            Operations.completeLegacy(visitor);
            killed += visitor.getAffected();
        }
        session.remember(editSession);
        editSession.flushSession();
        return killed;
    }

    private DecimalFormat formatForLocale(Locale locale) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(locale);
        format.applyPattern("#,##0.#####");
        return format;
    }

    @Command(name="/calculate", aliases={"/calc", "/eval", "/evaluate", "/solve"}, desc="Evaluate a mathematical expression")
    @CommandPermissions(value={"worldedit.calc"})
    public void calc(Actor actor, @Arg(desc="Expression to evaluate", variable=true) List<String> input) {
        Expression expression;
        try {
            expression = Expression.compile(String.join((CharSequence)" ", input), new String[0]);
        }
        catch (ExpressionException e) {
            actor.printError(TranslatableComponent.of("worldedit.calc.invalid.with-error", TextComponent.of(String.join((CharSequence)" ", input)), TextComponent.of(e.getMessage())));
            return;
        }
        WorldEditAsyncCommandBuilder.createAndSendMessage(actor, () -> {
            double result = expression.evaluate(new double[0], WorldEdit.getInstance().getSessionManager().get(actor).getTimeout());
            String formatted = Double.isNaN(result) ? "NaN" : this.formatForLocale(actor.getLocale()).format(result);
            return SubtleFormat.wrap(input + " = ").append(TextComponent.of(formatted, TextColor.LIGHT_PURPLE));
        }, (Component)null);
    }

    @Command(name="/help", desc="Displays help for WorldEdit commands")
    @CommandPermissions(value={"worldedit.help"})
    public void help(Actor actor, @Switch(name=115, desc="List sub-commands of the given command, if applicable") boolean listSubCommands, @ArgFlag(name=112, desc="The page to retrieve", def={"1"}) int page, @Arg(desc="The command to retrieve help for", def={""}, variable=true) List<String> command) throws WorldEditException {
        PrintCommandHelp.help(command, page, listSubCommands, this.we.getPlatformManager().getPlatformCommandManager().getCommandManager(), actor, "//help");
    }

    @Command(name="/confirm", desc="Confirm a command")
    @CommandPermissions(value={"fawe.confirm"}, queued=false)
    public void confirm(Player player) throws WorldEditException {
        if (!player.confirm()) {
            player.print(TranslatableComponent.of("fawe.worldedit.utility.nothing.confirmed"));
        }
    }

    public static List<Map.Entry<URI, String>> filesToEntry(File root, List<File> files, UUID uuid) {
        return files.stream().map(input -> {
            URI uri = input.toURI();
            String path = UtilityCommands.getPath(root, input, uuid);
            return new AbstractMap.SimpleEntry<URI, String>(uri, path);
        }).collect(Collectors.toList());
    }

    public static List<Component> entryToComponent(File root, List<Map.Entry<URI, String>> entries, Function<URI, Boolean> isLoaded, QuadFunction<String, String, URIType, Boolean, Component> adapter) {
        return entries.stream().map(input -> {
            URI uri = (URI)input.getKey();
            String path = (String)input.getValue();
            boolean url = false;
            boolean loaded = (Boolean)isLoaded.apply((Object)uri);
            URIType type = URIType.FILE;
            String name = path;
            String uriStr = uri.toString();
            if (uriStr.startsWith("file:/")) {
                File file = new File(uri.getPath());
                name = file.getName();
                if (file.isDirectory()) {
                    type = URIType.DIRECTORY;
                } else if (name.indexOf(46) != -1) {
                    name = name.substring(0, name.lastIndexOf(46));
                }
                try {
                    if (!MainUtil.isInSubDirectory(root, file)) {
                        throw new RuntimeException(new StopExecutionException(TextComponent.of("Invalid path")));
                    }
                }
                catch (IOException iOException) {}
            } else {
                type = uriStr.startsWith("http://") || uriStr.startsWith("https://") ? URIType.URL : URIType.OTHER;
            }
            return (Component)adapter.apply(name, path, type, loaded);
        }).collect(Collectors.toList());
    }

    public static List<File> getFiles(File dir, Actor actor, List<String> args, String formatName, boolean playerFolder, boolean oldFirst, boolean newFirst) {
        LinkedList<File> fileList = new LinkedList<File>();
        UtilityCommands.getFiles(dir, actor, args, formatName, playerFolder, fileList::add);
        if (fileList.isEmpty()) {
            actor.print(TranslatableComponent.of("fawe.worldedit.schematic.schematic.none"));
            return Collections.emptyList();
        }
        int sortType = oldFirst ? -1 : (newFirst ? 1 : 0);
        fileList.sort((f1, f2) -> {
            int res;
            boolean dir2;
            boolean dir1 = f1.isDirectory();
            if (dir1 != (dir2 = f2.isDirectory())) {
                return dir1 ? -1 : 1;
            }
            if (sortType == 0) {
                int p = f1.getParent().compareTo(f2.getParent());
                res = p == 0 ? f1.getName().compareTo(f2.getName()) : p;
            } else {
                res = Long.compare(f1.lastModified(), f2.lastModified());
                if (sortType == 1) {
                    res = -res;
                }
            }
            return res;
        });
        return fileList;
    }

    public static void getFiles(File dir, Actor actor, List<String> args, String formatName, boolean playerFolder, Consumer<File> forEachFile) {
        File rel;
        boolean listGlobal;
        DelegateConsumer<File> rootFunction = forEachFile;
        int len = args.size();
        ArrayList<String> filters = new ArrayList<String>();
        String dirFilter = File.separator;
        boolean listMine = false;
        boolean bl = listGlobal = !Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS;
        if (len > 0) {
            block14: for (String arg : args) {
                switch (arg.toLowerCase(Locale.ROOT)) {
                    case "me": 
                    case "mine": 
                    case "local": 
                    case "private": {
                        listMine = true;
                        continue block14;
                    }
                    case "public": 
                    case "global": {
                        listGlobal = true;
                        continue block14;
                    }
                    case "all": {
                        listMine = true;
                        listGlobal = true;
                        continue block14;
                    }
                }
                if (arg.endsWith("/") || arg.endsWith(File.separator)) {
                    UUID fromName;
                    boolean exists;
                    arg = arg.replace("/", File.separator);
                    String newDirFilter = dirFilter + arg;
                    boolean bl2 = exists = new File(dir, newDirFilter).exists() || playerFolder && MainUtil.resolveRelative(new File(dir, actor.getUniqueId() + newDirFilter)).exists();
                    if (!exists && (arg = arg.substring(0, arg.length() - File.separator.length())).length() > 3 && arg.length() <= 16 && (fromName = Fawe.imp().getUUID(arg)) != null) {
                        newDirFilter = dirFilter + fromName + File.separator;
                        listGlobal = true;
                    }
                    dirFilter = newDirFilter;
                    continue;
                }
                filters.add(arg);
            }
        }
        if (!listMine && !listGlobal) {
            listMine = true;
        }
        final ArrayList<File> toFilter = new ArrayList<File>();
        if (!filters.isEmpty()) {
            forEachFile = new DelegateConsumer<File>(forEachFile){

                @Override
                public void accept(File file) {
                    toFilter.add(file);
                }
            };
        }
        if (formatName != null) {
            final ClipboardFormat cf = ClipboardFormats.findByAlias(formatName);
            forEachFile = new DelegateConsumer<File>((Consumer)forEachFile){

                @Override
                public void accept(File file) {
                    if (cf.isFormat(file)) {
                        super.accept(file);
                    }
                }
            };
        } else {
            forEachFile = new DelegateConsumer<File>((Consumer)forEachFile){

                @Override
                public void accept(File file) {
                    if (!file.toString().endsWith(".cached")) {
                        super.accept(file);
                    }
                }
            };
        }
        if (playerFolder) {
            File playerDir;
            if (listMine && (playerDir = MainUtil.resolveRelative(new File(dir, actor.getUniqueId() + dirFilter))).exists()) {
                UtilityCommands.allFiles(playerDir.listFiles(), false, (Consumer<File>)forEachFile);
            }
            if (listGlobal) {
                rel = MainUtil.resolveRelative(new File(dir, dirFilter));
                forEachFile = new DelegateConsumer<File>((Consumer)forEachFile){

                    @Override
                    public void accept(File f) {
                        try {
                            if (f.isDirectory()) {
                                UUID.fromString(f.getName());
                                return;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        super.accept(f);
                    }
                };
                if (rel.exists()) {
                    UtilityCommands.allFiles(rel.listFiles(), false, (Consumer<File>)forEachFile);
                }
            }
        } else {
            rel = MainUtil.resolveRelative(new File(dir, dirFilter));
            if (rel.exists()) {
                UtilityCommands.allFiles(rel.listFiles(), false, (Consumer<File>)forEachFile);
            }
        }
        if (!filters.isEmpty() && !toFilter.isEmpty()) {
            List<File> result = UtilityCommands.filter(toFilter, filters);
            for (File file : result) {
                rootFunction.accept(file);
            }
        }
    }

    private static List<File> filter(List<File> fileList, List<String> filters) {
        String[] normalizedNames = new String[fileList.size()];
        for (int i = 0; i < fileList.size(); ++i) {
            String normalized = fileList.get(i).getName().toLowerCase(Locale.ROOT);
            if (normalized.startsWith("../")) {
                normalized = normalized.substring(3);
            }
            normalizedNames[i] = normalized.replace("/", File.separator);
        }
        for (String filter : filters) {
            int i;
            if (fileList.isEmpty()) {
                return fileList;
            }
            String lowerFilter = filter.toLowerCase(Locale.ROOT).replace("/", File.separator);
            ArrayList<File> newList = new ArrayList<File>();
            for (i = 0; i < normalizedNames.length; ++i) {
                if (!normalizedNames[i].startsWith(lowerFilter)) continue;
                newList.add(fileList.get(i));
            }
            if (newList.isEmpty()) {
                UUID fromName;
                String checkName;
                for (i = 0; i < normalizedNames.length; ++i) {
                    if (!normalizedNames[i].contains(lowerFilter)) continue;
                    newList.add(fileList.get(i));
                }
                if (newList.isEmpty() && (checkName = filter.replace("\\", "/").split("/")[0]).length() > 3 && checkName.length() <= 16 && (fromName = Fawe.imp().getUUID(checkName)) != null) {
                    lowerFilter = filter.replaceFirst(checkName, fromName.toString()).toLowerCase(Locale.ROOT);
                    for (int i2 = 0; i2 < normalizedNames.length; ++i2) {
                        if (!normalizedNames[i2].startsWith(lowerFilter)) continue;
                        newList.add(fileList.get(i2));
                    }
                }
            }
            fileList = newList;
        }
        return fileList;
    }

    public static void allFiles(File[] files, boolean recursive, Consumer<File> task) {
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                if (recursive) {
                    UtilityCommands.allFiles(f.listFiles(), recursive, task);
                    continue;
                }
                task.accept(f);
                continue;
            }
            task.accept(f);
        }
    }

    public static String getPath(File root, File file, UUID uuid) {
        File dir = uuid != null ? new File(root, uuid.toString()) : root;
        ClipboardFormat format = ClipboardFormats.findByFile(file);
        URI relative = dir.toURI().relativize(file.toURI());
        StringBuilder name = new StringBuilder();
        if (relative.isAbsolute()) {
            relative = root.toURI().relativize(file.toURI());
            name.append(".." + File.separator);
        }
        name.append(relative.getPath());
        return name.toString();
    }

    public static enum URIType {
        URL,
        FILE,
        DIRECTORY,
        OTHER;

    }
}

