/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweVersion;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.paster.IncendoPaster;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.PrintCommandHelp;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.ConfigurationLoadEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extension.platform.PlatformManager;
import com.sk89q.worldedit.util.formatting.component.MessageBox;
import com.sk89q.worldedit.util.formatting.component.TextComponentProducer;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.zone.ZoneRulesException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class WorldEditCommands {
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z");
    private final WorldEdit we;

    public WorldEditCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(name="version", aliases={"ver"}, desc="Get the FAWE version")
    @CommandPermissions(queued=false)
    public void version(Actor actor) {
        FaweVersion fVer = Fawe.get().getVersion();
        String fVerStr = fVer == null ? "unknown" : "-" + fVer.build;
        actor.print(TextComponent.of("FastAsyncWorldEdit" + fVerStr + " created by Empire92, MattBDev, IronApollo, dordsor21 and NotMyFault"));
        if (fVer != null) {
            FaweVersion version = Fawe.get().getVersion();
            Date date = new GregorianCalendar(2000 + version.year, version.month - 1, version.day).getTime();
            TextComponent dateArg = TextComponent.of(date.toLocaleString());
            TextComponent commitArg = TextComponent.of(Integer.toHexString(version.hash));
            TextComponent buildArg = TextComponent.of(version.build);
            TextComponent platformArg = TextComponent.of(Settings.IMP.PLATFORM);
            actor.printInfo(TranslatableComponent.of("worldedit.version.version", dateArg, commitArg, buildArg, platformArg));
        }
        actor.printInfo(TextComponent.of("Wiki: https://wiki.intellectualsites.com/FastAsyncWorldEdit/index"));
        PlatformManager pm = this.we.getPlatformManager();
        TextComponentProducer producer = new TextComponentProducer();
        for (Platform platform : pm.getPlatforms()) {
            producer.append(((TextComponent)TextComponent.of("* ", TextColor.GRAY).append(TextComponent.of(platform.getPlatformName()))).append(TextComponent.of("(" + platform.getPlatformVersion() + ")"))).newline();
        }
        actor.print(new MessageBox("Platforms", producer, TextColor.GRAY).create());
        producer.reset();
        for (Capability capability : Capability.values()) {
            Platform platform = pm.queryCapability(capability);
            producer.append(TextComponent.of(capability.name(), TextColor.GRAY).append(TextComponent.of(": ").append(TextComponent.of(platform != null ? platform.getPlatformName() : "NONE")))).newline();
        }
        actor.print(new MessageBox("Capabilities", producer, TextColor.GRAY).create());
    }

    @Command(name="reload", desc="Reload configuration and translations")
    @CommandPermissions(value={"worldedit.reload"})
    public void reload(Actor actor) {
        this.we.getPlatformManager().queryCapability(Capability.CONFIGURATION).reload();
        this.we.getEventBus().post(new ConfigurationLoadEvent(this.we.getPlatformManager().queryCapability(Capability.CONFIGURATION).getConfiguration()));
        Fawe.get().setupConfigs();
        actor.printInfo(TranslatableComponent.of("worldedit.reload.config"));
    }

    @Command(name="debugpaste", desc="Writes a report of latest.log, config.yml, config-legacy.yml, strings.json to https://athion.net/ISPaster/paste")
    @CommandPermissions(value={"worldedit.report", "worldedit.debugpaste"}, queued=false)
    public void report(Actor actor) throws WorldEditException {
        String dest;
        try {
            File logFile = new File(Fawe.imp().getDirectory(), "../../logs/latest.log");
            File config = new File(Fawe.imp().getDirectory(), "config.yml");
            File legacyConfig = new File(Fawe.imp().getDirectory(), "config-legacy.yml");
            dest = IncendoPaster.debugPaste(logFile, Fawe.imp().getDebugInfo(), config, legacyConfig);
        }
        catch (IOException e) {
            actor.printInfo(TextComponent.of(e.getMessage()));
            return;
        }
        actor.printInfo(TranslatableComponent.of("worldedit.report.written", TextComponent.of(dest).clickEvent(ClickEvent.openUrl(dest))));
    }

    @Command(name="threads", desc="Print all thread stacks")
    @CommandPermissions(value={"worldedit.threads"}, queued=false)
    public void threads(Actor actor) throws WorldEditException {
        Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stacks.entrySet()) {
            Thread thread = entry.getKey();
            actor.printDebug("--------------------------------------------------------------------------------------------");
            actor.printDebug("Thread: " + thread.getName() + " | Id: " + thread.getId() + " | Alive: " + thread.isAlive());
            for (StackTraceElement elem : entry.getValue()) {
                actor.printDebug(elem.toString());
            }
        }
    }

    @Command(name="cui", desc="Complete CUI handshake (internal usage)")
    @CommandPermissions
    public void cui(Player player, LocalSession session) {
        session.setCUISupport(true);
        session.dispatchCUISetup(player);
    }

    @Command(name="tz", desc="Set your timezone for snapshots")
    public void tz(Actor actor, LocalSession session, @Arg(desc="The timezone to set") String timezone) {
        try {
            ZoneId tz = ZoneId.of(timezone);
            session.setTimezone(tz);
            actor.printInfo(TranslatableComponent.of("worldedit.timezone.set", TextComponent.of(tz.getDisplayName(TextStyle.FULL, actor.getLocale()))));
            actor.printInfo(TranslatableComponent.of("worldedit.timezone.current", TextComponent.of(dateFormat.withLocale(actor.getLocale()).format(ZonedDateTime.now(tz)))));
        }
        catch (ZoneRulesException e) {
            actor.printError(TranslatableComponent.of("worldedit.timezone.invalid"));
        }
    }

    @Command(name="help", desc="Displays help for WorldEdit commands")
    @CommandPermissions(value={"worldedit.help"}, queued=false)
    public void help(Actor actor, @Switch(name=115, desc="List sub-commands of the given command, if applicable") boolean listSubCommands, @ArgFlag(name=112, desc="The page to retrieve", def={"1"}) int page, @Arg(desc="The command to retrieve help for", def={""}, variable=true) List<String> command) throws WorldEditException {
        PrintCommandHelp.help(command, page, listSubCommands, this.we.getPlatformManager().getPlatformCommandManager().getCommandManager(), actor, "/worldedit help");
    }
}

