/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.beta.implementation.IChunkExtent;
import com.boydti.fawe.beta.implementation.processors.NullProcessor;
import com.boydti.fawe.beta.implementation.processors.PersistentChunkSendProcessor;
import com.boydti.fawe.config.Caption;
import com.boydti.fawe.object.brush.BrushSettings;
import com.boydti.fawe.object.brush.MovableTool;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.TargetMode;
import com.boydti.fawe.object.brush.scroll.Scroll;
import com.boydti.fawe.object.brush.scroll.ScrollTool;
import com.boydti.fawe.object.brush.visualization.VisualExtent;
import com.boydti.fawe.object.brush.visualization.VisualMode;
import com.boydti.fawe.object.extent.ResettableExtent;
import com.boydti.fawe.object.mask.MaskedTargetBlock;
import com.boydti.fawe.object.pattern.PatternTraverser;
import com.boydti.fawe.util.BrushCache;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.ExtentTraverser;
import com.boydti.fawe.util.MaskTraverser;
import com.boydti.fawe.util.StringMan;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.command.tool.DoubleActionTraceTool;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.SolidBlockMask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class BrushTool
implements DoubleActionTraceTool,
ScrollTool,
MovableTool,
ResettableTool,
Serializable {
    protected static int MAX_RANGE = 500;
    protected static int DEFAULT_RANGE = 240;
    protected int range = -1;
    private VisualMode visualMode = VisualMode.NONE;
    private TargetMode targetMode = TargetMode.TARGET_BLOCK_RANGE;
    private Mask traceMask = null;
    private int targetOffset;
    private transient BrushSettings primary = new BrushSettings();
    private transient BrushSettings secondary = new BrushSettings();
    private transient BrushSettings context = this.primary;
    private transient PersistentChunkSendProcessor visualExtent;
    private transient BaseItem holder;

    public BrushTool(String permission) {
        Preconditions.checkNotNull((Object)permission);
        this.getContext().addPermission(permission);
    }

    public BrushTool() {
    }

    public void setHolder(BaseItem holder) {
        this.holder = holder;
    }

    public boolean isSet() {
        return this.primary.getBrush() != null || this.secondary.getBrush() != null;
    }

    public void update() {
        if (this.holder != null) {
            BrushCache.setTool(this.holder, this);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeBoolean(this.primary == this.secondary);
        stream.writeObject(this.primary);
        if (this.primary != this.secondary) {
            stream.writeObject(this.secondary);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        boolean multi = stream.readBoolean();
        this.primary = (BrushSettings)stream.readObject();
        this.secondary = multi ? (BrushSettings)stream.readObject() : this.primary;
        this.context = this.primary;
    }

    public BrushSettings getContext() {
        BrushSettings tmp = this.context;
        if (tmp == null) {
            this.context = tmp = this.primary;
        }
        return tmp;
    }

    public void setContext(BrushSettings context) {
        this.context = context;
    }

    @Override
    public boolean canUse(Actor player) {
        if (this.primary == this.secondary) {
            return this.primary.canUse(player);
        }
        return this.primary.canUse(player) && this.secondary.canUse(player);
    }

    public ResettableExtent getTransform() {
        return this.getContext().getTransform();
    }

    public BrushSettings getPrimary() {
        return this.primary;
    }

    public BrushSettings getSecondary() {
        return this.secondary;
    }

    public BrushSettings getOffHand() {
        return this.context == this.primary ? this.secondary : this.primary;
    }

    public void setPrimary(BrushSettings primary) {
        Preconditions.checkNotNull((Object)primary);
        this.primary = primary;
        this.context = primary;
        this.update();
    }

    public void setSecondary(BrushSettings secondary) {
        Preconditions.checkNotNull((Object)secondary);
        this.secondary = secondary;
        this.context = secondary;
        this.update();
    }

    public void setTransform(ResettableExtent transform) {
        this.getContext().setTransform(transform);
        this.update();
    }

    public Mask getMask() {
        return this.getContext().getMask();
    }

    public Mask getSourceMask() {
        return this.getContext().getSourceMask();
    }

    @Override
    public boolean reset() {
        Brush br = this.getBrush();
        if (br instanceof ResettableTool) {
            return ((ResettableTool)((Object)br)).reset();
        }
        return false;
    }

    public void setMask(Mask filter) {
        this.getContext().setMask(filter);
        this.update();
    }

    @Nullable
    public Mask getTraceMask() {
        return this.traceMask;
    }

    public void setTraceMask(@Nullable Mask traceMask) {
        this.traceMask = traceMask;
        this.update();
    }

    public void setSourceMask(Mask filter) {
        this.getContext().setSourceMask(filter);
        this.update();
    }

    public void setBrush(Brush brush, String permission) {
        BrushSettings current = this.getContext();
        current.clearPerms();
        current.setBrush(brush);
        current.addPermission(permission);
        this.update();
    }

    public Brush getBrush() {
        return this.getContext().getBrush();
    }

    public void setFill(@Nullable Pattern material) {
        this.getContext().setFill(material);
    }

    @Nullable
    public Pattern getMaterial() {
        return this.getContext().getMaterial();
    }

    public double getSize() {
        return this.getContext().getSize();
    }

    public void setSize(double radius) {
        this.getContext().setSize(radius);
    }

    public void setSize(Expression radius) {
        this.getContext().setSize(radius);
    }

    public int getRange() {
        return this.range < 0 ? DEFAULT_RANGE : Math.min(this.range, MAX_RANGE);
    }

    public void setRange(int range) {
        this.range = range;
    }

    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session) {
        return this.act(BrushAction.PRIMARY, player, session);
    }

    public BlockVector3 getPosition(EditSession editSession, Player player) {
        Location loc = player.getLocation();
        switch (this.targetMode) {
            case TARGET_BLOCK_RANGE: {
                return this.offset(this.trace(editSession, player, this.getRange(), true), loc).toBlockPoint();
            }
            case FORWARD_POINT_PITCH: {
                int d2 = 0;
                float pitch = loc.getPitch();
                pitch = 23.0f - pitch / 4.0f;
                Vector3 vector = loc.getDirection().withY(0.0).normalize().multiply(d2 += (int)(Math.sin(Math.toRadians(pitch)) * 50.0)).add(loc.getX(), loc.getY(), loc.getZ());
                return this.offset(vector, loc).toBlockPoint();
            }
            case TARGET_POINT_HEIGHT: {
                BlockType block;
                int y;
                int height = loc.getBlockY();
                int x = loc.getBlockX();
                int z = loc.getBlockZ();
                for (y = height; y > 0 && !(block = editSession.getBlockType(x, y, z)).getMaterial().isMovementBlocker(); --y) {
                }
                int distance = height - y + 8;
                return this.offset(this.trace(editSession, player, distance, true), loc).toBlockPoint();
            }
            case TARGET_FACE_RANGE: {
                return this.offset(this.trace(editSession, player, this.getRange(), true), loc).toBlockPoint();
            }
        }
        return null;
    }

    private Vector3 offset(Vector3 target, Vector3 playerPos) {
        if (this.targetOffset == 0) {
            return target;
        }
        return target.subtract(target.subtract(playerPos).normalize().multiply(this.targetOffset));
    }

    private Vector3 trace(EditSession editSession, Player player, int range, boolean useLastBlock) {
        Mask mask = this.traceMask == null ? new SolidBlockMask(editSession) : this.traceMask;
        new MaskTraverser(mask).reset(editSession);
        MaskedTargetBlock tb = new MaskedTargetBlock(mask, player, range, 0.2);
        return tb.getMaskedTargetBlock(useLastBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean act(BrushAction action, Player player, LocalSession session) {
        switch (action) {
            case PRIMARY: {
                this.setContext(this.primary);
                break;
            }
            case SECONDARY: {
                this.setContext(this.secondary);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)action));
            }
        }
        BrushSettings current = this.getContext();
        Brush brush = current.getBrush();
        if (brush == null) {
            return false;
        }
        if (!current.canUse(player)) {
            player.print(Caption.of("fawe.error.no-perm", StringMan.join(current.getPermissions(), ",")));
            return false;
        }
        try (EditSession editSession = session.createEditSession(player, current.toString());){
            ResettableExtent transform;
            Mask sourceMask;
            Location target = player.getBlockTrace(this.getRange(), true, this.traceMask);
            if (target == null) {
                editSession.cancel();
                player.printError(TranslatableComponent.of("worldedit.tool.no-block"));
                boolean bl = true;
                return bl;
            }
            BlockBag bag = session.getBlockBag(player);
            Request.request().setEditSession(editSession);
            Mask mask = current.getMask();
            if (mask != null) {
                Mask existingMask = editSession.getMask();
                if (existingMask == null) {
                    editSession.setMask(mask);
                } else if (existingMask instanceof MaskIntersection) {
                    ((MaskIntersection)existingMask).add(mask);
                } else {
                    MaskIntersection newMask = new MaskIntersection(existingMask);
                    newMask.add(mask);
                    editSession.setMask(newMask);
                }
            }
            if ((sourceMask = current.getSourceMask()) != null) {
                editSession.addSourceMask(sourceMask);
            }
            if ((transform = current.getTransform()) != null) {
                editSession.addTransform(transform);
            }
            try {
                new PatternTraverser(current).reset(editSession);
                double size = current.getSize();
                WorldEdit.getInstance().checkMaxBrushRadius(size);
                brush.build(editSession, target.toBlockPoint(), current.getMaterial(), size);
            }
            catch (MaxChangedBlocksException e) {
                player.printError(TranslatableComponent.of("worldedit.tool.max-block-changes"));
            }
            finally {
                session.remember(editSession);
                if (bag != null) {
                    bag.flushChanges();
                }
            }
        }
        finally {
            Request.reset();
        }
        return true;
    }

    @Override
    public boolean actSecondary(Platform server, LocalConfiguration config, Player player, LocalSession session) {
        return this.act(BrushAction.SECONDARY, player, session);
    }

    public void setScrollAction(Scroll scrollAction) {
        this.getContext().setScrollAction(scrollAction);
        this.update();
    }

    public void setTargetOffset(int targetOffset) {
        this.targetOffset = targetOffset;
        this.update();
    }

    public void setTargetMode(TargetMode targetMode) {
        this.targetMode = targetMode != null ? targetMode : TargetMode.TARGET_BLOCK_RANGE;
        this.update();
    }

    public void setVisualMode(Player player, VisualMode visualMode) {
        if (visualMode == null) {
            visualMode = VisualMode.NONE;
        }
        if (this.visualMode != visualMode) {
            if (this.visualMode != VisualMode.NONE) {
                this.clear(player);
            }
            this.visualMode = visualMode;
            if (visualMode != VisualMode.NONE) {
                try {
                    this.queueVisualization(player);
                }
                catch (Throwable e) {
                    WorldEdit.getInstance().getPlatformManager().handleThrowable(e, player);
                }
            }
        }
        this.update();
    }

    public TargetMode getTargetMode() {
        return this.targetMode;
    }

    public int getTargetOffset() {
        return this.targetOffset;
    }

    public VisualMode getVisualMode() {
        return this.visualMode;
    }

    @Override
    public boolean increment(Player player, int amount) {
        BrushSettings current = this.getContext();
        Scroll tmp = current.getScrollAction();
        if (tmp != null) {
            tmp.setTool(this);
            if (tmp.increment(player, amount)) {
                if (this.visualMode != VisualMode.NONE) {
                    try {
                        this.queueVisualization(player);
                    }
                    catch (Throwable e) {
                        WorldEdit.getInstance().getPlatformManager().handleThrowable(e, player);
                    }
                }
                return true;
            }
        }
        if (this.visualMode != VisualMode.NONE) {
            this.clear(player);
        }
        return false;
    }

    public void queueVisualization(Player player) {
        Fawe.get().getVisualQueue().queue(player);
    }

    @Deprecated
    public synchronized void visualize(BrushAction action, Player player) throws WorldEditException {
        VisualMode mode = this.getVisualMode();
        if (mode == VisualMode.NONE) {
            return;
        }
        BrushSettings current = this.getContext();
        Brush brush = current.getBrush();
        if (brush == null) {
            return;
        }
        EditSessionBuilder builder = new EditSessionBuilder(player.getWorld()).command(current.toString()).player(player).allowedRegionsEverywhere().autoQueue(false).blockBag(null).changeSetNull().fastmode(true).combineStages(true);
        EditSession editSession = builder.build();
        World world = editSession.getWorld();
        Supplier<Collection<Player>> players = () -> Collections.singleton(player);
        PersistentChunkSendProcessor newVisualExtent = new PersistentChunkSendProcessor(world, this.visualExtent, players);
        ExtentTraverser<IChunkExtent> traverser = new ExtentTraverser<EditSession>(editSession).find(IChunkExtent.class);
        if (traverser == null) {
            throw new IllegalStateException("No queue found");
        }
        IChunkExtent chunkExtent = traverser.get();
        if (this.visualExtent != null) {
            this.visualExtent.init(chunkExtent);
        }
        newVisualExtent.init(chunkExtent);
        editSession.addProcessor(newVisualExtent);
        editSession.addProcessor(NullProcessor.getInstance());
        BlockVector3 position = this.getPosition(editSession, player);
        if (position != null) {
            switch (mode) {
                case POINT: {
                    editSession.setBlock(position, VisualExtent.VISUALIZE_BLOCK_DEFAULT);
                    break;
                }
                case OUTLINE: {
                    new PatternTraverser(current).reset(editSession);
                    brush.build(editSession, position, current.getMaterial(), current.getSize());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)mode));
                }
            }
        }
        editSession.flushQueue();
        if (this.visualExtent != null) {
            this.visualExtent.flush();
        }
        this.visualExtent = newVisualExtent;
        newVisualExtent.flush();
    }

    public void clear(Player player) {
        Fawe.get().getVisualQueue().dequeue(player);
        if (this.visualExtent != null) {
            this.visualExtent.clear();
        }
    }

    @Override
    public boolean move(Player player) {
        if (this.visualMode != VisualMode.NONE) {
            this.queueVisualization(player);
            return true;
        }
        return false;
    }

    public static enum BrushAction {
        PRIMARY,
        SECONDARY;

    }
}

