/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.util.annotation;

import com.boydti.fawe.config.Caption;
import com.boydti.fawe.util.task.InterruptableCondition;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.argument.Arguments;
import com.sk89q.worldedit.event.Event;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.internal.command.CommandArgParser;
import com.sk89q.worldedit.internal.util.Substring;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.enginehub.piston.exception.StopExecutionException;
import org.enginehub.piston.inject.InjectAnnotation;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.inject.MemoizingValueAccess;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER, ElementType.METHOD})
@InjectAnnotation
public @interface Confirm {
    public Processor value() default Processor.ALWAYS;

    public static class Reflect {
        static final Field memory;

        static {
            Field f;
            try {
                f = MemoizingValueAccess.class.getDeclaredField("memory");
                f.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                f = null;
            }
            memory = f;
        }
    }

    public static enum Processor {
        REGION{

            @Override
            public boolean passes(Actor actor, InjectedValueAccess context, double value) {
                if (this.checkExisting(context)) {
                    return true;
                }
                Region region = context.injectedValue(Key.of(Region.class, Selection.class)).orElseThrow(IncompleteRegionException::new);
                BlockVector3 pos1 = region.getMinimumPoint();
                BlockVector3 pos2 = region.getMaximumPoint();
                long area = (long)((pos2.getX() - pos1.getX()) * (pos2.getZ() - pos1.getZ() + 1)) * (long)value;
                long max = 524288L;
                if (max != -1L && area > max) {
                    actor.print(Caption.of("fawe.cancel.worldedit.cancel.reason.confirm.region", pos1, pos2, Processor.getArgs(context), (long)region.getHeight() * area));
                    return Processor.confirm(actor, context);
                }
                return true;
            }
        }
        ,
        RADIUS{

            @Override
            public boolean passes(Actor actor, InjectedValueAccess context, double value) {
                if (this.checkExisting(context)) {
                    return true;
                }
                int max = WorldEdit.getInstance().getConfiguration().maxRadius;
                if (max != -1 && value > (double)max) {
                    actor.print(Caption.of("fawe.cancel.worldedit.cancel.reason.confirm.radius", value, max, Processor.getArgs(context)));
                    return Processor.confirm(actor, context);
                }
                return true;
            }
        }
        ,
        LIMIT{

            @Override
            public boolean passes(Actor actor, InjectedValueAccess context, double value) {
                if (this.checkExisting(context)) {
                    return true;
                }
                int max = 50;
                if (max != -1 && value > (double)max) {
                    actor.print(Caption.of("fawe.cancel.worldedit.cancel.reason.confirm.limit", value, max, Processor.getArgs(context)));
                    return Processor.confirm(actor, context);
                }
                return true;
            }
        }
        ,
        ALWAYS{

            @Override
            public boolean passes(Actor actor, InjectedValueAccess context, double value) {
                if (this.checkExisting(context)) {
                    return true;
                }
                actor.print(TranslatableComponent.of("fawe.cancel.worldedit.cancel.reason.confirm"));
                return Processor.confirm(actor, context);
            }
        };


        public boolean passes(Actor actor, InjectedValueAccess context, double value) {
            return true;
        }

        public <T extends Number> T check(Actor actor, InjectedValueAccess context, T value) {
            boolean isSuggestion = context.injectedValue(Key.of(Boolean.TYPE)).orElse(false);
            if (isSuggestion) {
                return value;
            }
            if (this.checkExisting(context)) {
                return value;
            }
            if (!this.passes(actor, context, value.doubleValue())) {
                throw new StopExecutionException(TextComponent.empty());
            }
            return value;
        }

        private static String getArgs(InjectedValueAccess context) {
            return context.injectedValue(Key.of(Arguments.class)).map(Arguments::get).get();
        }

        private static String getArg(InjectedValueAccess context, String def) {
            Stream<Substring> split = CommandArgParser.forArgString(Processor.getArgs(context)).parseArgs();
            Substring first = split.findFirst().orElse(null);
            if (first == null && def == null) {
                throw new StopExecutionException(TextComponent.of("No arguments"));
            }
            return first != null ? first.getSubstring() : def;
        }

        private static int getInt(InjectedValueAccess context, String def) {
            return Integer.parseInt(Processor.getArg(context, def));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean confirm(Actor actor, InjectedValueAccess context) {
            Event event = context.injectedValue(Key.of(Event.class)).orElse(null);
            if (!(event instanceof CommandEvent)) {
                return true;
            }
            ReentrantLock lock = new ReentrantLock();
            Condition condition = lock.newCondition();
            InterruptableCondition wait = new InterruptableCondition(lock, condition, Thread.currentThread());
            try {
                lock.lock();
                actor.setMeta("cmdConfirm", wait);
                try {
                    Map memory = (Map)Reflect.memory.get(context);
                    memory.put(Key.of(InterruptableCondition.class), Optional.of(wait));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (condition.await(15L, TimeUnit.SECONDS)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (actor.getMeta("cmdConfirm") == wait) {
                    actor.deleteMeta("cmdConfirm");
                }
            }
            return false;
        }

        boolean checkExisting(InjectedValueAccess context) {
            Optional<InterruptableCondition> lock = context.injectedValue(Key.of(InterruptableCondition.class));
            return lock.isPresent();
        }
    }
}

