/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.entity;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.NbtValued;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.entity.EntityTypes;
import javax.annotation.Nullable;

public class BaseEntity
implements NbtValued {
    private EntityType type;
    private CompoundTag nbtData;

    public BaseEntity(EntityType type, CompoundTag nbtData) {
        this(type);
        this.setNbtData(nbtData);
    }

    public BaseEntity(CompoundTag tag) {
        this(EntityTypes.parse(tag.getString("Id")), tag);
    }

    public BaseEntity(EntityType type) {
        this.type = type;
    }

    public BaseEntity(BaseEntity other) {
        Preconditions.checkNotNull((Object)other);
        this.type = other.getType();
        this.setNbtData(other.getNbtData());
    }

    public Location getLocation(Extent extent) {
        return this.nbtData.getEntityLocation(extent);
    }

    @Override
    public boolean hasNbtData() {
        return true;
    }

    @Override
    @Nullable
    public CompoundTag getNbtData() {
        return this.nbtData;
    }

    @Override
    public void setNbtData(@Nullable CompoundTag nbtData) {
        this.nbtData = nbtData;
    }

    public EntityType getType() {
        return this.type;
    }
}

