/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.entity;

import com.sk89q.worldedit.entity.Metadatable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface MapMetadatable
extends Metadatable {
    public Map<String, Object> getRawMeta();

    @Override
    default public void setMeta(String key, Object value) {
        this.getRawMeta().put(key, value);
    }

    @Override
    default public <T> T getAndSetMeta(String key, T value) {
        return (T)this.getRawMeta().put(key, value);
    }

    @Override
    default public boolean hasMeta() {
        return !this.getRawMeta().isEmpty();
    }

    default public Object putIfAbsent(String key, Object value) {
        return this.getRawMeta().putIfAbsent(key, value);
    }

    @Override
    default public <V> V getMeta(String key) {
        return (V)this.getRawMeta().get(key);
    }

    @Override
    @NotNull
    default public <V> V getMeta(String key, @NotNull V def) {
        Object value = this.getRawMeta().get(key);
        return (V)(value == null ? def : value);
    }

    @Override
    default public <V> V deleteMeta(String key) {
        return (V)this.getRawMeta().remove(key);
    }
}

