/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.entity;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.object.clipboard.DiskOptimizedClipboard;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.util.MainUtil;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.internal.util.DeprecationUtil;
import com.sk89q.worldedit.internal.util.NonAbstractForCompatibility;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.gamemode.GameMode;
import java.io.File;
import javax.annotation.Nullable;

public interface Player
extends Entity,
Actor {
    public World getWorld();

    public boolean isHoldingPickAxe();

    public Direction getCardinalDirection(int var1);

    public BaseItemStack getItemInHand(HandSide var1);

    public BaseBlock getBlockInHand(HandSide var1) throws WorldEditException;

    public void giveItem(BaseItemStack var1);

    public BlockBag getInventoryBlockBag();

    public GameMode getGameMode();

    public void setGameMode(GameMode var1);

    public void findFreePosition(Location var1);

    public void setOnGround(Location var1);

    public void findFreePosition();

    public boolean ascendLevel();

    public boolean descendLevel();

    public boolean ascendToCeiling(int var1);

    public boolean ascendToCeiling(int var1, boolean var2);

    public boolean ascendUpwards(int var1);

    public boolean ascendUpwards(int var1, boolean var2);

    public void floatAt(int var1, int var2, int var3, boolean var4);

    @Deprecated
    default public Location getBlockIn() {
        return this.getBlockLocation();
    }

    public Location getBlockOn();

    public Location getBlockTrace(int var1, boolean var2);

    public Location getBlockTrace(int var1, boolean var2, @Nullable Mask var3);

    public Location getBlockTraceFace(int var1, boolean var2);

    public Location getBlockTraceFace(int var1, boolean var2, @Nullable Mask var3);

    public Location getBlockTrace(int var1);

    public Location getSolidBlockTrace(int var1);

    public Direction getCardinalDirection();

    public boolean passThroughForwardWall(int var1);

    @Deprecated
    default public void setPosition(Vector3 pos, float pitch, float yaw) {
        this.trySetPosition(pos, pitch, yaw);
    }

    @NonAbstractForCompatibility(delegateName="setPosition", delegateParams={Vector3.class, float.class, float.class})
    default public boolean trySetPosition(Vector3 pos, float pitch, float yaw) {
        DeprecationUtil.checkDelegatingOverride(this.getClass());
        this.setPosition(pos, pitch, yaw);
        return true;
    }

    public <B extends BlockStateHolder<B>> void sendFakeBlock(BlockVector3 var1, @Nullable B var2);

    public Region[] getCurrentRegions();

    public Region[] getCurrentRegions(FaweMaskManager.MaskType var1);

    public Region getLargestRegion();

    public void setSelection(Region var1);

    default public Region getSelection() throws IncompleteRegionException {
        return this.getSession().getSelection(this.getWorld());
    }

    default public void setSelection(RegionSelector selector) {
        this.getSession().setRegionSelector(this.getWorld(), selector);
    }

    default public World getWorldForEditing() {
        VirtualWorld virtual = this.getSession().getVirtualWorld();
        if (virtual != null) {
            return virtual;
        }
        return WorldEdit.getInstance().getPlatformManager().getWorldForEditing(this.getWorld());
    }

    default public void unregister() {
        this.cancel(true);
        this.getSession().setClipboard(null);
        if (Settings.IMP.HISTORY.DELETE_ON_LOGOUT) {
            this.getSession().clearHistory();
            this.getSession().unregisterTools(this);
        }
    }

    public void sendTitle(Component var1, Component var2);

    default public void loadClipboardFromDisk() {
        block5: {
            File file = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.CLIPBOARD + File.separator + this.getUniqueId() + ".bd");
            try {
                if (!file.exists() || file.length() <= 5L) break block5;
                DiskOptimizedClipboard doc = new DiskOptimizedClipboard(file);
                LocalSession session = this.getSession();
                try {
                    if (session.getClipboard() != null) {
                        return;
                    }
                }
                catch (EmptyClipboardException emptyClipboardException) {
                    // empty catch block
                }
                BlockArrayClipboard clip = doc.toClipboard();
                ClipboardHolder holder = new ClipboardHolder(clip);
                this.getSession().setClipboard(holder);
            }
            catch (Exception event) {
                this.printError("====== INVALID CLIPBOARD ======");
                event.printStackTrace();
                this.printError("===============---=============");
                this.printError("This shouldn't result in any failure");
                this.printError("File: " + file.getName() + " (len:" + file.length() + ")");
                this.printError("===============---=============");
            }
        }
    }
}

