/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory.parser;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.InputParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class RichParser<E>
extends InputParser<E> {
    private final String[] prefixes;

    protected RichParser(WorldEdit worldEdit, String ... aliases) {
        super(worldEdit);
        Preconditions.checkArgument((aliases.length >= 1 ? 1 : 0) != 0, (Object)"Aliases may not be empty");
        this.prefixes = aliases;
    }

    @NotNull
    private static Predicate<String> validPrefix(String other) {
        return prefix -> {
            if (prefix.length() > other.length()) {
                return prefix.startsWith(other);
            }
            return other.startsWith((String)prefix);
        };
    }

    @NotNull
    private Function<String, Stream<? extends String>> extractArguments(String input) {
        return prefix -> {
            if (input.length() > prefix.length()) {
                String[] strings = this.extractArguments(input.substring(prefix.length()), false);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < strings.length - 1; ++i) {
                    builder.append('[').append(strings[i]).append(']');
                }
                String previous = prefix + builder;
                return this.getSuggestions(strings[strings.length - 1], strings.length - 1).map(suggestion -> previous + "[" + suggestion);
            }
            return Stream.of(prefix);
        };
    }

    public String getPrefix() {
        return this.prefixes[0];
    }

    @Override
    public Stream<String> getSuggestions(String input) {
        return Arrays.stream(this.prefixes).filter(RichParser.validPrefix(input)).flatMap(this.extractArguments(input));
    }

    @Override
    public E parseFromInput(String input, ParserContext context) throws InputParseException {
        for (String prefix : this.prefixes) {
            if (!input.startsWith(prefix) || input.length() < prefix.length()) continue;
            String[] arguments = this.extractArguments(input.substring(prefix.length()), true);
            return this.parseFromInput(arguments, context);
        }
        return null;
    }

    protected abstract Stream<String> getSuggestions(String var1, int var2);

    protected abstract E parseFromInput(@NotNull String[] var1, ParserContext var2) throws InputParseException;

    protected String[] extractArguments(String input, boolean requireClosing) throws InputParseException {
        int open = 0;
        int openIndex = 0;
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '[' && open++ == 0) {
                openIndex = i;
            }
            if (input.charAt(i) != ']' || --open != 0) continue;
            arguments.add(input.substring(openIndex + 1, i));
        }
        if (!requireClosing && open > 0) {
            arguments.add(input.substring(openIndex + 1));
        }
        if (requireClosing && open != 0) {
            throw new InputParseException("Invalid bracketing, are you missing a '[' or ']'?");
        }
        return arguments.toArray(new String[0]);
    }
}

