/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory.parser.pattern;

import com.boydti.fawe.object.pattern.BiomeApplyingPattern;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.factory.parser.RichParser;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class BiomePatternParser
extends RichParser<Pattern> {
    private static final String BIOME_PREFIX = "$";

    public BiomePatternParser(WorldEdit worldEdit) {
        super(worldEdit, "#biome");
    }

    @Override
    public Pattern parseFromInput(String input, ParserContext context) throws InputParseException {
        if (input.startsWith(BIOME_PREFIX)) {
            String biomeId = input.substring(1);
            BiomeType biomeType = BiomeTypes.get(biomeId);
            if (biomeType == null) {
                throw new NoMatchException(TranslatableComponent.of("worldedit.error.unknown-biome", TextComponent.of(biomeId)));
            }
            return new BiomeApplyingPattern(context.requireExtent(), biomeType);
        }
        return (Pattern)super.parseFromInput(input, context);
    }

    @Override
    public Stream<String> getSuggestions(String input) {
        if (input.startsWith(BIOME_PREFIX)) {
            return BiomeType.REGISTRY.getSuggestions(input.substring(1)).map(biome -> BIOME_PREFIX + biome);
        }
        return super.getSuggestions(input);
    }

    @Override
    protected Stream<String> getSuggestions(String argumentInput, int index) {
        if (index == 0) {
            return BiomeType.REGISTRY.getSuggestions(argumentInput);
        }
        return Stream.empty();
    }

    @Override
    protected Pattern parseFromInput(@NotNull String[] arguments, ParserContext context) throws InputParseException {
        if (arguments.length != 1) {
            throw new InputParseException("Invalid amount of arguments. Expected: #biome[<biome>]");
        }
        BiomeType biomeType = BiomeTypes.get(arguments[0]);
        if (biomeType == null) {
            throw new NoMatchException(TranslatableComponent.of("worldedit.error.unknown-biome", TextComponent.of(arguments[0])));
        }
        return new BiomeApplyingPattern(context.requireExtent(), biomeType);
    }
}

