/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory.parser.pattern;

import com.boydti.fawe.object.random.NoiseRandom;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.SuggestionHelper;
import com.sk89q.worldedit.extension.factory.parser.RichParser;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.pattern.RandomPattern;
import com.sk89q.worldedit.math.noise.NoiseGenerator;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class NoisePatternParser
extends RichParser<Pattern> {
    private final String name;
    private final Supplier<NoiseGenerator> generatorSupplier;

    protected NoisePatternParser(WorldEdit worldEdit, String name, Supplier<NoiseGenerator> generatorSupplier) {
        super(worldEdit, '#' + name);
        this.name = name;
        this.generatorSupplier = generatorSupplier;
    }

    @Override
    protected Stream<String> getSuggestions(String argumentInput, int index) {
        if (index == 0) {
            return SuggestionHelper.suggestPositiveDoubles(argumentInput);
        }
        if (index == 1) {
            return this.worldEdit.getPatternFactory().getSuggestions(argumentInput).stream();
        }
        return Stream.empty();
    }

    @Override
    protected Pattern parseFromInput(@NotNull String[] arguments, ParserContext context) {
        if (arguments.length != 2) {
            throw new InputParseException(TranslatableComponent.of("fawe.error.command.syntax", TextComponent.of(this.getPrefix() + "[scale][pattern] (e.g. " + this.getPrefix() + "[5][dirt,stone])")));
        }
        double scale = this.parseScale(arguments[0]);
        Pattern inner = (Pattern)this.worldEdit.getPatternFactory().parseFromInput(arguments[1], context);
        if (inner instanceof RandomPattern) {
            return new RandomPattern(new NoiseRandom(this.generatorSupplier.get(), scale), (RandomPattern)inner);
        }
        if (inner instanceof BlockStateHolder) {
            return inner;
        }
        throw new InputParseException(TextComponent.of("Pattern " + inner.getClass().getSimpleName() + " cannot be used with #" + this.name));
    }

    protected double parseScale(String argument) {
        double scale = Double.parseDouble(argument);
        return 1.0 / Math.max(1.0, scale);
    }
}

