/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.platform;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.util.task.InterruptableCondition;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.entity.MapMetadatable;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.Identifiable;
import com.sk89q.worldedit.util.auth.Subject;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public interface Actor
extends Identifiable,
SessionOwner,
Subject,
MapMetadatable {
    public String getName();

    default public String getDisplayName() {
        return this.getName();
    }

    @Deprecated
    public void printRaw(String var1);

    @Deprecated
    public void printDebug(String var1);

    @Deprecated
    public void print(String var1);

    @Deprecated
    public void printError(String var1);

    default public void printError(Component component) {
        this.print(component.color(TextColor.RED));
    }

    default public void printInfo(Component component) {
        this.print(component.color(TextColor.LIGHT_PURPLE));
    }

    default public void printDebug(Component component) {
        this.print(component.color(TextColor.GRAY));
    }

    public void print(Component var1);

    public boolean canDestroyBedrock();

    public boolean isPlayer();

    public File openFileOpenDialog(String[] var1);

    public File openFileSaveDialog(String[] var1);

    public void dispatchCUIEvent(CUIEvent var1);

    public boolean runAction(Runnable var1, boolean var2, boolean var3);

    default public boolean decline() {
        InterruptableCondition confirm = (InterruptableCondition)this.deleteMeta("cmdConfirm");
        if (confirm != null) {
            confirm.interrupt();
            return true;
        }
        return false;
    }

    default public boolean confirm() {
        InterruptableCondition confirm = (InterruptableCondition)this.deleteMeta("cmdConfirm");
        if (confirm == null) {
            return false;
        }
        confirm.signal();
        return true;
    }

    default public void queueAction(Runnable run) {
        this.runAction(run, false, true);
    }

    default public boolean checkAction() {
        long time = this.getMeta("faweActionTick", Long.MIN_VALUE);
        long tick = Fawe.get().getTimer().getTick();
        this.setMeta("faweActionTick", tick);
        return tick > time;
    }

    default public FaweLimit getLimit() {
        return Settings.IMP.getLimit(this);
    }

    default public boolean runAsyncIfFree(Runnable r) {
        return this.runAction(r, true, true);
    }

    default public boolean runIfFree(Runnable r) {
        return this.runAction(r, true, false);
    }

    default public int cancel(boolean close) {
        int cancelled = this.decline() ? 1 : 0;
        for (Request request : Request.getAll()) {
            Player player;
            EditSession editSession = request.getEditSession();
            if (editSession == null || !this.equals(player = editSession.getPlayer())) continue;
            editSession.cancel();
            ++cancelled;
        }
        VirtualWorld world = this.getSession().getVirtualWorld();
        if (world != null) {
            if (close) {
                try {
                    world.close(false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    world.close(false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return cancelled;
    }

    public Locale getLocale();

    default public void sendAnnouncements() {
    }
}

