/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.platform.binding;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.platform.binding.Binding;
import com.sk89q.worldedit.extension.platform.binding.Bindings;
import com.sk89q.worldedit.internal.expression.EvaluationException;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.math.Vector3;
import java.util.Locale;
import javax.annotation.Nullable;

public class PrimitiveBindings
extends Bindings {
    public PrimitiveBindings(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Binding
    public Expression getExpression(String argument) throws ExpressionException {
        try {
            Expression expression = Expression.compile(argument, new String[0]);
            expression.optimize();
            return expression;
        }
        catch (EvaluationException e) {
            throw new InputParseException(String.format("Expected '%s' to be a valid number (or a valid mathematical expression)", argument));
        }
        catch (ExpressionException e) {
            throw new InputParseException(String.format("Expected '%s' to be a number or valid math expression (error: %s)", argument, e.getMessage()));
        }
    }

    @Binding
    public Boolean getBoolean(String argument) {
        switch (argument.toLowerCase(Locale.ROOT)) {
            case "": {
                return null;
            }
            case "true": 
            case "yes": 
            case "on": 
            case "y": 
            case "1": 
            case "t": {
                return true;
            }
            case "false": 
            case "no": 
            case "off": 
            case "f": 
            case "n": 
            case "0": {
                return false;
            }
        }
        throw new InputParseException("Invalid boolean " + argument);
    }

    @Binding
    public Vector3 getVector3(String argument) {
        double radiusX;
        double radiusY;
        double radiusZ;
        String[] radii = argument.split(",");
        switch (radii.length) {
            case 1: {
                radiusY = radiusZ = PrimitiveBindings.parseNumericInput(radii[0]).doubleValue();
                radiusX = radiusZ;
                break;
            }
            case 3: {
                radiusX = PrimitiveBindings.parseNumericInput(radii[0]);
                radiusY = PrimitiveBindings.parseNumericInput(radii[1]);
                radiusZ = PrimitiveBindings.parseNumericInput(radii[2]);
                break;
            }
            default: {
                throw new InputParseException("You must either specify 1 or 3 radius values.");
            }
        }
        return Vector3.at(radiusX, radiusY, radiusZ);
    }

    @Binding
    public Vector2 getVector2(String argument) {
        double radiusX;
        double radiusZ;
        String radiusString = argument;
        String[] radii = radiusString.split(",");
        switch (radii.length) {
            case 1: {
                radiusX = radiusZ = PrimitiveBindings.parseNumericInput(radii[0]).doubleValue();
                break;
            }
            case 2: {
                radiusX = PrimitiveBindings.parseNumericInput(radii[0]);
                radiusZ = PrimitiveBindings.parseNumericInput(radii[1]);
                break;
            }
            default: {
                throw new InputParseException("You must either specify 1 or 2 radius values.");
            }
        }
        return Vector2.at(radiusX, radiusZ);
    }

    @Binding
    public BlockVector3 getBlockVector3(String argument) {
        double radiusX;
        double radiusY;
        double radiusZ;
        String radiusString = argument;
        String[] radii = radiusString.split(",");
        switch (radii.length) {
            case 1: {
                radiusY = radiusZ = PrimitiveBindings.parseNumericInput(radii[0]).doubleValue();
                radiusX = radiusZ;
                break;
            }
            case 3: {
                radiusX = PrimitiveBindings.parseNumericInput(radii[0]);
                radiusY = PrimitiveBindings.parseNumericInput(radii[1]);
                radiusZ = PrimitiveBindings.parseNumericInput(radii[2]);
                break;
            }
            default: {
                throw new InputParseException("You must either specify 1 or 3 radius values.");
            }
        }
        return BlockVector3.at(radiusX, radiusY, radiusZ);
    }

    @Binding
    public BlockVector2 getBlockVector2(String argument) {
        double radiusX;
        double radiusZ;
        String[] radii = argument.split(",");
        switch (radii.length) {
            case 1: {
                radiusX = radiusZ = PrimitiveBindings.parseNumericInput(radii[0]).doubleValue();
                break;
            }
            case 2: {
                radiusX = PrimitiveBindings.parseNumericInput(radii[0]);
                radiusZ = PrimitiveBindings.parseNumericInput(radii[1]);
                break;
            }
            default: {
                throw new InputParseException("You must either specify 1 or 2 radius values.");
            }
        }
        return BlockVector2.at(radiusX, radiusZ);
    }

    @Nullable
    public static Double parseNumericInput(@Nullable String input) {
        if (input == null) {
            return null;
        }
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException e1) {
            try {
                Expression expression = Expression.compile(input, new String[0]);
                return expression.evaluate(new double[0]);
            }
            catch (EvaluationException e) {
                throw new InputParseException(String.format("Expected '%s' to be a valid number (or a valid mathematical expression)", input));
            }
            catch (ExpressionException e) {
                throw new InputParseException(String.format("Expected '%s' to be a number or valid math expression (error: %s)", input, e.getMessage()));
            }
        }
    }
}

