/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent;

import com.boydti.fawe.beta.IBatchProcessor;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.HistoryExtent;
import com.boydti.fawe.object.changeset.AbstractChangeSet;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.util.ExtentTraverser;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.buffer.ForgetfulExtentBuffer;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.OperationQueue;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Range;

public class AbstractDelegateExtent
implements Extent {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDelegateExtent.class);
    public Extent extent;

    public AbstractDelegateExtent(Extent extent) {
        Preconditions.checkNotNull((Object)extent);
        this.extent = extent;
    }

    public Extent getExtent() {
        return this.extent;
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        return this.extent.getBlock(position.getX(), position.getY(), position.getZ());
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.extent.getBlock(x, y, z);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        return this.extent.getFullBlock(position.getX(), position.getY(), position.getZ());
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        return this.extent.getFullBlock(x, y, z);
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        return this.extent.getBiomeType(x, y, z);
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        return this.extent.getBiome(position);
    }

    @Override
    public int getEmmittedLight(int x, int y, int z) {
        return this.extent.getEmmittedLight(x, y, z);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.extent.getSkyLight(x, y, z);
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        return this.extent.getBrightness(x, y, z);
    }

    public void setChangeSet(AbstractChangeSet changeSet) {
        if (this.extent instanceof HistoryExtent) {
            HistoryExtent history = (HistoryExtent)this.extent;
            if (changeSet == null) {
                new ExtentTraverser<AbstractDelegateExtent>(this).setNext((AbstractDelegateExtent)history.getExtent());
            } else {
                history.setChangeSet(changeSet);
            }
        } else if (this.extent instanceof AbstractDelegateExtent) {
            ((AbstractDelegateExtent)this.extent).setChangeSet(changeSet);
        } else if (changeSet != null) {
            new ExtentTraverser<AbstractDelegateExtent>(this).setNext(new HistoryExtent(this.extent, changeSet));
        }
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 position, T block) throws WorldEditException {
        return this.extent.setBlock(position.getX(), position.getY(), position.getZ(), block);
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(int x, @Range(from=0L, to=255L) int y, int z, T block) throws WorldEditException {
        return this.extent.setBlock(x, y, z, block);
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tile) throws WorldEditException {
        return this.setBlock(x, y, z, (T)this.getBlock(x, y, z).toBaseBlock(tile));
    }

    @Override
    public boolean fullySupports3DBiomes() {
        return this.extent.fullySupports3DBiomes();
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        return this.extent.setBiome(x, y, z, biome);
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        return this.extent.setBiome(position.getX(), position.getY(), position.getZ(), biome);
    }

    @Override
    public void setBlockLight(int x, int y, int z, int value) {
        this.extent.setSkyLight(x, y, z, value);
    }

    @Override
    public void setSkyLight(int x, int y, int z, int value) {
        this.extent.setSkyLight(x, y, z, value);
    }

    public String toString() {
        return super.toString() + ":" + (this.extent == this ? "" : this.extent.toString());
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return this.extent.getMinimumPoint();
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return this.extent.getMaximumPoint();
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        return this.extent.getEntities(region);
    }

    @Override
    public List<? extends Entity> getEntities() {
        return this.extent.getEntities();
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        return this.extent.createEntity(location, entity);
    }

    @Override
    public void removeEntity(int x, int y, int z, UUID uuid) {
        this.extent.removeEntity(x, y, z, uuid);
    }

    @Override
    public boolean isQueueEnabled() {
        return this.extent.isQueueEnabled();
    }

    @Override
    public void enableQueue() {
        try {
            this.extent.enableQueue();
        }
        catch (FaweException enableQueue) {
            new ExtentTraverser<AbstractDelegateExtent>(this).setNext(new ForgetfulExtentBuffer(this.extent));
        }
    }

    @Override
    public void disableQueue() {
        try {
            if (!(this.extent instanceof ForgetfulExtentBuffer)) {
                this.extent.disableQueue();
            }
        }
        catch (FaweException faweException) {
            // empty catch block
        }
        if (this.extent instanceof AbstractDelegateExtent) {
            Extent next = ((AbstractDelegateExtent)this.extent).getExtent();
            new ExtentTraverser<AbstractDelegateExtent>(this).setNext((AbstractDelegateExtent)next);
        } else {
            LoggerFactory.getLogger(AbstractDelegateExtent.class).debug("Cannot disable queue");
        }
    }

    @Override
    @Nullable
    public Operation commit() {
        Operation ours = this.commitBefore();
        Operation other = null;
        if (this.extent != this) {
            other = this.extent.commit();
        }
        if (ours != null && other != null) {
            return new OperationQueue(ours, other);
        }
        if (ours != null) {
            return ours;
        }
        if (other != null) {
            return other;
        }
        return null;
    }

    @Override
    public int getMaxY() {
        return this.extent.getMaxY();
    }

    @Override
    public boolean relight(int x, int y, int z) {
        return this.extent.relight(x, y, z);
    }

    @Override
    public boolean relightBlock(int x, int y, int z) {
        return this.extent.relightBlock(x, y, z);
    }

    @Override
    public boolean relightSky(int x, int y, int z) {
        return this.extent.relightSky(x, y, z);
    }

    @Override
    public Extent addProcessor(IBatchProcessor processor) {
        Extent result;
        if (Settings.IMP.EXPERIMENTAL.OTHER) {
            StackTraceElement[] stackTrace;
            logger.info("addProcessor Info: \t " + processor.getClass().getName());
            logger.info("The following is not an error or a crash:");
            for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                logger.info(stackTraceElement.toString());
            }
        }
        if ((result = this.extent.addProcessor(processor)) != this.extent) {
            new ExtentTraverser<AbstractDelegateExtent>(this).setNext((AbstractDelegateExtent)result);
        }
        return this;
    }

    @Override
    public Extent addPostProcessor(IBatchProcessor processor) {
        Extent result;
        if (Settings.IMP.EXPERIMENTAL.OTHER) {
            StackTraceElement[] stackTrace;
            logger.info("addPostProcessor Info: \t " + processor.getClass().getName());
            logger.info("The following is not an error or a crash:");
            for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                logger.info(stackTraceElement.toString());
            }
        }
        if ((result = this.extent.addPostProcessor(processor)) != this.extent) {
            new ExtentTraverser<AbstractDelegateExtent>(this).setNext((AbstractDelegateExtent)result);
        }
        return this;
    }

    @Override
    public Extent disableHistory() {
        Extent result = this.extent.disableHistory();
        if (result != this.extent) {
            new ExtentTraverser<AbstractDelegateExtent>(this).setNext((AbstractDelegateExtent)result);
        }
        return this;
    }

    protected Operation commitBefore() {
        return null;
    }
}

