/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.Filter;
import com.boydti.fawe.beta.IBatchProcessor;
import com.boydti.fawe.beta.IChunk;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.implementation.filter.block.CharFilterBlock;
import com.boydti.fawe.beta.implementation.filter.block.ChunkFilterBlock;
import com.boydti.fawe.beta.implementation.filter.block.FilterBlock;
import com.boydti.fawe.beta.implementation.processors.ProcessorScope;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class MaskingExtent
extends AbstractDelegateExtent
implements IBatchProcessor,
Filter {
    private Mask mask;
    private final LoadingCache<Long, ChunkFilterBlock> threadIdToFilter;

    public MaskingExtent(Extent extent, Mask mask) {
        super(extent);
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
        this.threadIdToFilter = FaweCache.IMP.createCache(() -> new CharFilterBlock(this.getExtent()));
    }

    private MaskingExtent(Extent extent, Mask mask, LoadingCache<Long, ChunkFilterBlock> threadIdToFilter) {
        super(extent);
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
        this.threadIdToFilter = threadIdToFilter;
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        return this.mask.test(location) && super.setBlock(location, block);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        return this.mask.test(BlockVector3.at(x, y, z)) && super.setBiome(x, y, z, biome);
    }

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        ChunkFilterBlock filter = (ChunkFilterBlock)this.threadIdToFilter.getUnchecked((Object)Thread.currentThread().getId());
        return filter.filter(chunk, get, set, this);
    }

    @Override
    public Future<IChunkSet> postProcessSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        return CompletableFuture.completedFuture(set);
    }

    @Override
    public void applyBlock(FilterBlock block) {
        if (!this.mask.test(block)) {
            block.setOrdinal(0);
        }
    }

    @Override
    public Extent construct(Extent child) {
        if (child == this.getExtent()) {
            return this;
        }
        return new MaskingExtent(child, this.mask.copy(), this.threadIdToFilter);
    }

    @Override
    public Filter fork() {
        return new MaskingExtent(this.getExtent(), this.mask.copy(), this.threadIdToFilter);
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.REMOVING_BLOCKS;
    }
}

