/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.visitor.Order;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector2;
import com.sk89q.worldedit.math.OffsetBlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class BlockArrayClipboard
implements Clipboard {
    private final Region region;
    private final BlockVector3 origin;
    private final Clipboard parent;

    public BlockArrayClipboard(Region region) {
        this(region, UUID.randomUUID());
    }

    public BlockArrayClipboard(Clipboard clipboard, BlockVector3 offset) {
        this.parent = clipboard;
        Region shifted = clipboard.getRegion().clone();
        shifted.shift(offset);
        this.region = shifted;
        this.origin = shifted.getMinimumPoint();
    }

    public BlockArrayClipboard(Region region, UUID clipboardId) {
        this(region, Clipboard.create(region, clipboardId));
    }

    public BlockArrayClipboard(Region region, Clipboard parent) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)region);
        this.parent = parent;
        this.region = region.clone();
        this.origin = region.getMinimumPoint();
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public BlockVector3 getOrigin() {
        return this.getParent().getOrigin().add(this.region.getMinimumPoint());
    }

    @Override
    public void setOrigin(BlockVector3 origin) {
        this.getParent().setOrigin(origin.subtract(this.region.getMinimumPoint()));
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return this.region.getMinimumPoint();
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return this.region.getMaximumPoint();
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        if (this.region.contains(position)) {
            int x = position.getBlockX() - this.origin.getX();
            int y = position.getBlockY() - this.origin.getY();
            int z = position.getBlockZ() - this.origin.getZ();
            return this.getParent().getBlock(x, y, z);
        }
        return BlockTypes.AIR.getDefaultState();
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        if (this.region.contains(position)) {
            int x = position.getBlockX() - this.origin.getX();
            int y = position.getBlockY() - this.origin.getY();
            int z = position.getBlockZ() - this.origin.getZ();
            return this.getParent().getFullBlock(x, y, z);
        }
        return BlockTypes.AIR.getDefaultState().toBaseBlock();
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block) throws WorldEditException {
        if (this.region.contains(position)) {
            int x = position.getBlockX();
            int y = position.getBlockY();
            int z = position.getBlockZ();
            return this.setBlock(x, y, z, block);
        }
        return false;
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tag) {
        return this.getParent().setTile(x -= this.origin.getX(), y -= this.origin.getY(), z -= this.origin.getZ(), tag);
    }

    public boolean setTile(BlockVector3 position, CompoundTag tag) {
        return this.setTile(position.getX(), position.getY(), position.getZ(), tag);
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) throws WorldEditException {
        return this.parent.setBlock(x -= this.origin.getX(), y -= this.origin.getY(), z -= this.origin.getZ(), block);
    }

    @Override
    public boolean hasBiomes() {
        return this.getParent().hasBiomes();
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        BlockVector3 v = position.subtract(this.region.getMinimumPoint());
        return this.getParent().getBiomeType(v.getX(), v.getY(), v.getZ());
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        int x = position.getBlockX() - this.origin.getX();
        int y = position.getBlockY() - this.origin.getY();
        int z = position.getBlockZ() - this.origin.getZ();
        return this.getParent().setBiome(x, y, z, biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        return this.getParent().setBiome(x -= this.origin.getX(), y -= this.origin.getY(), z -= this.origin.getZ(), biome);
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        region = region.clone();
        region.shift(BlockVector3.ZERO.subtract(this.origin));
        return this.getParent().getEntities(region).stream().map(e -> {
            if (e instanceof ClipboardEntity) {
                ClipboardEntity ce = (ClipboardEntity)e;
                Location oldloc = ce.getLocation();
                Location loc = new Location(oldloc.getExtent(), oldloc.getX() + (double)this.origin.getBlockX(), oldloc.getY() + (double)this.origin.getBlockY(), oldloc.getZ() + (double)this.origin.getBlockZ(), oldloc.getYaw(), oldloc.getPitch());
                return new ClipboardEntity(loc, ce.entity);
            }
            return e;
        }).collect(Collectors.toList());
    }

    @Override
    public List<? extends Entity> getEntities() {
        return this.getParent().getEntities().stream().map(e -> {
            if (e instanceof ClipboardEntity) {
                ClipboardEntity ce = (ClipboardEntity)e;
                Location oldloc = ce.getLocation();
                Location loc = new Location(oldloc.getExtent(), oldloc.getX() + (double)this.origin.getBlockX(), oldloc.getY() + (double)this.origin.getBlockY(), oldloc.getZ() + (double)this.origin.getBlockZ(), oldloc.getYaw(), oldloc.getPitch());
                return new ClipboardEntity(loc, ce.entity);
            }
            return e;
        }).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        Location l = new Location(location.getExtent(), location.getX() - (double)this.origin.getBlockX(), location.getY() - (double)this.origin.getBlockY(), location.getZ() - (double)this.origin.getBlockZ(), location.getYaw(), location.getPitch());
        return this.getParent().createEntity(l, entity);
    }

    @Override
    public void removeEntity(int x, int y, int z, UUID uuid) {
        this.getParent().removeEntity(x -= this.origin.getX(), y -= this.origin.getY(), z -= this.origin.getZ(), uuid);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.getParent().getBlock(x -= this.origin.getX(), y -= this.origin.getY(), z -= this.origin.getZ());
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        return this.getParent().getFullBlock(x -= this.origin.getX(), y -= this.origin.getY(), z -= this.origin.getZ());
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        return this.getParent().getBiomeType(x -= this.origin.getX(), y, z -= this.origin.getZ());
    }

    @Override
    @NotNull
    public Iterator<BlockVector3> iterator() {
        OffsetBlockVector3 mutable = new OffsetBlockVector3(this.origin);
        return Iterators.transform(this.getParent().iterator(), mutable::init);
    }

    @Override
    public Iterator<BlockVector2> iterator2d() {
        MutableBlockVector2 mutable = new MutableBlockVector2();
        return Iterators.transform(this.getParent().iterator2d(), input -> mutable.setComponents(input.getX() + this.origin.getX(), input.getZ() + this.origin.getZ()));
    }

    @Override
    public Iterator<BlockVector3> iterator(Order order) {
        OffsetBlockVector3 mutable = new OffsetBlockVector3(this.origin);
        return Iterators.transform(this.getParent().iterator(order), mutable::init);
    }

    @Override
    public BlockVector3 getDimensions() {
        return this.parent.getDimensions();
    }

    @Override
    public void removeEntity(Entity entity) {
        this.parent.removeEntity(entity);
    }

    public Clipboard getParent() {
        return this.parent;
    }

    @Override
    public void close() {
        this.parent.close();
    }

    public static class ClipboardEntity
    implements Entity {
        private final BaseEntity entity;
        private final Clipboard clipboard;
        private final double x;
        private final double y;
        private final double z;
        private final float yaw;
        private final float pitch;

        public ClipboardEntity(Location loc, BaseEntity entity) {
            this((Clipboard)loc.getExtent(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), entity);
        }

        public ClipboardEntity(Clipboard clipboard, double x, double y, double z, float yaw, float pitch, BaseEntity entity) {
            Preconditions.checkNotNull((Object)entity);
            Preconditions.checkNotNull((Object)clipboard);
            this.clipboard = clipboard;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.entity = new BaseEntity(entity);
        }

        @Override
        public boolean remove() {
            this.clipboard.removeEntity(this);
            return true;
        }

        @Override
        @Nullable
        public <T> T getFacet(Class<? extends T> cls) {
            return null;
        }

        BaseEntity getEntity() {
            return this.entity;
        }

        @Override
        public BaseEntity getState() {
            return new BaseEntity(this.entity);
        }

        @Override
        public Location getLocation() {
            return new Location(this.clipboard, this.x, this.y, this.z, this.yaw, this.pitch);
        }

        @Override
        public Extent getExtent() {
            return this.clipboard;
        }

        @Override
        public boolean setLocation(Location loc) {
            this.clipboard.removeEntity(this);
            Entity result = this.clipboard.createEntity(loc, this.entity);
            return result != null;
        }
    }
}

