/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard;

import com.boydti.fawe.beta.Filter;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.clipboard.CPUOptimizedClipboard;
import com.boydti.fawe.object.clipboard.DiskOptimizedClipboard;
import com.boydti.fawe.object.clipboard.MemoryOptimizedClipboard;
import com.boydti.fawe.object.clipboard.ReadOnlyClipboard;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.MaskTraverser;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.extent.transform.BlockTransformExtent;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.Order;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public interface Clipboard
extends Extent,
Iterable<BlockVector3>,
Closeable {
    public static Clipboard create(Region region) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)region.getWorld(), (Object)"World cannot be null (use the other constructor for the region)");
        EditSession session = new EditSessionBuilder(region.getWorld()).allowedRegionsEverywhere().autoQueue(false).build();
        return ReadOnlyClipboard.of(session, region);
    }

    public static Clipboard create(Region region, UUID uuid) {
        if (Settings.IMP.CLIPBOARD.USE_DISK) {
            return new DiskOptimizedClipboard(region, uuid);
        }
        if (Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL == 0) {
            return new CPUOptimizedClipboard(region);
        }
        return new MemoryOptimizedClipboard(region);
    }

    public Region getRegion();

    public BlockVector3 getDimensions();

    public BlockVector3 getOrigin();

    public void setOrigin(BlockVector3 var1);

    default public boolean hasBiomes() {
        return false;
    }

    public void removeEntity(Entity var1);

    default public int getWidth() {
        return this.getDimensions().getBlockX();
    }

    default public int getHeight() {
        return this.getDimensions().getBlockY();
    }

    default public int getLength() {
        return this.getDimensions().getBlockZ();
    }

    default public int getArea() {
        return this.getWidth() * this.getLength();
    }

    default public int getVolume() {
        return this.getWidth() * this.getHeight() * this.getLength();
    }

    default public Iterator<BlockVector3> iterator(Order order) {
        return order.create(this.getRegion());
    }

    @Override
    @NotNull
    default public Iterator<BlockVector3> iterator() {
        return this.getRegion().iterator();
    }

    default public Iterator<BlockVector2> iterator2d() {
        return Regions.asFlatRegion(this.getRegion()).asFlatRegion().iterator();
    }

    default public URI getURI() {
        return null;
    }

    @Override
    default public <T extends Filter> T apply(Region region, T filter, boolean full) {
        if (region.equals(this.getRegion())) {
            return this.apply(this, filter);
        }
        return this.apply(region, filter);
    }

    @Override
    default public void close() {
    }

    default public EditSession paste(World world, BlockVector3 to) {
        return this.paste(world, to, true, true, null);
    }

    default public void save(File file, ClipboardFormat format) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)format);
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            file.createNewFile();
        }
        this.save(new FileOutputStream(file), format);
    }

    default public void save(OutputStream stream, ClipboardFormat format) throws IOException {
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)format);
        try (ClipboardWriter writer = format.getWriter(stream);){
            writer.write(this);
        }
    }

    default public EditSession paste(World world, BlockVector3 to, boolean allowUndo, boolean pasteAir, @Nullable Transform transform) {
        return this.paste(world, to, allowUndo, pasteAir, true, transform);
    }

    default public EditSession paste(World world, BlockVector3 to, boolean allowUndo, boolean pasteAir, boolean copyEntities, @Nullable Transform transform) {
        EditSession editSession;
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)to);
        if (world instanceof EditSession) {
            editSession = (EditSession)((Object)world);
        } else {
            EditSessionBuilder builder = new EditSessionBuilder(world).autoQueue(true).checkMemory(false).allowedRegionsEverywhere().limitUnlimited();
            editSession = allowUndo ? builder.build() : builder.changeSetNull().fastmode(true).build();
        }
        Extent extent = this;
        Mask sourceMask = editSession.getSourceMask();
        if (transform != null && !transform.isIdentity()) {
            extent = new BlockTransformExtent(this, transform);
        } else if (sourceMask == null) {
            this.paste(editSession, to, pasteAir);
            editSession.flushQueue();
            return editSession;
        }
        ForwardExtentCopy copy = new ForwardExtentCopy(extent, this.getRegion(), this.getOrigin(), editSession, to);
        if (transform != null && !transform.isIdentity()) {
            copy.setTransform(transform);
        }
        copy.setCopyingEntities(copyEntities);
        if (sourceMask != null) {
            new MaskTraverser(sourceMask).reset(extent);
            copy.setSourceMask(sourceMask);
            editSession.setSourceMask(null);
        }
        if (!pasteAir) {
            copy.setSourceMask(new ExistingBlockMask(this));
        }
        try {
            Operations.completeLegacy(copy);
        }
        catch (MaxChangedBlocksException e) {
            e.printStackTrace();
        }
        editSession.flushQueue();
        return editSession;
    }

    default public void paste(Extent extent, BlockVector3 to, boolean pasteAir, @Nullable Transform transform) {
        EditSession editSession;
        Mask sourceMask;
        if (extent instanceof World) {
            EditSessionBuilder builder = new EditSessionBuilder((World)extent).autoQueue(true).checkMemory(false).allowedRegionsEverywhere().limitUnlimited().changeSetNull();
            extent = builder.build();
        }
        Extent source = this;
        if (transform != null && !transform.isIdentity()) {
            source = new BlockTransformExtent(this, transform);
        }
        ForwardExtentCopy copy = new ForwardExtentCopy(source, this.getRegion(), this.getOrigin(), extent, to);
        if (transform != null) {
            copy.setTransform(transform);
        }
        copy.setCopyingBiomes(this.hasBiomes());
        if (extent instanceof EditSession && (sourceMask = (editSession = (EditSession)extent).getSourceMask()) != null) {
            new MaskTraverser(sourceMask).reset(extent);
            copy.setSourceMask(sourceMask);
            editSession.setSourceMask(null);
        }
        if (!pasteAir) {
            copy.setSourceMask(new ExistingBlockMask(this));
        }
        Operations.completeBlindly(copy);
    }

    default public void paste(Extent extent, BlockVector3 to, boolean pasteAir) {
        this.paste(extent, to, pasteAir, false, false);
    }

    default public void paste(Extent extent, BlockVector3 to, boolean pasteAir, boolean pasteEntities, boolean pasteBiomes) {
        if (extent instanceof World) {
            EditSessionBuilder builder = new EditSessionBuilder((World)extent).autoQueue(true).checkMemory(false).allowedRegionsEverywhere().limitUnlimited().changeSetNull();
            extent = builder.build();
        }
        BlockVector3 origin = this.getOrigin();
        int relx = to.getBlockX() - origin.getBlockX();
        int rely = to.getBlockY() - origin.getBlockY();
        int relz = to.getBlockZ() - origin.getBlockZ();
        pasteBiomes &= this.hasBiomes();
        for (BlockVector3 pos : this) {
            BaseBlock block = pos.getFullBlock(this);
            int xx = pos.getX() + relx;
            int n = pos.getY() + rely;
            int zz = pos.getZ() + relz;
            if (pasteBiomes) {
                extent.setBiome(xx, n, zz, this.getBiome(BlockVector3.at(pos.getX(), pos.getY(), pos.getZ())));
            }
            if (!pasteAir && block.getBlockType().getMaterial().isAir()) continue;
            if (pos.getY() < 0) {
                throw new RuntimeException("Y-Position cannot be less than 0!");
            }
            extent.setBlock(xx, n, zz, block);
        }
        int entityOffsetX = to.getBlockX() - origin.getBlockX();
        int entityOffsetY = to.getBlockY() - origin.getBlockY();
        int entityOffsetZ = to.getBlockZ() - origin.getBlockZ();
        if (pasteEntities) {
            for (Entity entity : this.getEntities()) {
                if (entity.getState() != null && entity.getState().getType().getId().equals("minecraft:player")) continue;
                Location pos = entity.getLocation();
                Location newPos = new Location(pos.getExtent(), pos.getX() + (double)entityOffsetX, pos.getY() + (double)entityOffsetY, pos.getZ() + (double)entityOffsetZ, pos.getYaw(), pos.getPitch());
                extent.createEntity(newPos, entity.getState());
            }
        }
    }
}

