/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.jnbt.streamer.StreamDelegate;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.clipboard.LinearClipboard;
import com.boydti.fawe.object.io.FastByteArrayOutputStream;
import com.boydti.fawe.object.io.FastByteArraysInputStream;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.NBTSchematicReader;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public class FastSchematicReader
extends NBTSchematicReader {
    private static final Logger log = LoggerFactory.getLogger(FastSchematicReader.class);
    private final NBTInputStream inputStream;
    private DataFixer fixer;
    private int dataVersion = -1;
    private int version = -1;
    private int faweWritten = -1;
    private FastByteArrayOutputStream blocksOut;
    private FaweOutputStream blocks;
    private FastByteArrayOutputStream biomesOut;
    private FaweOutputStream biomes;
    private List<Map<String, Object>> tiles;
    private List<Map<String, Object>> entities;
    private int width;
    private int height;
    private int length;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private char[] palette;
    private char[] biomePalette;
    private BlockVector3 min = BlockVector3.ZERO;
    private boolean brokenEntities = false;
    private boolean isWorldEdit = false;

    public FastSchematicReader(NBTInputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        this.inputStream = inputStream;
        this.fixer = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getDataFixer();
    }

    public void setBrokenEntities(boolean brokenEntities) {
        this.brokenEntities = brokenEntities;
    }

    private String fix(String palettePart) {
        if (this.fixer == null || this.dataVersion == -1) {
            return palettePart;
        }
        return this.fixer.fixUp(DataFixer.FixTypes.BLOCK_STATE, palettePart, this.dataVersion);
    }

    private CompoundTag fixBlockEntity(CompoundTag tag) {
        if (this.fixer == null || this.dataVersion == -1) {
            return tag;
        }
        return this.fixer.fixUp(DataFixer.FixTypes.BLOCK_ENTITY, tag, this.dataVersion);
    }

    private CompoundTag fixEntity(CompoundTag tag) {
        if (this.fixer == null || this.dataVersion == -1) {
            return tag;
        }
        return this.fixer.fixUp(DataFixer.FixTypes.ENTITY, tag, this.dataVersion);
    }

    private String fixBiome(String biomePalettePart) {
        if (this.fixer == null || this.dataVersion == -1) {
            return biomePalettePart;
        }
        return this.fixer.fixUp(DataFixer.FixTypes.BIOME, biomePalettePart, this.dataVersion);
    }

    public StreamDelegate createVersionDelegate() {
        StreamDelegate root = new StreamDelegate();
        StreamDelegate schematic = root.add("Schematic");
        schematic.add("DataVersion").withInt((i, v) -> {
            this.dataVersion = v;
        });
        schematic.add("Version").withInt((i, v) -> {
            this.version = v;
            if (v == 1 && this.dataVersion == -1) {
                this.dataVersion = 1631;
            }
        });
        return root;
    }

    public StreamDelegate createDelegate() {
        StreamDelegate root = new StreamDelegate();
        StreamDelegate schematic = root.add("Schematic");
        schematic.add("Width").withInt((i, v) -> {
            this.width = v;
        });
        schematic.add("Height").withInt((i, v) -> {
            this.height = v;
        });
        schematic.add("Length").withInt((i, v) -> {
            this.length = v;
        });
        schematic.add("Offset").withValue((index, v) -> {
            this.min = BlockVector3.at(v[0], v[1], v[2]);
        });
        StreamDelegate metadata = schematic.add("Metadata");
        metadata.add("WEOffsetX").withInt((i, v) -> {
            this.offsetX = v;
        });
        metadata.add("WEOffsetY").withInt((i, v) -> {
            this.offsetY = v;
        });
        metadata.add("WEOffsetZ").withInt((i, v) -> {
            this.offsetZ = v;
        });
        metadata.add("FAWEVersion").withInt((i, v) -> {
            this.faweWritten = v;
        });
        StreamDelegate worldEditSection = metadata.add("WorldEdit");
        worldEditSection.withValue((index, v) -> {
            this.isWorldEdit = true;
        });
        StreamDelegate paletteDelegate = schematic.add("Palette");
        paletteDelegate.withValue((ignore, v) -> {
            this.palette = new char[v.size()];
            for (Map.Entry entry : v.entrySet()) {
                BlockState state;
                String palettePart = this.fix((String)entry.getKey());
                try {
                    state = BlockState.get(palettePart);
                }
                catch (InputParseException ignored) {
                    log.warn("Invalid BlockState in palette: " + palettePart + ". Block will be replaced with air.");
                    state = BlockTypes.AIR.getDefaultState();
                }
                int index = (Integer)entry.getValue();
                this.palette[index] = (char)state.getOrdinal();
            }
        });
        StreamDelegate blockData = schematic.add("BlockData");
        blockData.withInfo((length, type) -> {
            this.blocksOut = new FastByteArrayOutputStream();
            this.blocks = new FaweOutputStream(new LZ4BlockOutputStream(this.blocksOut));
        });
        blockData.withInt((index, value) -> this.blocks.write(value));
        StreamDelegate tilesDelegate = schematic.add("BlockEntities");
        tilesDelegate.withInfo((length, type) -> {
            this.tiles = new ArrayList<Map<String, Object>>(length);
        });
        tilesDelegate.withElem((index, tile) -> this.tiles.add((Map<String, Object>)tile));
        StreamDelegate compatTilesDelegate = schematic.add("TileEntities");
        compatTilesDelegate.withInfo((length, type) -> {
            this.tiles = new ArrayList<Map<String, Object>>(length);
        });
        compatTilesDelegate.withElem((index, tile) -> this.tiles.add((Map<String, Object>)tile));
        StreamDelegate entitiesDelegate = schematic.add("Entities");
        entitiesDelegate.withInfo((length, type) -> {
            this.entities = new ArrayList<Map<String, Object>>(length);
        });
        entitiesDelegate.withElem((index, entity) -> this.entities.add((Map<String, Object>)entity));
        StreamDelegate biomePaletteDelegate = schematic.add("BiomePalette");
        biomePaletteDelegate.withValue((ignore, v) -> {
            this.biomePalette = new char[v.size()];
            for (Map.Entry entry : v.entrySet()) {
                BiomeType biome = null;
                try {
                    String biomePalettePart = this.fixBiome((String)entry.getKey());
                    biome = BiomeTypes.get(biomePalettePart);
                }
                catch (InputParseException e) {
                    e.printStackTrace();
                }
                int index = (Integer)entry.getValue();
                this.biomePalette[index] = (char)biome.getInternalId();
            }
        });
        StreamDelegate biomeData = schematic.add("BiomeData");
        biomeData.withInfo((length, type) -> {
            this.biomesOut = new FastByteArrayOutputStream();
            this.biomes = new FaweOutputStream(new LZ4BlockOutputStream(this.biomesOut));
        });
        biomeData.withInt((index, value) -> this.biomes.write(value));
        return root;
    }

    private BlockState getBlockState(int id) {
        return BlockTypesCache.states[this.palette[id]];
    }

    private BiomeType getBiomeType(FaweInputStream fis) throws IOException {
        char biomeId = this.biomePalette[fis.readVarInt()];
        return BiomeTypes.get(biomeId);
    }

    @Override
    public Clipboard read(UUID uuid, Function<BlockVector3, Clipboard> createOutput) throws IOException {
        int y;
        int x;
        Throwable throwable;
        FaweInputStream fis;
        StreamDelegate root = this.createDelegate();
        StreamDelegate versions = this.createVersionDelegate();
        this.inputStream.mark(Integer.MAX_VALUE);
        this.inputStream.readNamedTagLazy(versions);
        this.inputStream.reset();
        this.inputStream.readNamedTagLazy(root);
        if (this.version != 1 && this.version != 2) {
            throw new IOException("This schematic version is currently not supported (" + this.version + ")");
        }
        if (this.blocks != null) {
            this.blocks.close();
        }
        if (this.biomes != null) {
            this.biomes.close();
        }
        this.blocks = null;
        this.biomes = null;
        BlockVector3 dimensions = BlockVector3.at(this.width, this.height, this.length);
        BlockVector3 origin = this.offsetX != Integer.MIN_VALUE && this.offsetY != Integer.MIN_VALUE && this.offsetZ != Integer.MIN_VALUE ? BlockVector3.at(-this.offsetX, -this.offsetY, -this.offsetZ) : BlockVector3.ZERO;
        Clipboard clipboard = createOutput.apply(dimensions);
        if (this.blocksOut != null && this.blocksOut.getSize() != 0) {
            fis = new FaweInputStream(new LZ4BlockInputStream(new FastByteArraysInputStream(this.blocksOut.toByteArrays())));
            throwable = null;
            try {
                int z;
                int ordinal;
                if (clipboard instanceof LinearClipboard) {
                    int index;
                    LinearClipboard linear = (LinearClipboard)clipboard;
                    int volume = this.width * this.height * this.length;
                    if (this.palette.length < 128) {
                        for (index = 0; index < volume; ++index) {
                            ordinal = fis.read();
                            linear.setBlock(index, this.getBlockState(ordinal));
                        }
                    } else {
                        for (index = 0; index < volume; ++index) {
                            ordinal = fis.readVarInt();
                            linear.setBlock(index, this.getBlockState(ordinal));
                        }
                    }
                } else if (this.palette.length < 128) {
                    for (int y2 = 0; y2 < this.height; ++y2) {
                        for (z = 0; z < this.length; ++z) {
                            for (x = 0; x < this.width; ++x) {
                                ordinal = fis.read();
                                clipboard.setBlock(x, y2, z, this.getBlockState(ordinal));
                            }
                        }
                    }
                } else {
                    for (int y3 = 0; y3 < this.height; ++y3) {
                        for (z = 0; z < this.length; ++z) {
                            for (x = 0; x < this.width; ++x) {
                                ordinal = fis.readVarInt();
                                clipboard.setBlock(x, y3, z, this.getBlockState(ordinal));
                            }
                        }
                    }
                }
            }
            catch (Throwable y3) {
                throwable = y3;
                throw y3;
            }
            finally {
                if (fis != null) {
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable y3) {
                            throwable.addSuppressed(y3);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        if (this.biomesOut != null && this.biomesOut.getSize() != 0) {
            fis = new FaweInputStream(new LZ4BlockInputStream(new FastByteArraysInputStream(this.biomesOut.toByteArrays())));
            throwable = null;
            try {
                for (int z = 0; z < this.length; ++z) {
                    for (int x2 = 0; x2 < this.width; ++x2) {
                        BiomeType biome = this.getBiomeType(fis);
                        for (y = 0; y < this.height; ++y) {
                            clipboard.setBiome(x2, y, z, biome);
                        }
                    }
                }
            }
            catch (Throwable z) {
                throwable = z;
                throw z;
            }
            finally {
                if (fis != null) {
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable z) {
                            throwable.addSuppressed(z);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        if (this.tiles != null && !this.tiles.isEmpty()) {
            for (Map<String, Object> tileRaw : this.tiles) {
                int z;
                CompoundTag tile = FaweCache.IMP.asTag(tileRaw);
                int[] pos = tile.getIntArray("Pos");
                if (pos.length != 3) {
                    if (!(tile.containsKey("x") && tile.containsKey("y") && tile.containsKey("z"))) {
                        return null;
                    }
                    x = tile.getInt("x");
                    y = tile.getInt("y");
                    z = tile.getInt("z");
                } else {
                    x = pos[0];
                    y = pos[1];
                    z = pos[2];
                }
                HashMap<String, Tag> values = new HashMap<String, Tag>((Map<String, Tag>)tile.getValue());
                Tag id = (Tag)values.get("Id");
                if (id != null) {
                    values.put("x", new IntTag(x));
                    values.put("y", new IntTag(y));
                    values.put("z", new IntTag(z));
                    values.put("id", id);
                }
                values.remove("Id");
                values.remove("Pos");
                clipboard.setTile(x, y, z, this.fixBlockEntity(new CompoundTag(values)));
            }
        }
        if (this.entities != null && !this.entities.isEmpty()) {
            for (Map<String, Object> entRaw : this.entities) {
                HashMap<String, Tag> value = new HashMap<String, Tag>((Map<String, Tag>)FaweCache.IMP.asTag(entRaw).getValue());
                StringTag id = (StringTag)value.get("Id");
                if (id == null && (id = (StringTag)value.get("id")) == null) continue;
                value.put("id", id);
                value.remove("Id");
                EntityType type = EntityTypes.parse(id.getValue());
                if (type != null) {
                    CompoundTag ent = this.fixEntity(new CompoundTag(value));
                    BaseEntity state = new BaseEntity(type, ent);
                    Location loc = ent.getEntityLocation(clipboard);
                    if (this.brokenEntities) {
                        clipboard.createEntity(loc, state);
                        continue;
                    }
                    if (!this.isWorldEdit && this.faweWritten == -1) {
                        int locX = loc.getBlockX();
                        int locY = loc.getBlockY();
                        int locZ = loc.getBlockZ();
                        BlockVector3 max = this.min.add(dimensions).subtract(BlockVector3.ONE);
                        if (locX < this.min.getX() || locY < this.min.getY() || locZ < this.min.getZ() || locX > max.getX() || locY > max.getY() || locZ > max.getZ()) {
                            for (Entity entity : clipboard.getEntities()) {
                                clipboard.removeEntity(entity);
                            }
                            log.error("Detected schematic entity outside clipboard region. FAWE will not load entities. Please try loading the schematic with the format \"legacyentity\"");
                            break;
                        }
                    }
                    clipboard.createEntity(loc.setPosition(loc.subtract(this.min.toVector3())), state);
                    continue;
                }
                log.debug("Invalid entity: " + id);
            }
        }
        clipboard.setOrigin(origin);
        if (!this.min.equals(BlockVector3.ZERO)) {
            clipboard = new BlockArrayClipboard(clipboard, this.min);
        }
        return clipboard;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

