/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.generator;

import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.generator.Resource;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.MutableBlockVector3;
import java.util.Random;

public class OreGen
implements Resource {
    private final int maxSize;
    private final double maxSizeO8;
    private final double maxSizeO16;
    private final double sizeInverse;
    private final int minY;
    private final int maxY;
    private final Pattern pattern;
    private final Extent extent;
    private final Mask mask;
    private MutableBlockVector3 mutable = new MutableBlockVector3();
    private final double ONE_2 = 0.5;
    private final double ONE_8 = 0.125;
    private final double ONE_16 = 0.0625;
    public int laced = 0;

    public OreGen(Extent extent, Mask mask, Pattern pattern, int size, int minY, int maxY) {
        this.maxSize = size;
        this.maxSizeO8 = (double)size * 0.125;
        this.maxSizeO16 = (double)size * 0.0625;
        this.sizeInverse = 1.0 / (double)size;
        this.minY = minY;
        this.maxY = maxY;
        this.mask = mask;
        this.pattern = pattern;
        this.extent = extent;
    }

    @Override
    public boolean spawn(Random rand, int x, int z) throws WorldEditException {
        int y = rand.nextInt(this.maxY - this.minY) + this.minY;
        if (!this.mask.test(this.mutable.setComponents(x, y, z))) {
            return false;
        }
        double f = rand.nextDouble() * Math.PI;
        double so8 = this.maxSizeO8;
        double sf = (double)MathMan.sinInexact(f) * so8;
        double cf = (double)MathMan.cosInexact(f) * so8;
        double d1 = (double)x + sf;
        double d2 = (double)x - sf;
        double d3 = (double)z + cf;
        double d4 = (double)z - cf;
        double d5 = y + rand.nextInt(3) - 2;
        double d6 = y + rand.nextInt(3) - 2;
        double xd = d2 - d1;
        double yd = d6 - d5;
        double zd = d4 - d3;
        double iFactor = 0.0;
        int i = 0;
        while (i < this.maxSize) {
            double d7 = d1 + xd * iFactor;
            double d8 = d5 + yd * iFactor;
            double d9 = d3 + zd * iFactor;
            double d10 = rand.nextDouble() * this.maxSizeO16;
            double sif = MathMan.sinInexact(Math.PI * iFactor);
            double d11 = (sif + 1.0) * d10 + 1.0;
            double d12 = (sif + 1.0) * d10 + 1.0;
            double d11o2 = d11 * 0.5;
            double d12o2 = d12 * 0.5;
            int minX = MathMan.floorZero(d7 - d11o2);
            int minY = Math.max(1, MathMan.floorZero(d8 - d12o2));
            int minZ = MathMan.floorZero(d9 - d11o2);
            int maxX = MathMan.floorZero(d7 + d11o2);
            int maxY = Math.min(255, MathMan.floorZero(d8 + d12o2));
            int maxZ = MathMan.floorZero(d9 + d11o2);
            double id11o2 = 1.0 / d11o2;
            double id12o2 = 1.0 / d12o2;
            for (int xx = minX; xx <= maxX; ++xx) {
                double dx = ((double)xx + 0.5 - d7) * id11o2;
                double dx2 = dx * dx;
                if (!(dx2 < 1.0)) continue;
                this.mutable.mutX(xx);
                for (int yy = minY; yy <= maxY; ++yy) {
                    double dy = ((double)yy + 0.5 - d8) * id12o2;
                    double dxy2 = dx2 + dy * dy;
                    if (!(dxy2 < 1.0)) continue;
                    this.mutable.mutY(yy);
                    for (int zz = minZ; zz <= maxZ; ++zz) {
                        this.mutable.mutZ(zz);
                        double dz = ((double)zz + 0.5 - d9) * id11o2;
                        double dxyz2 = dxy2 + dz * dz;
                        if (!(dxyz2 < 1.0) || !this.mask.test(this.mutable)) continue;
                        this.pattern.apply(this.extent, this.mutable, this.mutable);
                    }
                }
            }
            ++i;
            iFactor += this.sizeInverse;
        }
        return true;
    }
}

