/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.AbstractMask2D;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import javax.annotation.Nullable;

public final class Masks {
    static final AlwaysTrue ALWAYS_TRUE = new AlwaysTrue();
    static final AlwaysFalse ALWAYS_FALSE = new AlwaysFalse();

    private Masks() {
    }

    public static boolean isNull(Mask mask) {
        return mask == null || mask == ALWAYS_TRUE;
    }

    public static Mask alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static Mask alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static Mask2D alwaysTrue2D() {
        return ALWAYS_TRUE;
    }

    public static Mask negate(Mask mask) {
        return mask.inverse();
    }

    public static Mask2D negate(final Mask2D mask) {
        if (mask instanceof AlwaysTrue) {
            return ALWAYS_FALSE;
        }
        if (mask instanceof AlwaysFalse) {
            return ALWAYS_TRUE;
        }
        Preconditions.checkNotNull((Object)mask);
        return new AbstractMask2D(){

            @Override
            public boolean test(BlockVector2 vector) {
                return !mask.test(vector);
            }

            @Override
            public Mask2D copy2D() {
                return Masks.negate(mask.copy2D());
            }
        };
    }

    public static Mask asMask(final Mask2D mask) {
        return new AbstractMask(){

            @Override
            public boolean test(BlockVector3 vector) {
                return mask.test(vector.toBlockVector2());
            }

            @Override
            @Nullable
            public Mask2D toMask2D() {
                return mask;
            }

            @Override
            public Mask copy() {
                return Masks.asMask(mask.copy2D());
            }
        };
    }

    protected static class AlwaysFalse
    implements Mask,
    Mask2D {
        protected AlwaysFalse() {
        }

        @Override
        public boolean test(BlockVector3 vector) {
            return false;
        }

        @Override
        public boolean test(BlockVector2 vector) {
            return false;
        }

        @Override
        @Nullable
        public Mask2D toMask2D() {
            return this;
        }

        @Override
        public Mask tryCombine(Mask other) {
            return this;
        }

        @Override
        public Mask tryOr(Mask other) {
            return other;
        }

        @Override
        public Mask copy() {
            return new AlwaysFalse();
        }

        @Override
        public Mask2D copy2D() {
            return new AlwaysFalse();
        }
    }

    protected static class AlwaysTrue
    implements Mask,
    Mask2D {
        protected AlwaysTrue() {
        }

        @Override
        public boolean test(BlockVector3 vector) {
            return true;
        }

        @Override
        public boolean test(BlockVector2 vector) {
            return true;
        }

        @Override
        @Nullable
        public Mask2D toMask2D() {
            return this;
        }

        @Override
        public Mask tryCombine(Mask other) {
            return other;
        }

        @Override
        public Mask tryOr(Mask other) {
            return this;
        }

        @Override
        public Mask copy() {
            return new AlwaysTrue();
        }

        @Override
        public Mask2D copy2D() {
            return new AlwaysTrue();
        }
    }
}

