/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.boydti.fawe.object.collection.BlockVectorSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public abstract class BreadthFirstSearch
implements Operation {
    public static final BlockVector3[] DEFAULT_DIRECTIONS = new BlockVector3[6];
    public static final BlockVector3[] DIAGONAL_DIRECTIONS;
    private final RegionFunction function;
    private BlockVectorSet queue = new BlockVectorSet();
    private BlockVectorSet visited = new BlockVectorSet();
    private BlockVector3[] directions;
    private int affected = 0;
    private int currentDepth = 0;
    private final int maxDepth;
    private int maxBranch = Integer.MAX_VALUE;

    public BreadthFirstSearch(RegionFunction function) {
        this(function, Integer.MAX_VALUE);
        Preconditions.checkNotNull((Object)function);
    }

    public BreadthFirstSearch(RegionFunction function, int maxDepth) {
        Preconditions.checkNotNull((Object)function);
        this.function = function;
        this.directions = DEFAULT_DIRECTIONS;
        this.maxDepth = maxDepth;
    }

    public void setDirections(BlockVector3 ... directions) {
        this.directions = directions;
    }

    public void setDirections(Collection<BlockVector3> directions) {
        this.setDirections(directions.toArray(new BlockVector3[0]));
    }

    public Collection<BlockVector3> getDirections() {
        return Arrays.asList(this.directions);
    }

    public void addAxes() {
        HashSet set = Sets.newHashSet((Object[])this.directions);
        set.add(BlockVector3.UNIT_MINUS_Y);
        set.add(BlockVector3.UNIT_Y);
        set.add(BlockVector3.UNIT_MINUS_X);
        set.add(BlockVector3.UNIT_X);
        set.add(BlockVector3.UNIT_MINUS_Z);
        set.add(BlockVector3.UNIT_Z);
        this.setDirections(set);
    }

    public void addDiagonal() {
        HashSet set = Sets.newHashSet((Object[])this.directions);
        set.add(Direction.NORTHEAST.toBlockVector());
        set.add(Direction.SOUTHEAST.toBlockVector());
        set.add(Direction.SOUTHWEST.toBlockVector());
        set.add(Direction.NORTHWEST.toBlockVector());
        this.setDirections(set);
    }

    public void visit(BlockVector3 position) {
        if (!this.visited.contains(position)) {
            this.queue.add(position);
            this.visited.add(position);
        }
    }

    private void visit(BlockVector3 from, BlockVector3 to) {
        if (!this.visited.contains(to)) {
            this.visited.add(to);
            if (this.isVisitable(from, to)) {
                this.queue.add(to);
            }
        }
    }

    public void setVisited(BlockVectorSet set) {
        this.visited = set;
    }

    public BlockVectorSet getVisited() {
        return this.visited;
    }

    public boolean isVisited(BlockVector3 pos) {
        return this.visited.contains(pos);
    }

    public void setMaxBranch(int maxBranch) {
        this.maxBranch = maxBranch;
    }

    protected abstract boolean isVisitable(BlockVector3 var1, BlockVector3 var2);

    public int getAffected() {
        return this.affected;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        MutableBlockVector3 mutable = new MutableBlockVector3();
        BlockVector3[] dirs = this.directions;
        BlockVectorSet tempQueue = new BlockVectorSet();
        this.currentDepth = 0;
        while (!this.queue.isEmpty() && this.currentDepth <= this.maxDepth) {
            for (BlockVector3 from : this.queue) {
                if (this.function.apply(from)) {
                    ++this.affected;
                }
                int j = 0;
                for (int i = 0; i < dirs.length && j < this.maxBranch; ++i) {
                    int z;
                    int x;
                    BlockVector3 direction = dirs[i];
                    int y = from.getBlockY() + direction.getY();
                    if (y < 0 || y >= 256 || this.visited.contains(x = from.getBlockX() + direction.getX(), y, z = from.getBlockZ() + direction.getZ()) || !this.isVisitable(from, mutable.setComponents(x, y, z))) continue;
                    ++j;
                    this.visited.add(x, y, z);
                    tempQueue.add(x, y, z);
                }
            }
            if (this.currentDepth == this.maxDepth) break;
            BlockVectorSet tmp = this.queue;
            this.queue = tempQueue;
            tmp.clear();
            tempQueue = tmp;
            ++this.currentDepth;
        }
        return null;
    }

    public int getDepth() {
        return this.currentDepth;
    }

    @Override
    public void cancel() {
        this.queue.clear();
        this.visited.clear();
        this.affected = 0;
    }

    @Override
    public Iterable<Component> getStatusMessages() {
        return ImmutableList.of((Object)TranslatableComponent.of("worldedit.operation.affected.block", TextComponent.of(this.getAffected())).color(TextColor.GRAY));
    }

    static {
        BreadthFirstSearch.DEFAULT_DIRECTIONS[0] = BlockVector3.at(0, -1, 0);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[1] = BlockVector3.at(0, 1, 0);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[2] = BlockVector3.at(-1, 0, 0);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[3] = BlockVector3.at(1, 0, 0);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[4] = BlockVector3.at(0, 0, -1);
        BreadthFirstSearch.DEFAULT_DIRECTIONS[5] = BlockVector3.at(0, 0, 1);
        ArrayList<BlockVector3> list = new ArrayList<BlockVector3>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockVector3 pos;
                    if (x == 0 && y == 0 && z == 0 || list.contains(pos = BlockVector3.at(x, y, z))) continue;
                    list.add(pos);
                }
            }
        }
        list.sort((o1, o2) -> (int)Math.signum(o1.lengthSq() - o2.lengthSq()));
        DIAGONAL_DIRECTIONS = list.toArray(new BlockVector3[0]);
    }
}

