/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import com.sk89q.worldedit.math.BlockVector3;

public class DirectionalVisitor
extends RecursiveVisitor {
    private final BlockVector3 origin;
    private final BlockVector3 dirVec;

    public DirectionalVisitor(Mask mask, RegionFunction function, BlockVector3 origin, BlockVector3 direction) {
        this(mask, function, origin, direction, Integer.MAX_VALUE);
    }

    public DirectionalVisitor(Mask mask, RegionFunction function, BlockVector3 origin, BlockVector3 direction, int distance) {
        super(mask, function, distance);
        Preconditions.checkNotNull((Object)mask);
        this.origin = origin;
        this.dirVec = direction;
        this.setDirections(BlockVector3.at(1, 0, 0), BlockVector3.at(-1, 0, 0), BlockVector3.at(0, 0, 1), BlockVector3.at(0, 0, -1), BlockVector3.at(0, -1, 0), BlockVector3.at(0, 1, 0));
    }

    @Override
    public boolean isVisitable(BlockVector3 from, BlockVector3 to) {
        int dx = to.getBlockX() - from.getBlockX();
        int dz = to.getBlockZ() - from.getBlockZ();
        int dy = to.getBlockY() - from.getBlockY();
        if (dx != 0 && this.dirVec.getBlockX() != 0 && this.dirVec.getBlockX() != dx) {
            return false;
        }
        if (dy != 0 && this.dirVec.getBlockY() != 0 && this.dirVec.getBlockY() != dy) {
            return false;
        }
        if (dz != 0 && this.dirVec.getBlockZ() != 0 && this.dirVec.getBlockZ() != dz) {
            return false;
        }
        return super.isVisitable(from, to);
    }
}

