/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import com.sk89q.worldedit.math.BlockVector3;

public class DownwardVisitor
extends RecursiveVisitor {
    private int baseY;

    public DownwardVisitor(Mask mask, RegionFunction function, int baseY) {
        this(mask, function, baseY, Integer.MAX_VALUE);
    }

    public DownwardVisitor(Mask mask, RegionFunction function, int baseY, int depth) {
        super(mask, function, depth);
        Preconditions.checkNotNull((Object)mask);
        this.baseY = baseY;
        this.setDirections(BlockVector3.UNIT_X, BlockVector3.UNIT_MINUS_X, BlockVector3.UNIT_Z, BlockVector3.UNIT_MINUS_Z, BlockVector3.UNIT_MINUS_Y);
    }

    @Override
    protected boolean isVisitable(BlockVector3 from, BlockVector3 to) {
        int fromY = from.getBlockY();
        return (fromY == this.baseY || to.subtract(from).getBlockY() < 0) && super.isVisitable(from, to);
    }
}

