/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectOpenHashMap;
import com.sk89q.worldedit.bukkit.fastutil.longs.LongArraySet;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ScanChunk {
    public static final BlockVector3[] DEFAULT_DIRECTIONS = new BlockVector3[6];
    public static final BlockVector3[] DIAGONAL_DIRECTIONS;
    private static final int MAX_QUEUE = 34816;
    private final RegionFunction function;
    private final BlockVector3[] directions;
    private final Long2ObjectOpenHashMap<long[][]> visits;
    private final Long2ObjectOpenHashMap<char[][]> queues;
    private ConcurrentLinkedQueue<char[]> queuePool = new ConcurrentLinkedQueue();

    public ScanChunk(RegionFunction function) {
        this.function = function;
        this.directions = DEFAULT_DIRECTIONS;
        this.queues = new Long2ObjectOpenHashMap();
        this.visits = new Long2ObjectOpenHashMap();
    }

    public static long pairInt(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    public boolean isVisited(int x, int y, int z) {
        int X = x >> 4;
        int Z = z >> 4;
        long pair = ScanChunk.pairInt(X, Z);
        long[][] chunk = this.visits.get(pair);
        if (chunk == null) {
            return false;
        }
        int layer = y >> 4;
        long[] section = chunk[layer];
        if (section == null) {
            return false;
        }
        return this.get(section, this.getLocalIndex(x & 0xF, y & 0xF, z & 0xF));
    }

    public void start(int x, int y, int z) {
        if (!this.isVisited(x, y, z)) {
            this.push(x, y, z);
            this.visit(x, y, z);
        }
    }

    public void visit(int x, int y, int z) {
        int layer;
        long[] section;
        int X = x >> 4;
        int Z = z >> 4;
        long pair = ScanChunk.pairInt(X, Z);
        Object arrs = this.visits.get(pair);
        if (arrs == null) {
            long[][] lArrayArray = new long[16][];
            arrs = lArrayArray;
            this.visits.put(pair, (long[][])lArrayArray);
        }
        if ((section = arrs[layer = y >> 4]) == null) {
            section = new long[64];
            arrs[layer] = section;
        }
        this.set(section, this.getLocalIndex(x & 0xF, y & 0xF, z & 0xF));
    }

    private char[] getOrCreateQueue(long pair, int layer) {
        char[] section;
        Object arrs = this.queues.get(pair);
        if (arrs == null) {
            char[][] cArrayArray = new char[16][];
            arrs = cArrayArray;
            this.queues.put(pair, (char[][])cArrayArray);
        }
        if ((section = arrs[layer]) == null) {
            section = this.newQueue();
            arrs[layer] = section;
        }
        return section;
    }

    private void push(int x, int y, int z) {
        int X = x >> 4;
        int Z = z >> 4;
        long pair = ScanChunk.pairInt(X, Z);
        int layer = y >> 4;
        char[] section = this.getOrCreateQueue(pair, layer);
        this.push(section, x & 0xF, y & 0xF, z & 0xF);
    }

    private void push(char[] queue, int x, int y, int z) {
        char indexStart = queue[0];
        char indexEnd = queue[1];
        this.push(indexStart, indexEnd, queue, x, y, z);
    }

    private void push(char indexStart, char indexEnd, char[] queue, int x, int y, int z) {
        char index = this.getLocalIndex(x, y, z);
        if (indexStart > '\u0002') {
            queue[0] = indexStart = (char)(indexStart - '\u0001');
            queue[indexStart] = index;
        } else {
            queue[indexEnd] = index;
            queue[0] = indexEnd = (char)(indexEnd + '\u0001');
        }
    }

    public void process() {
        LongArraySet set = new LongArraySet();
    }

    private char[] newQueue() {
        char[] arr = this.queuePool.poll();
        if (arr != null) {
            arr[0] = 2;
            arr[1] = 2;
            return arr;
        }
        return new char[4096];
    }

    public void process4(int xx, int yy, int zz, char[] queue, long[] visit) {
        int index;
        while ((index = queue[0]) != queue[1]) {
            int x2;
            int x1;
            queue[0] = (char)(queue[0] + '\u0001');
            char triple = queue[index];
            int x = index & 0xF;
            int z = index >> 4 & 0xF;
            int y = index >> 8;
            int absX = xx + x;
            int absY = yy + y;
            int absZ = zz + z;
            this.apply(xx + x, yy + y, zz + z);
            int i1 = index;
            for (x1 = x; x1 >= 0 && !this.get(visit, i1); --x1) {
                this.set(visit, i1);
                --i1;
            }
            ++i1;
            ++x1;
            int i2 = index;
            for (x2 = x; x2 <= 15 && !this.get(visit, i2); ++x2) {
                this.set(visit, i2);
                ++i2;
            }
            --i2;
            --x2;
        }
    }

    public void apply(int x, int y, int z) {
    }

    public void process4(int chunkX, int chunkZ, char[][] queues, long[][] visit) {
        boolean empty;
        int xx = chunkX << 4;
        int zz = chunkZ << 4;
        BlockVector3[] dirs = this.directions;
        char[][] dirQueues = new char[this.directions.length][];
        do {
            empty = true;
            for (int layer = 0; layer < 16; ++layer) {
                char index;
                char[] queue = queues[layer];
                if (queue == null) continue;
                while ((index = queue[0]) != queue[1]) {
                    queue[0] = (char)(queue[0] + '\u0001');
                    char triple = queue[index];
                    int x = index & 0xF;
                    int z = index >> 4 & 0xF;
                    int n = index >> 8;
                }
                this.queuePool.add(queue);
                queues[layer] = null;
            }
        } while (!empty);
    }

    public void set(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << (i & 0x3F);
    }

    public boolean get(long[] bits, int i) {
        return (bits[i >> 6] & 1L << (i & 0x3F)) != 0L;
    }

    public char getLocalIndex(int x, int y, int z) {
        return (char)(x + (z << 4) + (y << 8));
    }

    static {
        ScanChunk.DEFAULT_DIRECTIONS[0] = BlockVector3.at(0, -1, 0);
        ScanChunk.DEFAULT_DIRECTIONS[1] = BlockVector3.at(0, 1, 0);
        ScanChunk.DEFAULT_DIRECTIONS[2] = BlockVector3.at(-1, 0, 0);
        ScanChunk.DEFAULT_DIRECTIONS[3] = BlockVector3.at(1, 0, 0);
        ScanChunk.DEFAULT_DIRECTIONS[4] = BlockVector3.at(0, 0, -1);
        ScanChunk.DEFAULT_DIRECTIONS[5] = BlockVector3.at(0, 0, 1);
        ArrayList<BlockVector3> list = new ArrayList<BlockVector3>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockVector3 pos;
                    if (x == 0 && y == 0 && z == 0 || list.contains(pos = BlockVector3.at(x, y, z))) continue;
                    list.add(pos);
                }
            }
        }
        list.sort((o1, o2) -> (int)Math.signum(o1.lengthSq() - o2.lengthSq()));
        DIAGONAL_DIRECTIONS = list.toArray(new BlockVector3[0]);
    }
}

