/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.math.convolution;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.convolution.HeightMapFilter;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.registry.state.PropertyGroup;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Iterator;
import javax.annotation.Nullable;

public class HeightMap {
    private final boolean layers;
    private int[] data;
    private boolean[] invalid;
    private final int width;
    private final int height;
    private final Region region;
    private final EditSession session;

    public HeightMap(EditSession session, Region region) {
        this(session, region, (Mask)null, false);
    }

    public HeightMap(EditSession session, Region region, @Nullable Mask mask) {
        this(session, region, mask, false);
    }

    public HeightMap(EditSession session, Region region, @Nullable Mask mask, boolean layers) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)region);
        this.session = session;
        this.region = region;
        this.width = region.getWidth();
        this.height = region.getLength();
        this.layers = layers;
        int minX = region.getMinimumPoint().getBlockX();
        int minY = region.getMinimumPoint().getBlockY();
        int minZ = region.getMinimumPoint().getBlockZ();
        int maxY = region.getMaximumPoint().getBlockY();
        this.data = new int[this.width * this.height];
        this.invalid = new boolean[this.data.length];
        if (layers) {
            BlockVector3 min = region.getMinimumPoint();
            int bx = min.getBlockX();
            int bz = min.getBlockZ();
            Iterator<BlockVector2> flat = Regions.asFlatRegion(region).asFlatRegion().iterator();
            int layer = 0;
            while (flat.hasNext()) {
                BlockVector2 pos = flat.next();
                int x = pos.getBlockX();
                int z = pos.getBlockZ();
                this.data[(z - bz) * this.width + (x - bx)] = layer = session.getNearestSurfaceLayer(x, z, layer + 7 >> 3, 0, maxY);
            }
        } else {
            int index = 0;
            int yTmp = 255;
            for (int z = 0; z < this.height; ++z) {
                int x = 0;
                while (x < this.width) {
                    yTmp = mask != null ? session.getNearestSurfaceTerrainBlock(x + minX, z + minZ, yTmp, minY, maxY, Integer.MIN_VALUE, Integer.MAX_VALUE, mask) : session.getNearestSurfaceTerrainBlock(x + minX, z + minZ, yTmp, minY, maxY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    switch (yTmp) {
                        case -2147483648: {
                            yTmp = minY;
                            this.invalid[index] = true;
                            break;
                        }
                        case 0x7FFFFFFF: {
                            yTmp = maxY;
                            this.invalid[index] = true;
                            break;
                        }
                    }
                    this.data[index] = yTmp;
                    ++x;
                    ++index;
                }
            }
        }
    }

    @Deprecated
    public HeightMap(EditSession session, Region region, int[] data, boolean layers) {
        this.session = session;
        this.region = region;
        this.width = region.getWidth();
        this.height = region.getLength();
        this.data = data;
        this.layers = layers;
    }

    public int applyFilter(HeightMapFilter filter, int iterations) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)filter);
        int[] newData = new int[this.data.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        for (int i = 0; i < iterations; ++i) {
            newData = filter.filter(newData, this.width, this.height);
        }
        return this.layers ? this.applyLayers(newData) : this.apply(newData);
    }

    public int applyLayers(int[] data) {
        Preconditions.checkNotNull((Object)data);
        BlockVector3 minY = this.region.getMinimumPoint();
        int originX = minY.getBlockX();
        int originZ = minY.getBlockZ();
        int maxY = this.region.getMaximumPoint().getBlockY();
        BlockState fillerAir = BlockTypes.AIR.getDefaultState();
        int blocksChanged = 0;
        BlockState tmpBlock = BlockTypes.AIR.getDefaultState();
        int maxY4 = maxY << 4;
        int index = 0;
        for (int z = 0; z < this.height; ++z) {
            int zr = z + originZ;
            for (int x = 0; x < this.width; ++x) {
                if (this.invalid != null && this.invalid[index]) continue;
                int curHeight = this.data[index];
                int newHeight = Math.min(maxY4, data[index++]);
                int curBlock = curHeight >> 4;
                int newBlock = newHeight + 15 >> 4;
                int xr = x + originX;
                if (newHeight > curHeight) {
                    BlockStateHolder<BlockState> existing = this.session.getBlock(xr, curBlock, zr);
                    if (!existing.getBlockType().getMaterial().isMovementBlocker()) continue;
                    int setY = newBlock - 1;
                    int getY = curBlock;
                    while (setY >= curBlock) {
                        BlockState get = this.session.getBlock(xr, getY, zr);
                        if (get != BlockTypes.AIR.getDefaultState()) {
                            tmpBlock = get;
                        }
                        this.session.setBlock(xr, setY, zr, tmpBlock);
                        ++blocksChanged;
                        --setY;
                        --getY;
                    }
                    int setData = newHeight & 0xF;
                    if (setData != 0) {
                        existing = PropertyGroup.LEVEL.set(existing, setData - 1);
                        this.session.setBlock(xr, newBlock, zr, existing);
                        ++blocksChanged;
                        continue;
                    }
                    existing = PropertyGroup.LEVEL.set(existing, 15);
                    this.session.setBlock(xr, newBlock, zr, existing);
                    ++blocksChanged;
                    continue;
                }
                if (curHeight <= newHeight) continue;
                for (int y = newBlock + 1; y <= curHeight + 15 >> 4; ++y) {
                    this.session.setBlock(xr, y, zr, fillerAir);
                    ++blocksChanged;
                }
                int setData = newHeight & 0xF;
                BlockStateHolder<BlockState> existing = this.session.getBlock(xr, curBlock, zr);
                if (setData != 0) {
                    existing = PropertyGroup.LEVEL.set(existing, setData - 1);
                    this.session.setBlock(xr, newBlock, zr, existing);
                } else {
                    existing = PropertyGroup.LEVEL.set(existing, 15);
                    this.session.setBlock(xr, newBlock, zr, existing);
                }
                ++blocksChanged;
            }
        }
        return blocksChanged;
    }

    public int apply(int[] data) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)data);
        BlockVector3 minY = this.region.getMinimumPoint();
        int originX = minY.getBlockX();
        int originY = minY.getBlockY();
        int originZ = minY.getBlockZ();
        int maxY = this.region.getMaximumPoint().getBlockY();
        BlockState fillerAir = BlockTypes.AIR.getDefaultState();
        int blocksChanged = 0;
        BlockState tmpBlock = BlockTypes.AIR.getDefaultState();
        int index = 0;
        for (int z = 0; z < this.height; ++z) {
            int zr = z + originZ;
            int x = 0;
            while (x < this.width) {
                if (this.invalid == null || !this.invalid[index]) {
                    int curHeight = this.data[index];
                    int newHeight = Math.min(maxY, data[index]);
                    int xr = x + originX;
                    if (newHeight > curHeight) {
                        BlockState existing = this.session.getBlock(xr, curHeight, zr);
                        if (existing.getBlockType().getMaterial().isMovementBlocker()) {
                            int y0;
                            int setY = y0 = newHeight - 1;
                            int getY = curHeight - 1;
                            while (setY >= curHeight) {
                                BlockState get = getY >= 0 && getY < 256 ? this.session.getBlock(xr, getY, zr) : BlockTypes.AIR.getDefaultState();
                                if (get != BlockTypes.AIR.getDefaultState()) {
                                    tmpBlock = get;
                                }
                                this.session.setBlock(xr, setY, zr, tmpBlock);
                                ++blocksChanged;
                                --setY;
                                --getY;
                            }
                            this.session.setBlock(xr, newHeight, zr, existing);
                            ++blocksChanged;
                        }
                    } else if (curHeight > newHeight) {
                        this.session.setBlock(xr, newHeight, zr, this.session.getBlock(xr, curHeight, zr));
                        ++blocksChanged;
                        for (int y = newHeight + 1; y <= curHeight; ++y) {
                            this.session.setBlock(xr, y, zr, fillerAir);
                            ++blocksChanged;
                        }
                    }
                }
                ++x;
                ++index;
            }
        }
        return blocksChanged;
    }
}

