/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry;

import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.registry.RegistryItem;
import java.util.HashSet;
import java.util.Set;

public abstract class Category<T extends Keyed>
implements RegistryItem {
    private final Set<T> set = new HashSet<T>();
    protected final String id;
    private boolean empty = true;
    private int internalId;

    protected Category(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public final Set<T> getAll() {
        if (this.empty) {
            this.set.addAll(this.load());
            this.empty = false;
        }
        return this.set;
    }

    @Override
    public void setInternalId(int internalId) {
        this.internalId = internalId;
    }

    @Override
    public int getInternalId() {
        return this.internalId;
    }

    protected abstract Set<T> load();

    public boolean contains(T object) {
        return this.getAll().contains(object);
    }

    public void invalidateCache() {
        this.set.clear();
        this.empty = true;
    }

    public String toString() {
        return this.getId();
    }
}

